
''' Generated by OTF2 Template Engine '''

import ctypes

from .Config import EnumBase, EnumBitset

@otf2 with v = version
VERSION_MAJOR = @@v.major@@
VERSION_MINOR = @@v.minor@@
VERSION_BUGFIX = @@v.bugfix@@
VERSION_SUFFIX = "@@v.suffix@@"
VERSION = "@@v@@"
@otf2 endwith

# Symbols for undefined values

UNDEFINED_UINT8 = ctypes.c_uint8(-1)
UNDEFINED_INT8 = ctypes.c_int8(0x80)
UNDEFINED_UINT16 = ctypes.c_uint16(-1)
UNDEFINED_INT16 = ctypes.c_int16(0x8000)
UNDEFINED_UINT32 = ctypes.c_uint32(-1)
UNDEFINED_INT32 = ctypes.c_int32(0x80000000)
UNDEFINED_UINT64 = ctypes.c_uint64(-1)
UNDEFINED_INT64 = ctypes.c_int64(0x8000000000000000)

UNDEFINED_TYPE = UNDEFINED_UINT8

# Handle Typedefs

TimeStamp = ctypes.c_uint64
UNDEFINED_TIMESTAMP = UNDEFINED_UINT64

@otf2 for def in defs|referable_defs|first_born_defs:
@@def.self_attr.type.py_ctype@@ = @@def.self_attr.type.py_underlying_ctype@@
UNDEFINED_@@def.ref_upper@@ = @@def.self_attr.type.py_ctype@@(UNDEFINED_@@def.self_attr.type.otf2|upper@@.value)

@otf2 endfor
CHUNK_SIZE_MIN = ctypes.c_uint64(256 * 1024)

CHUNK_SIZE_MAX = ctypes.c_uint64(1024 * 1024 * 16)

class FileMode(EnumBase, ctypes.c_uint8):
    pass

FILEMODE_WRITE = FileMode._construct(0, "WRITE")
FILEMODE_READ = FileMode._construct(1, "READ")
FILEMODE_MODIFY = FileMode._construct(2, "MODIFY")

class Compression(EnumBase, ctypes.c_uint8):
    pass

COMPRESSION_UNDEFINED = Compression._construct(0, "UNDEFINED")
COMPRESSION_NONE = Compression._construct(1, "NONE")
COMPRESSION_ZLIB = Compression._construct(2, "ZLIB")

# CallbackCode is even an enum on the C-Side
# usually used as return value, evtl. should be a restype method?
class CallbackCode(EnumBase, ctypes.c_int):
    pass

CALLBACK_SUCCESS = CallbackCode._construct(0, "SUCCESS")
CALLBACK_INTERRUPT = CallbackCode._construct(1, "INTERRUPT")
CALLBACK_ERROR = CallbackCode._construct(1, "ERROR")

class FlushType(EnumBase, ctypes.c_uint8):
    pass

NO_FLUSH = FlushType._construct(0, "NO_FLUSH")
FLUSH = FlushType._construct(1, "FLUSH")

class Hint(EnumBase, ctypes.c_uint8):
    pass

HINT_GLOBAL_READER = Hint._construct(0, "GLOBAL_READER")

@otf2 for enum in enums|general_enums:
@otf2  if enum is bitset_enum:
class @@enum.type.py_ctype@@(EnumBitset, @@enum.type.py_underlying_ctype@@):
@otf2  else:
class @@enum.type.py_ctype@@(EnumBase, @@enum.type.py_underlying_ctype@@):
@otf2  endif
    pass

@otf2  for entry in enum.entries|py_def_enum_entries:
@@entry.name[5:]@@ = @@enum.type.py_ctype@@._construct(@@entry.value@@, "@@entry.suffix@@")
@otf2  endfor
@otf2  if enum has terminator:
@@enum.terminator.name[5:]@@ = @@enum.type.py_ctype@@(@@enum.terminator.value@@)
@otf2  endif

@otf2 endfor
//@ This is a special case because TRUE is LITERALLY defined as '!OTF2_FALSE'
TRUE = Boolean._construct(1, "TRUE")

__all__ = [
    'VERSION_MAJOR',
    'VERSION_MINOR',
    'VERSION_BUGFIX',
    'VERSION_SUFFIX',
    'VERSION',
    'UNDEFINED_UINT8',
    'UNDEFINED_INT8',
    'UNDEFINED_UINT16',
    'UNDEFINED_INT16',
    'UNDEFINED_UINT32',
    'UNDEFINED_INT32',
    'UNDEFINED_UINT64',
    'UNDEFINED_INT64',
    'UNDEFINED_TYPE',
    'TimeStamp',
    'UNDEFINED_TIMESTAMP',
    @otf2 for def in defs|referable_defs|first_born_defs
    '@@def.self_attr.type.py_ctype@@',
    'UNDEFINED_@@def.ref_upper@@',
    @otf2 endfor
    'CHUNK_SIZE_MIN',
    'CHUNK_SIZE_MAX',
    'FileMode',
    'FILEMODE_WRITE',
    'FILEMODE_READ',
    'FILEMODE_MODIFY',
    'Compression',
    'COMPRESSION_UNDEFINED',
    'COMPRESSION_NONE',
    'COMPRESSION_ZLIB',
    'CallbackCode',
    'CALLBACK_SUCCESS',
    'CALLBACK_INTERRUPT',
    'CALLBACK_ERROR',
    'FlushType',
    'NO_FLUSH',
    'FLUSH',
    @otf2 for enum in enums|general_enums:
    '@@enum.type.py_ctype@@',
    @otf2 for entry in enum.entries:
    '@@entry.name[5:]@@',
    @otf2 endfor
    @otf2 if enum has terminator:
    '@@enum.terminator.name[5:]@@',
    @otf2 endif
    @otf2 endfor
    'Hint',
    'HINT_GLOBAL_READER'
]
