
''' Generated by OTF2 Template Engine '''

import ctypes
import traceback
import sys

from .Config import conf, StrParam
from .ErrorCodes import ErrorCode, HandleErrorCode
from .GeneralDefinitions import *
from .AttributeList import AttributeList
from .Definitions import *
from .Events import *
from .Callbacks import callback_wrapper


class GlobalEvtReaderCallbacks(ctypes.Structure):
    pass

def GlobalEvtReaderCallbacks_New():
    c_New = conf.lib.OTF2_GlobalEvtReaderCallbacks_New
    c_New.argtypes = []
    c_New.restype = ctypes.POINTER(GlobalEvtReaderCallbacks)
    # NOTE: Do not errcheck here. This function returns a value, not an error code
    return c_New()

def GlobalEvtReaderCallbacks_Delete(globalEvtReaderCallbacks):
    c_Delete = conf.lib.OTF2_GlobalEvtReaderCallbacks_Delete
    c_Delete.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks) ]
    c_Delete.restype = None
    return c_Delete(globalEvtReaderCallbacks)

def GlobalEvtReaderCallbacks_Clear(globalEvtReaderCallbacks):
    c_Clear = conf.lib.OTF2_GlobalEvtReaderCallbacks_Clear
    c_Clear.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks) ]
    c_Clear.restype = None
    return c_Clear(globalEvtReaderCallbacks)

def _callback_wrapper(type, func, convert_args=None):
    def wrapper(location, time, userData, attribute_list, *args):
        if userData:
            py_userData = ctypes.cast(userData, ctypes.py_object).value
        else:
            py_userData = None
        try:
            if convert_args is not None:
                args = convert_args(*args)
            if not attribute_list:
                attribute_list = None
            ret = func(location, time, py_userData, attribute_list, *args)
            if ret is None:
                ret = CALLBACK_SUCCESS
        except:
            sys.stderr.write("An unhandled python exception has occurred in an "
                             "OTF2_GlobalEvtReaderCallback:\n")
            sys.stderr.write(traceback.format_exc())
            ret = CALLBACK_ERROR
        return ret.value
    return callback_wrapper(func, wrapper, type)

_GlobalEvtReaderCallback_FP_Unknown = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList))

_GlobalEvtReaderCallback_FP_BufferFlush = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp)

_GlobalEvtReaderCallback_FP_MeasurementOnOff = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), MeasurementMode)

_GlobalEvtReaderCallback_FP_Enter = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RegionRef)

_GlobalEvtReaderCallback_FP_Leave = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RegionRef)

_GlobalEvtReaderCallback_FP_MpiSend = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_MpiIsend = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_MpiIsendComplete = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_MpiIrecvRequest = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_MpiRecv = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_MpiIrecv = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_MpiRequestTest = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_MpiRequestCancelled = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_MpiCollectiveBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList))

_GlobalEvtReaderCallback_FP_MpiCollectiveEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CollectiveOp, CommRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_OmpFork = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32)

_GlobalEvtReaderCallback_FP_OmpJoin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList))

_GlobalEvtReaderCallback_FP_OmpAcquireLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32, ctypes.c_uint32)

_GlobalEvtReaderCallback_FP_OmpReleaseLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32, ctypes.c_uint32)

_GlobalEvtReaderCallback_FP_OmpTaskCreate = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_OmpTaskSwitch = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_OmpTaskComplete = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_Metric = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), MetricRef, ctypes.c_uint8, ctypes.POINTER(Type), ctypes.POINTER(MetricValue))

_GlobalEvtReaderCallback_FP_ParameterString = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ParameterRef, StringRef)

_GlobalEvtReaderCallback_FP_ParameterInt = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ParameterRef, ctypes.c_int64)

_GlobalEvtReaderCallback_FP_ParameterUnsignedInt = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ParameterRef, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_RmaWinCreate = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef)

_GlobalEvtReaderCallback_FP_RmaWinDestroy = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef)

_GlobalEvtReaderCallback_FP_RmaCollectiveBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList))

_GlobalEvtReaderCallback_FP_RmaCollectiveEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CollectiveOp, RmaSyncLevel, RmaWinRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_RmaGroupSync = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaSyncLevel, RmaWinRef, GroupRef)

_GlobalEvtReaderCallback_FP_RmaRequestLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, ctypes.c_uint64, LockType)

_GlobalEvtReaderCallback_FP_RmaAcquireLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, ctypes.c_uint64, LockType)

_GlobalEvtReaderCallback_FP_RmaTryLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, ctypes.c_uint64, LockType)

_GlobalEvtReaderCallback_FP_RmaReleaseLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_RmaSync = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, RmaSyncType)

_GlobalEvtReaderCallback_FP_RmaWaitChange = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef)

_GlobalEvtReaderCallback_FP_RmaPut = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_RmaGet = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_RmaAtomic = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, RmaAtomicType, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_RmaOpCompleteBlocking = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_RmaOpCompleteNonBlocking = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_RmaOpTest = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_RmaOpCompleteRemote = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_ThreadFork = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), Paradigm, ctypes.c_uint32)

_GlobalEvtReaderCallback_FP_ThreadJoin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), Paradigm)

_GlobalEvtReaderCallback_FP_ThreadTeamBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef)

_GlobalEvtReaderCallback_FP_ThreadTeamEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef)

_GlobalEvtReaderCallback_FP_ThreadAcquireLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), Paradigm, ctypes.c_uint32, ctypes.c_uint32)

_GlobalEvtReaderCallback_FP_ThreadReleaseLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), Paradigm, ctypes.c_uint32, ctypes.c_uint32)

_GlobalEvtReaderCallback_FP_ThreadTaskCreate = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint32, ctypes.c_uint32)

_GlobalEvtReaderCallback_FP_ThreadTaskSwitch = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint32, ctypes.c_uint32)

_GlobalEvtReaderCallback_FP_ThreadTaskComplete = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint32, ctypes.c_uint32)

_GlobalEvtReaderCallback_FP_ThreadCreate = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_ThreadBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_ThreadWait = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_ThreadEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_CallingContextEnter = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CallingContextRef, ctypes.c_uint32)

_GlobalEvtReaderCallback_FP_CallingContextLeave = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CallingContextRef)

_GlobalEvtReaderCallback_FP_CallingContextSample = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CallingContextRef, ctypes.c_uint32, InterruptGeneratorRef)

_GlobalEvtReaderCallback_FP_IoCreateHandle = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, IoAccessMode, IoCreationFlag, IoStatusFlag)

_GlobalEvtReaderCallback_FP_IoDestroyHandle = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef)

_GlobalEvtReaderCallback_FP_IoDuplicateHandle = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, IoHandleRef, IoStatusFlag)

_GlobalEvtReaderCallback_FP_IoSeek = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, ctypes.c_int64, IoSeekOption, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_IoChangeStatusFlags = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, IoStatusFlag)

_GlobalEvtReaderCallback_FP_IoDeleteFile = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoParadigmRef, IoFileRef)

_GlobalEvtReaderCallback_FP_IoOperationBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, IoOperationMode, IoOperationFlag, ctypes.c_uint64, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_IoOperationTest = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_IoOperationIssued = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_IoOperationComplete = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, ctypes.c_uint64, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_IoOperationCancelled = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, ctypes.c_uint64)

_GlobalEvtReaderCallback_FP_IoAcquireLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, LockType)

_GlobalEvtReaderCallback_FP_IoReleaseLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, LockType)

_GlobalEvtReaderCallback_FP_IoTryLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, LockType)

_GlobalEvtReaderCallback_FP_ProgramBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), StringRef, ctypes.c_uint32, ctypes.POINTER(StringRef))

_GlobalEvtReaderCallback_FP_ProgramEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_int64)

def GlobalEvtReaderCallbacks_SetUnknownCallback(globalEvtReaderCallbacks, unknownCallback):
    c_SetUnknownCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetUnknownCallback
    c_SetUnknownCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_Unknown ]
    c_SetUnknownCallback.restype = ErrorCode
    c_SetUnknownCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_Unknown,
                                         unknownCallback)
    c_SetUnknownCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetBufferFlushCallback(globalEvtReaderCallbacks, bufferFlushCallback):
    c_SetBufferFlushCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetBufferFlushCallback
    c_SetBufferFlushCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_BufferFlush ]
    c_SetBufferFlushCallback.restype = ErrorCode
    c_SetBufferFlushCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_BufferFlush,
                                         bufferFlushCallback)
    c_SetBufferFlushCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetMeasurementOnOffCallback(globalEvtReaderCallbacks, measurementOnOffCallback):
    c_SetMeasurementOnOffCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetMeasurementOnOffCallback
    c_SetMeasurementOnOffCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_MeasurementOnOff ]
    c_SetMeasurementOnOffCallback.restype = ErrorCode
    c_SetMeasurementOnOffCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_MeasurementOnOff,
                                         measurementOnOffCallback)
    c_SetMeasurementOnOffCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetEnterCallback(globalEvtReaderCallbacks, enterCallback):
    c_SetEnterCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetEnterCallback
    c_SetEnterCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_Enter ]
    c_SetEnterCallback.restype = ErrorCode
    c_SetEnterCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_Enter,
                                         enterCallback)
    c_SetEnterCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetLeaveCallback(globalEvtReaderCallbacks, leaveCallback):
    c_SetLeaveCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetLeaveCallback
    c_SetLeaveCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_Leave ]
    c_SetLeaveCallback.restype = ErrorCode
    c_SetLeaveCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_Leave,
                                         leaveCallback)
    c_SetLeaveCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetMpiSendCallback(globalEvtReaderCallbacks, mpiSendCallback):
    c_SetMpiSendCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetMpiSendCallback
    c_SetMpiSendCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_MpiSend ]
    c_SetMpiSendCallback.restype = ErrorCode
    c_SetMpiSendCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_MpiSend,
                                         mpiSendCallback)
    c_SetMpiSendCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetMpiIsendCallback(globalEvtReaderCallbacks, mpiIsendCallback):
    c_SetMpiIsendCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetMpiIsendCallback
    c_SetMpiIsendCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_MpiIsend ]
    c_SetMpiIsendCallback.restype = ErrorCode
    c_SetMpiIsendCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_MpiIsend,
                                         mpiIsendCallback)
    c_SetMpiIsendCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetMpiIsendCompleteCallback(globalEvtReaderCallbacks, mpiIsendCompleteCallback):
    c_SetMpiIsendCompleteCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetMpiIsendCompleteCallback
    c_SetMpiIsendCompleteCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_MpiIsendComplete ]
    c_SetMpiIsendCompleteCallback.restype = ErrorCode
    c_SetMpiIsendCompleteCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_MpiIsendComplete,
                                         mpiIsendCompleteCallback)
    c_SetMpiIsendCompleteCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetMpiIrecvRequestCallback(globalEvtReaderCallbacks, mpiIrecvRequestCallback):
    c_SetMpiIrecvRequestCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetMpiIrecvRequestCallback
    c_SetMpiIrecvRequestCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_MpiIrecvRequest ]
    c_SetMpiIrecvRequestCallback.restype = ErrorCode
    c_SetMpiIrecvRequestCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_MpiIrecvRequest,
                                         mpiIrecvRequestCallback)
    c_SetMpiIrecvRequestCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetMpiRecvCallback(globalEvtReaderCallbacks, mpiRecvCallback):
    c_SetMpiRecvCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetMpiRecvCallback
    c_SetMpiRecvCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_MpiRecv ]
    c_SetMpiRecvCallback.restype = ErrorCode
    c_SetMpiRecvCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_MpiRecv,
                                         mpiRecvCallback)
    c_SetMpiRecvCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetMpiIrecvCallback(globalEvtReaderCallbacks, mpiIrecvCallback):
    c_SetMpiIrecvCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetMpiIrecvCallback
    c_SetMpiIrecvCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_MpiIrecv ]
    c_SetMpiIrecvCallback.restype = ErrorCode
    c_SetMpiIrecvCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_MpiIrecv,
                                         mpiIrecvCallback)
    c_SetMpiIrecvCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetMpiRequestTestCallback(globalEvtReaderCallbacks, mpiRequestTestCallback):
    c_SetMpiRequestTestCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetMpiRequestTestCallback
    c_SetMpiRequestTestCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_MpiRequestTest ]
    c_SetMpiRequestTestCallback.restype = ErrorCode
    c_SetMpiRequestTestCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_MpiRequestTest,
                                         mpiRequestTestCallback)
    c_SetMpiRequestTestCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetMpiRequestCancelledCallback(globalEvtReaderCallbacks, mpiRequestCancelledCallback):
    c_SetMpiRequestCancelledCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetMpiRequestCancelledCallback
    c_SetMpiRequestCancelledCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_MpiRequestCancelled ]
    c_SetMpiRequestCancelledCallback.restype = ErrorCode
    c_SetMpiRequestCancelledCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_MpiRequestCancelled,
                                         mpiRequestCancelledCallback)
    c_SetMpiRequestCancelledCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetMpiCollectiveBeginCallback(globalEvtReaderCallbacks, mpiCollectiveBeginCallback):
    c_SetMpiCollectiveBeginCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetMpiCollectiveBeginCallback
    c_SetMpiCollectiveBeginCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_MpiCollectiveBegin ]
    c_SetMpiCollectiveBeginCallback.restype = ErrorCode
    c_SetMpiCollectiveBeginCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_MpiCollectiveBegin,
                                         mpiCollectiveBeginCallback)
    c_SetMpiCollectiveBeginCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetMpiCollectiveEndCallback(globalEvtReaderCallbacks, mpiCollectiveEndCallback):
    c_SetMpiCollectiveEndCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetMpiCollectiveEndCallback
    c_SetMpiCollectiveEndCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_MpiCollectiveEnd ]
    c_SetMpiCollectiveEndCallback.restype = ErrorCode
    c_SetMpiCollectiveEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_MpiCollectiveEnd,
                                         mpiCollectiveEndCallback)
    c_SetMpiCollectiveEndCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetOmpForkCallback(globalEvtReaderCallbacks, ompForkCallback):
    c_SetOmpForkCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetOmpForkCallback
    c_SetOmpForkCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_OmpFork ]
    c_SetOmpForkCallback.restype = ErrorCode
    c_SetOmpForkCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_OmpFork,
                                         ompForkCallback)
    c_SetOmpForkCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetOmpJoinCallback(globalEvtReaderCallbacks, ompJoinCallback):
    c_SetOmpJoinCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetOmpJoinCallback
    c_SetOmpJoinCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_OmpJoin ]
    c_SetOmpJoinCallback.restype = ErrorCode
    c_SetOmpJoinCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_OmpJoin,
                                         ompJoinCallback)
    c_SetOmpJoinCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetOmpAcquireLockCallback(globalEvtReaderCallbacks, ompAcquireLockCallback):
    c_SetOmpAcquireLockCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetOmpAcquireLockCallback
    c_SetOmpAcquireLockCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_OmpAcquireLock ]
    c_SetOmpAcquireLockCallback.restype = ErrorCode
    c_SetOmpAcquireLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_OmpAcquireLock,
                                         ompAcquireLockCallback)
    c_SetOmpAcquireLockCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetOmpReleaseLockCallback(globalEvtReaderCallbacks, ompReleaseLockCallback):
    c_SetOmpReleaseLockCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetOmpReleaseLockCallback
    c_SetOmpReleaseLockCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_OmpReleaseLock ]
    c_SetOmpReleaseLockCallback.restype = ErrorCode
    c_SetOmpReleaseLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_OmpReleaseLock,
                                         ompReleaseLockCallback)
    c_SetOmpReleaseLockCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetOmpTaskCreateCallback(globalEvtReaderCallbacks, ompTaskCreateCallback):
    c_SetOmpTaskCreateCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetOmpTaskCreateCallback
    c_SetOmpTaskCreateCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_OmpTaskCreate ]
    c_SetOmpTaskCreateCallback.restype = ErrorCode
    c_SetOmpTaskCreateCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_OmpTaskCreate,
                                         ompTaskCreateCallback)
    c_SetOmpTaskCreateCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetOmpTaskSwitchCallback(globalEvtReaderCallbacks, ompTaskSwitchCallback):
    c_SetOmpTaskSwitchCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetOmpTaskSwitchCallback
    c_SetOmpTaskSwitchCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_OmpTaskSwitch ]
    c_SetOmpTaskSwitchCallback.restype = ErrorCode
    c_SetOmpTaskSwitchCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_OmpTaskSwitch,
                                         ompTaskSwitchCallback)
    c_SetOmpTaskSwitchCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetOmpTaskCompleteCallback(globalEvtReaderCallbacks, ompTaskCompleteCallback):
    c_SetOmpTaskCompleteCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetOmpTaskCompleteCallback
    c_SetOmpTaskCompleteCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_OmpTaskComplete ]
    c_SetOmpTaskCompleteCallback.restype = ErrorCode
    c_SetOmpTaskCompleteCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_OmpTaskComplete,
                                         ompTaskCompleteCallback)
    c_SetOmpTaskCompleteCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetMetricCallback(globalEvtReaderCallbacks, metricCallback):
    c_SetMetricCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetMetricCallback
    c_SetMetricCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_Metric ]
    c_SetMetricCallback.restype = ErrorCode
    c_SetMetricCallback.errcheck = HandleErrorCode
    def convert_args_metric(metric, number_of_metrics, type_ids_array, metric_values_array):
        type_ids = [type_ids_array[i] for i in range(number_of_metrics)]
        metric_values = [metric_values_array[i] for i in range(number_of_metrics)]
        return metric, type_ids, metric_values
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_Metric,
                                         metricCallback, convert_args_metric)
    c_SetMetricCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetParameterStringCallback(globalEvtReaderCallbacks, parameterStringCallback):
    c_SetParameterStringCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetParameterStringCallback
    c_SetParameterStringCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ParameterString ]
    c_SetParameterStringCallback.restype = ErrorCode
    c_SetParameterStringCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ParameterString,
                                         parameterStringCallback)
    c_SetParameterStringCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetParameterIntCallback(globalEvtReaderCallbacks, parameterIntCallback):
    c_SetParameterIntCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetParameterIntCallback
    c_SetParameterIntCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ParameterInt ]
    c_SetParameterIntCallback.restype = ErrorCode
    c_SetParameterIntCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ParameterInt,
                                         parameterIntCallback)
    c_SetParameterIntCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetParameterUnsignedIntCallback(globalEvtReaderCallbacks, parameterUnsignedIntCallback):
    c_SetParameterUnsignedIntCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetParameterUnsignedIntCallback
    c_SetParameterUnsignedIntCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ParameterUnsignedInt ]
    c_SetParameterUnsignedIntCallback.restype = ErrorCode
    c_SetParameterUnsignedIntCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ParameterUnsignedInt,
                                         parameterUnsignedIntCallback)
    c_SetParameterUnsignedIntCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaWinCreateCallback(globalEvtReaderCallbacks, rmaWinCreateCallback):
    c_SetRmaWinCreateCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaWinCreateCallback
    c_SetRmaWinCreateCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaWinCreate ]
    c_SetRmaWinCreateCallback.restype = ErrorCode
    c_SetRmaWinCreateCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaWinCreate,
                                         rmaWinCreateCallback)
    c_SetRmaWinCreateCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaWinDestroyCallback(globalEvtReaderCallbacks, rmaWinDestroyCallback):
    c_SetRmaWinDestroyCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaWinDestroyCallback
    c_SetRmaWinDestroyCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaWinDestroy ]
    c_SetRmaWinDestroyCallback.restype = ErrorCode
    c_SetRmaWinDestroyCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaWinDestroy,
                                         rmaWinDestroyCallback)
    c_SetRmaWinDestroyCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaCollectiveBeginCallback(globalEvtReaderCallbacks, rmaCollectiveBeginCallback):
    c_SetRmaCollectiveBeginCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaCollectiveBeginCallback
    c_SetRmaCollectiveBeginCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaCollectiveBegin ]
    c_SetRmaCollectiveBeginCallback.restype = ErrorCode
    c_SetRmaCollectiveBeginCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaCollectiveBegin,
                                         rmaCollectiveBeginCallback)
    c_SetRmaCollectiveBeginCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaCollectiveEndCallback(globalEvtReaderCallbacks, rmaCollectiveEndCallback):
    c_SetRmaCollectiveEndCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaCollectiveEndCallback
    c_SetRmaCollectiveEndCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaCollectiveEnd ]
    c_SetRmaCollectiveEndCallback.restype = ErrorCode
    c_SetRmaCollectiveEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaCollectiveEnd,
                                         rmaCollectiveEndCallback)
    c_SetRmaCollectiveEndCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaGroupSyncCallback(globalEvtReaderCallbacks, rmaGroupSyncCallback):
    c_SetRmaGroupSyncCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaGroupSyncCallback
    c_SetRmaGroupSyncCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaGroupSync ]
    c_SetRmaGroupSyncCallback.restype = ErrorCode
    c_SetRmaGroupSyncCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaGroupSync,
                                         rmaGroupSyncCallback)
    c_SetRmaGroupSyncCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaRequestLockCallback(globalEvtReaderCallbacks, rmaRequestLockCallback):
    c_SetRmaRequestLockCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaRequestLockCallback
    c_SetRmaRequestLockCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaRequestLock ]
    c_SetRmaRequestLockCallback.restype = ErrorCode
    c_SetRmaRequestLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaRequestLock,
                                         rmaRequestLockCallback)
    c_SetRmaRequestLockCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaAcquireLockCallback(globalEvtReaderCallbacks, rmaAcquireLockCallback):
    c_SetRmaAcquireLockCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaAcquireLockCallback
    c_SetRmaAcquireLockCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaAcquireLock ]
    c_SetRmaAcquireLockCallback.restype = ErrorCode
    c_SetRmaAcquireLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaAcquireLock,
                                         rmaAcquireLockCallback)
    c_SetRmaAcquireLockCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaTryLockCallback(globalEvtReaderCallbacks, rmaTryLockCallback):
    c_SetRmaTryLockCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaTryLockCallback
    c_SetRmaTryLockCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaTryLock ]
    c_SetRmaTryLockCallback.restype = ErrorCode
    c_SetRmaTryLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaTryLock,
                                         rmaTryLockCallback)
    c_SetRmaTryLockCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaReleaseLockCallback(globalEvtReaderCallbacks, rmaReleaseLockCallback):
    c_SetRmaReleaseLockCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaReleaseLockCallback
    c_SetRmaReleaseLockCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaReleaseLock ]
    c_SetRmaReleaseLockCallback.restype = ErrorCode
    c_SetRmaReleaseLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaReleaseLock,
                                         rmaReleaseLockCallback)
    c_SetRmaReleaseLockCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaSyncCallback(globalEvtReaderCallbacks, rmaSyncCallback):
    c_SetRmaSyncCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaSyncCallback
    c_SetRmaSyncCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaSync ]
    c_SetRmaSyncCallback.restype = ErrorCode
    c_SetRmaSyncCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaSync,
                                         rmaSyncCallback)
    c_SetRmaSyncCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaWaitChangeCallback(globalEvtReaderCallbacks, rmaWaitChangeCallback):
    c_SetRmaWaitChangeCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaWaitChangeCallback
    c_SetRmaWaitChangeCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaWaitChange ]
    c_SetRmaWaitChangeCallback.restype = ErrorCode
    c_SetRmaWaitChangeCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaWaitChange,
                                         rmaWaitChangeCallback)
    c_SetRmaWaitChangeCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaPutCallback(globalEvtReaderCallbacks, rmaPutCallback):
    c_SetRmaPutCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaPutCallback
    c_SetRmaPutCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaPut ]
    c_SetRmaPutCallback.restype = ErrorCode
    c_SetRmaPutCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaPut,
                                         rmaPutCallback)
    c_SetRmaPutCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaGetCallback(globalEvtReaderCallbacks, rmaGetCallback):
    c_SetRmaGetCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaGetCallback
    c_SetRmaGetCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaGet ]
    c_SetRmaGetCallback.restype = ErrorCode
    c_SetRmaGetCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaGet,
                                         rmaGetCallback)
    c_SetRmaGetCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaAtomicCallback(globalEvtReaderCallbacks, rmaAtomicCallback):
    c_SetRmaAtomicCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaAtomicCallback
    c_SetRmaAtomicCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaAtomic ]
    c_SetRmaAtomicCallback.restype = ErrorCode
    c_SetRmaAtomicCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaAtomic,
                                         rmaAtomicCallback)
    c_SetRmaAtomicCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaOpCompleteBlockingCallback(globalEvtReaderCallbacks, rmaOpCompleteBlockingCallback):
    c_SetRmaOpCompleteBlockingCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaOpCompleteBlockingCallback
    c_SetRmaOpCompleteBlockingCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaOpCompleteBlocking ]
    c_SetRmaOpCompleteBlockingCallback.restype = ErrorCode
    c_SetRmaOpCompleteBlockingCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaOpCompleteBlocking,
                                         rmaOpCompleteBlockingCallback)
    c_SetRmaOpCompleteBlockingCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaOpCompleteNonBlockingCallback(globalEvtReaderCallbacks, rmaOpCompleteNonBlockingCallback):
    c_SetRmaOpCompleteNonBlockingCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaOpCompleteNonBlockingCallback
    c_SetRmaOpCompleteNonBlockingCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaOpCompleteNonBlocking ]
    c_SetRmaOpCompleteNonBlockingCallback.restype = ErrorCode
    c_SetRmaOpCompleteNonBlockingCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaOpCompleteNonBlocking,
                                         rmaOpCompleteNonBlockingCallback)
    c_SetRmaOpCompleteNonBlockingCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaOpTestCallback(globalEvtReaderCallbacks, rmaOpTestCallback):
    c_SetRmaOpTestCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaOpTestCallback
    c_SetRmaOpTestCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaOpTest ]
    c_SetRmaOpTestCallback.restype = ErrorCode
    c_SetRmaOpTestCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaOpTest,
                                         rmaOpTestCallback)
    c_SetRmaOpTestCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetRmaOpCompleteRemoteCallback(globalEvtReaderCallbacks, rmaOpCompleteRemoteCallback):
    c_SetRmaOpCompleteRemoteCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetRmaOpCompleteRemoteCallback
    c_SetRmaOpCompleteRemoteCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_RmaOpCompleteRemote ]
    c_SetRmaOpCompleteRemoteCallback.restype = ErrorCode
    c_SetRmaOpCompleteRemoteCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_RmaOpCompleteRemote,
                                         rmaOpCompleteRemoteCallback)
    c_SetRmaOpCompleteRemoteCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadForkCallback(globalEvtReaderCallbacks, threadForkCallback):
    c_SetThreadForkCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadForkCallback
    c_SetThreadForkCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadFork ]
    c_SetThreadForkCallback.restype = ErrorCode
    c_SetThreadForkCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadFork,
                                         threadForkCallback)
    c_SetThreadForkCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadJoinCallback(globalEvtReaderCallbacks, threadJoinCallback):
    c_SetThreadJoinCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadJoinCallback
    c_SetThreadJoinCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadJoin ]
    c_SetThreadJoinCallback.restype = ErrorCode
    c_SetThreadJoinCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadJoin,
                                         threadJoinCallback)
    c_SetThreadJoinCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadTeamBeginCallback(globalEvtReaderCallbacks, threadTeamBeginCallback):
    c_SetThreadTeamBeginCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadTeamBeginCallback
    c_SetThreadTeamBeginCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadTeamBegin ]
    c_SetThreadTeamBeginCallback.restype = ErrorCode
    c_SetThreadTeamBeginCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadTeamBegin,
                                         threadTeamBeginCallback)
    c_SetThreadTeamBeginCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadTeamEndCallback(globalEvtReaderCallbacks, threadTeamEndCallback):
    c_SetThreadTeamEndCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadTeamEndCallback
    c_SetThreadTeamEndCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadTeamEnd ]
    c_SetThreadTeamEndCallback.restype = ErrorCode
    c_SetThreadTeamEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadTeamEnd,
                                         threadTeamEndCallback)
    c_SetThreadTeamEndCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadAcquireLockCallback(globalEvtReaderCallbacks, threadAcquireLockCallback):
    c_SetThreadAcquireLockCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadAcquireLockCallback
    c_SetThreadAcquireLockCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadAcquireLock ]
    c_SetThreadAcquireLockCallback.restype = ErrorCode
    c_SetThreadAcquireLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadAcquireLock,
                                         threadAcquireLockCallback)
    c_SetThreadAcquireLockCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadReleaseLockCallback(globalEvtReaderCallbacks, threadReleaseLockCallback):
    c_SetThreadReleaseLockCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadReleaseLockCallback
    c_SetThreadReleaseLockCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadReleaseLock ]
    c_SetThreadReleaseLockCallback.restype = ErrorCode
    c_SetThreadReleaseLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadReleaseLock,
                                         threadReleaseLockCallback)
    c_SetThreadReleaseLockCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadTaskCreateCallback(globalEvtReaderCallbacks, threadTaskCreateCallback):
    c_SetThreadTaskCreateCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadTaskCreateCallback
    c_SetThreadTaskCreateCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadTaskCreate ]
    c_SetThreadTaskCreateCallback.restype = ErrorCode
    c_SetThreadTaskCreateCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadTaskCreate,
                                         threadTaskCreateCallback)
    c_SetThreadTaskCreateCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadTaskSwitchCallback(globalEvtReaderCallbacks, threadTaskSwitchCallback):
    c_SetThreadTaskSwitchCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadTaskSwitchCallback
    c_SetThreadTaskSwitchCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadTaskSwitch ]
    c_SetThreadTaskSwitchCallback.restype = ErrorCode
    c_SetThreadTaskSwitchCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadTaskSwitch,
                                         threadTaskSwitchCallback)
    c_SetThreadTaskSwitchCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadTaskCompleteCallback(globalEvtReaderCallbacks, threadTaskCompleteCallback):
    c_SetThreadTaskCompleteCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadTaskCompleteCallback
    c_SetThreadTaskCompleteCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadTaskComplete ]
    c_SetThreadTaskCompleteCallback.restype = ErrorCode
    c_SetThreadTaskCompleteCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadTaskComplete,
                                         threadTaskCompleteCallback)
    c_SetThreadTaskCompleteCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadCreateCallback(globalEvtReaderCallbacks, threadCreateCallback):
    c_SetThreadCreateCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadCreateCallback
    c_SetThreadCreateCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadCreate ]
    c_SetThreadCreateCallback.restype = ErrorCode
    c_SetThreadCreateCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadCreate,
                                         threadCreateCallback)
    c_SetThreadCreateCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadBeginCallback(globalEvtReaderCallbacks, threadBeginCallback):
    c_SetThreadBeginCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadBeginCallback
    c_SetThreadBeginCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadBegin ]
    c_SetThreadBeginCallback.restype = ErrorCode
    c_SetThreadBeginCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadBegin,
                                         threadBeginCallback)
    c_SetThreadBeginCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadWaitCallback(globalEvtReaderCallbacks, threadWaitCallback):
    c_SetThreadWaitCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadWaitCallback
    c_SetThreadWaitCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadWait ]
    c_SetThreadWaitCallback.restype = ErrorCode
    c_SetThreadWaitCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadWait,
                                         threadWaitCallback)
    c_SetThreadWaitCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetThreadEndCallback(globalEvtReaderCallbacks, threadEndCallback):
    c_SetThreadEndCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetThreadEndCallback
    c_SetThreadEndCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ThreadEnd ]
    c_SetThreadEndCallback.restype = ErrorCode
    c_SetThreadEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ThreadEnd,
                                         threadEndCallback)
    c_SetThreadEndCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetCallingContextEnterCallback(globalEvtReaderCallbacks, callingContextEnterCallback):
    c_SetCallingContextEnterCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetCallingContextEnterCallback
    c_SetCallingContextEnterCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_CallingContextEnter ]
    c_SetCallingContextEnterCallback.restype = ErrorCode
    c_SetCallingContextEnterCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_CallingContextEnter,
                                         callingContextEnterCallback)
    c_SetCallingContextEnterCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetCallingContextLeaveCallback(globalEvtReaderCallbacks, callingContextLeaveCallback):
    c_SetCallingContextLeaveCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetCallingContextLeaveCallback
    c_SetCallingContextLeaveCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_CallingContextLeave ]
    c_SetCallingContextLeaveCallback.restype = ErrorCode
    c_SetCallingContextLeaveCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_CallingContextLeave,
                                         callingContextLeaveCallback)
    c_SetCallingContextLeaveCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetCallingContextSampleCallback(globalEvtReaderCallbacks, callingContextSampleCallback):
    c_SetCallingContextSampleCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetCallingContextSampleCallback
    c_SetCallingContextSampleCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_CallingContextSample ]
    c_SetCallingContextSampleCallback.restype = ErrorCode
    c_SetCallingContextSampleCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_CallingContextSample,
                                         callingContextSampleCallback)
    c_SetCallingContextSampleCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoCreateHandleCallback(globalEvtReaderCallbacks, ioCreateHandleCallback):
    c_SetIoCreateHandleCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoCreateHandleCallback
    c_SetIoCreateHandleCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoCreateHandle ]
    c_SetIoCreateHandleCallback.restype = ErrorCode
    c_SetIoCreateHandleCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoCreateHandle,
                                         ioCreateHandleCallback)
    c_SetIoCreateHandleCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoDestroyHandleCallback(globalEvtReaderCallbacks, ioDestroyHandleCallback):
    c_SetIoDestroyHandleCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoDestroyHandleCallback
    c_SetIoDestroyHandleCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoDestroyHandle ]
    c_SetIoDestroyHandleCallback.restype = ErrorCode
    c_SetIoDestroyHandleCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoDestroyHandle,
                                         ioDestroyHandleCallback)
    c_SetIoDestroyHandleCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoDuplicateHandleCallback(globalEvtReaderCallbacks, ioDuplicateHandleCallback):
    c_SetIoDuplicateHandleCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoDuplicateHandleCallback
    c_SetIoDuplicateHandleCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoDuplicateHandle ]
    c_SetIoDuplicateHandleCallback.restype = ErrorCode
    c_SetIoDuplicateHandleCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoDuplicateHandle,
                                         ioDuplicateHandleCallback)
    c_SetIoDuplicateHandleCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoSeekCallback(globalEvtReaderCallbacks, ioSeekCallback):
    c_SetIoSeekCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoSeekCallback
    c_SetIoSeekCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoSeek ]
    c_SetIoSeekCallback.restype = ErrorCode
    c_SetIoSeekCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoSeek,
                                         ioSeekCallback)
    c_SetIoSeekCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoChangeStatusFlagsCallback(globalEvtReaderCallbacks, ioChangeStatusFlagsCallback):
    c_SetIoChangeStatusFlagsCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoChangeStatusFlagsCallback
    c_SetIoChangeStatusFlagsCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoChangeStatusFlags ]
    c_SetIoChangeStatusFlagsCallback.restype = ErrorCode
    c_SetIoChangeStatusFlagsCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoChangeStatusFlags,
                                         ioChangeStatusFlagsCallback)
    c_SetIoChangeStatusFlagsCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoDeleteFileCallback(globalEvtReaderCallbacks, ioDeleteFileCallback):
    c_SetIoDeleteFileCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoDeleteFileCallback
    c_SetIoDeleteFileCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoDeleteFile ]
    c_SetIoDeleteFileCallback.restype = ErrorCode
    c_SetIoDeleteFileCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoDeleteFile,
                                         ioDeleteFileCallback)
    c_SetIoDeleteFileCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoOperationBeginCallback(globalEvtReaderCallbacks, ioOperationBeginCallback):
    c_SetIoOperationBeginCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoOperationBeginCallback
    c_SetIoOperationBeginCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoOperationBegin ]
    c_SetIoOperationBeginCallback.restype = ErrorCode
    c_SetIoOperationBeginCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoOperationBegin,
                                         ioOperationBeginCallback)
    c_SetIoOperationBeginCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoOperationTestCallback(globalEvtReaderCallbacks, ioOperationTestCallback):
    c_SetIoOperationTestCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoOperationTestCallback
    c_SetIoOperationTestCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoOperationTest ]
    c_SetIoOperationTestCallback.restype = ErrorCode
    c_SetIoOperationTestCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoOperationTest,
                                         ioOperationTestCallback)
    c_SetIoOperationTestCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoOperationIssuedCallback(globalEvtReaderCallbacks, ioOperationIssuedCallback):
    c_SetIoOperationIssuedCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoOperationIssuedCallback
    c_SetIoOperationIssuedCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoOperationIssued ]
    c_SetIoOperationIssuedCallback.restype = ErrorCode
    c_SetIoOperationIssuedCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoOperationIssued,
                                         ioOperationIssuedCallback)
    c_SetIoOperationIssuedCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoOperationCompleteCallback(globalEvtReaderCallbacks, ioOperationCompleteCallback):
    c_SetIoOperationCompleteCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoOperationCompleteCallback
    c_SetIoOperationCompleteCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoOperationComplete ]
    c_SetIoOperationCompleteCallback.restype = ErrorCode
    c_SetIoOperationCompleteCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoOperationComplete,
                                         ioOperationCompleteCallback)
    c_SetIoOperationCompleteCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoOperationCancelledCallback(globalEvtReaderCallbacks, ioOperationCancelledCallback):
    c_SetIoOperationCancelledCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoOperationCancelledCallback
    c_SetIoOperationCancelledCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoOperationCancelled ]
    c_SetIoOperationCancelledCallback.restype = ErrorCode
    c_SetIoOperationCancelledCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoOperationCancelled,
                                         ioOperationCancelledCallback)
    c_SetIoOperationCancelledCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoAcquireLockCallback(globalEvtReaderCallbacks, ioAcquireLockCallback):
    c_SetIoAcquireLockCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoAcquireLockCallback
    c_SetIoAcquireLockCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoAcquireLock ]
    c_SetIoAcquireLockCallback.restype = ErrorCode
    c_SetIoAcquireLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoAcquireLock,
                                         ioAcquireLockCallback)
    c_SetIoAcquireLockCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoReleaseLockCallback(globalEvtReaderCallbacks, ioReleaseLockCallback):
    c_SetIoReleaseLockCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoReleaseLockCallback
    c_SetIoReleaseLockCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoReleaseLock ]
    c_SetIoReleaseLockCallback.restype = ErrorCode
    c_SetIoReleaseLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoReleaseLock,
                                         ioReleaseLockCallback)
    c_SetIoReleaseLockCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetIoTryLockCallback(globalEvtReaderCallbacks, ioTryLockCallback):
    c_SetIoTryLockCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetIoTryLockCallback
    c_SetIoTryLockCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_IoTryLock ]
    c_SetIoTryLockCallback.restype = ErrorCode
    c_SetIoTryLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_IoTryLock,
                                         ioTryLockCallback)
    c_SetIoTryLockCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetProgramBeginCallback(globalEvtReaderCallbacks, programBeginCallback):
    c_SetProgramBeginCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetProgramBeginCallback
    c_SetProgramBeginCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ProgramBegin ]
    c_SetProgramBeginCallback.restype = ErrorCode
    c_SetProgramBeginCallback.errcheck = HandleErrorCode
    def convert_args(program_name, number_of_arguments, arguments_array):
        arguments = [arguments_array[i] for i in range(number_of_arguments)]
        return program_name, arguments
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ProgramBegin,
                                         programBeginCallback, convert_args)
    c_SetProgramBeginCallback(globalEvtReaderCallbacks, wrapped_callback)

def GlobalEvtReaderCallbacks_SetProgramEndCallback(globalEvtReaderCallbacks, programEndCallback):
    c_SetProgramEndCallback = conf.lib.OTF2_GlobalEvtReaderCallbacks_SetProgramEndCallback
    c_SetProgramEndCallback.argtypes = [ ctypes.POINTER(GlobalEvtReaderCallbacks), _GlobalEvtReaderCallback_FP_ProgramEnd ]
    c_SetProgramEndCallback.restype = ErrorCode
    c_SetProgramEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalEvtReaderCallback_FP_ProgramEnd,
                                         programEndCallback)
    c_SetProgramEndCallback(globalEvtReaderCallbacks, wrapped_callback)

__all__ = [
    'GlobalEvtReaderCallbacks',
    'GlobalEvtReaderCallbacks_New',
    'GlobalEvtReaderCallbacks_Delete',
    'GlobalEvtReaderCallbacks_Clear',
    'GlobalEvtReaderCallbacks_SetUnknownCallback',
    'GlobalEvtReaderCallbacks_SetBufferFlushCallback',
    'GlobalEvtReaderCallbacks_SetMeasurementOnOffCallback',
    'GlobalEvtReaderCallbacks_SetEnterCallback',
    'GlobalEvtReaderCallbacks_SetLeaveCallback',
    'GlobalEvtReaderCallbacks_SetMpiSendCallback',
    'GlobalEvtReaderCallbacks_SetMpiIsendCallback',
    'GlobalEvtReaderCallbacks_SetMpiIsendCompleteCallback',
    'GlobalEvtReaderCallbacks_SetMpiIrecvRequestCallback',
    'GlobalEvtReaderCallbacks_SetMpiRecvCallback',
    'GlobalEvtReaderCallbacks_SetMpiIrecvCallback',
    'GlobalEvtReaderCallbacks_SetMpiRequestTestCallback',
    'GlobalEvtReaderCallbacks_SetMpiRequestCancelledCallback',
    'GlobalEvtReaderCallbacks_SetMpiCollectiveBeginCallback',
    'GlobalEvtReaderCallbacks_SetMpiCollectiveEndCallback',
    'GlobalEvtReaderCallbacks_SetOmpForkCallback',
    'GlobalEvtReaderCallbacks_SetOmpJoinCallback',
    'GlobalEvtReaderCallbacks_SetOmpAcquireLockCallback',
    'GlobalEvtReaderCallbacks_SetOmpReleaseLockCallback',
    'GlobalEvtReaderCallbacks_SetOmpTaskCreateCallback',
    'GlobalEvtReaderCallbacks_SetOmpTaskSwitchCallback',
    'GlobalEvtReaderCallbacks_SetOmpTaskCompleteCallback',
    'GlobalEvtReaderCallbacks_SetMetricCallback',
    'GlobalEvtReaderCallbacks_SetParameterStringCallback',
    'GlobalEvtReaderCallbacks_SetParameterIntCallback',
    'GlobalEvtReaderCallbacks_SetParameterUnsignedIntCallback',
    'GlobalEvtReaderCallbacks_SetRmaWinCreateCallback',
    'GlobalEvtReaderCallbacks_SetRmaWinDestroyCallback',
    'GlobalEvtReaderCallbacks_SetRmaCollectiveBeginCallback',
    'GlobalEvtReaderCallbacks_SetRmaCollectiveEndCallback',
    'GlobalEvtReaderCallbacks_SetRmaGroupSyncCallback',
    'GlobalEvtReaderCallbacks_SetRmaRequestLockCallback',
    'GlobalEvtReaderCallbacks_SetRmaAcquireLockCallback',
    'GlobalEvtReaderCallbacks_SetRmaTryLockCallback',
    'GlobalEvtReaderCallbacks_SetRmaReleaseLockCallback',
    'GlobalEvtReaderCallbacks_SetRmaSyncCallback',
    'GlobalEvtReaderCallbacks_SetRmaWaitChangeCallback',
    'GlobalEvtReaderCallbacks_SetRmaPutCallback',
    'GlobalEvtReaderCallbacks_SetRmaGetCallback',
    'GlobalEvtReaderCallbacks_SetRmaAtomicCallback',
    'GlobalEvtReaderCallbacks_SetRmaOpCompleteBlockingCallback',
    'GlobalEvtReaderCallbacks_SetRmaOpCompleteNonBlockingCallback',
    'GlobalEvtReaderCallbacks_SetRmaOpTestCallback',
    'GlobalEvtReaderCallbacks_SetRmaOpCompleteRemoteCallback',
    'GlobalEvtReaderCallbacks_SetThreadForkCallback',
    'GlobalEvtReaderCallbacks_SetThreadJoinCallback',
    'GlobalEvtReaderCallbacks_SetThreadTeamBeginCallback',
    'GlobalEvtReaderCallbacks_SetThreadTeamEndCallback',
    'GlobalEvtReaderCallbacks_SetThreadAcquireLockCallback',
    'GlobalEvtReaderCallbacks_SetThreadReleaseLockCallback',
    'GlobalEvtReaderCallbacks_SetThreadTaskCreateCallback',
    'GlobalEvtReaderCallbacks_SetThreadTaskSwitchCallback',
    'GlobalEvtReaderCallbacks_SetThreadTaskCompleteCallback',
    'GlobalEvtReaderCallbacks_SetThreadCreateCallback',
    'GlobalEvtReaderCallbacks_SetThreadBeginCallback',
    'GlobalEvtReaderCallbacks_SetThreadWaitCallback',
    'GlobalEvtReaderCallbacks_SetThreadEndCallback',
    'GlobalEvtReaderCallbacks_SetCallingContextEnterCallback',
    'GlobalEvtReaderCallbacks_SetCallingContextLeaveCallback',
    'GlobalEvtReaderCallbacks_SetCallingContextSampleCallback',
    'GlobalEvtReaderCallbacks_SetIoCreateHandleCallback',
    'GlobalEvtReaderCallbacks_SetIoDestroyHandleCallback',
    'GlobalEvtReaderCallbacks_SetIoDuplicateHandleCallback',
    'GlobalEvtReaderCallbacks_SetIoSeekCallback',
    'GlobalEvtReaderCallbacks_SetIoChangeStatusFlagsCallback',
    'GlobalEvtReaderCallbacks_SetIoDeleteFileCallback',
    'GlobalEvtReaderCallbacks_SetIoOperationBeginCallback',
    'GlobalEvtReaderCallbacks_SetIoOperationTestCallback',
    'GlobalEvtReaderCallbacks_SetIoOperationIssuedCallback',
    'GlobalEvtReaderCallbacks_SetIoOperationCompleteCallback',
    'GlobalEvtReaderCallbacks_SetIoOperationCancelledCallback',
    'GlobalEvtReaderCallbacks_SetIoAcquireLockCallback',
    'GlobalEvtReaderCallbacks_SetIoReleaseLockCallback',
    'GlobalEvtReaderCallbacks_SetIoTryLockCallback',
    'GlobalEvtReaderCallbacks_SetProgramBeginCallback',
    'GlobalEvtReaderCallbacks_SetProgramEndCallback',
]
