
''' Generated by OTF2 Template Engine '''

import ctypes
import traceback
import sys

from .Config import conf, StrParam
from .ErrorCodes import ErrorCode, HandleErrorCode
from .GeneralDefinitions import *
from .AttributeList import AttributeList
from .Definitions import *
from .Events import *
from .Callbacks import callback_wrapper


class EvtReaderCallbacks(ctypes.Structure):
    pass

def EvtReaderCallbacks_New():
    c_New = conf.lib.OTF2_EvtReaderCallbacks_New
    c_New.argtypes = []
    c_New.restype = ctypes.POINTER(EvtReaderCallbacks)
    # NOTE: Do not errcheck here. This function returns a value, not an error code
    return c_New()

def EvtReaderCallbacks_Delete(evtReaderCallbacks):
    c_Delete = conf.lib.OTF2_EvtReaderCallbacks_Delete
    c_Delete.argtypes = [ ctypes.POINTER(EvtReaderCallbacks) ]
    c_Delete.restype = None
    return c_Delete(evtReaderCallbacks)

def EvtReaderCallbacks_Clear(evtReaderCallbacks):
    c_Clear = conf.lib.OTF2_EvtReaderCallbacks_Clear
    c_Clear.argtypes = [ ctypes.POINTER(EvtReaderCallbacks) ]
    c_Clear.restype = None
    return c_Clear(evtReaderCallbacks)

def _callback_wrapper(type, func, convert_args=None):
    def wrapper(location, time, eventPosition, userData, attribute_list, *args):
        if userData:
            py_userData = ctypes.cast(userData, ctypes.py_object).value
        else:
            py_userData = None
        try:
            if convert_args is not None:
                args = convert_args(*args)
            if not attribute_list:
                attribute_list = None
            ret = func(location, time, eventPosition, py_userData, attribute_list, *args)
            if ret is None:
                ret = CALLBACK_SUCCESS
        except:
            sys.stderr.write("An unhandled python exception has occurred in an "
                             "OTF2_EvtReaderCallback:\n")
            sys.stderr.write(traceback.format_exc())
            ret = CALLBACK_ERROR
        return ret.value
    return callback_wrapper(func, wrapper, type)

_EvtReaderCallback_FP_Unknown = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList))

_EvtReaderCallback_FP_BufferFlush = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp)

_EvtReaderCallback_FP_MeasurementOnOff = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), MeasurementMode)

_EvtReaderCallback_FP_Enter = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RegionRef)

_EvtReaderCallback_FP_Leave = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RegionRef)

_EvtReaderCallback_FP_MpiSend = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64)

_EvtReaderCallback_FP_MpiIsend = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_EvtReaderCallback_FP_MpiIsendComplete = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_EvtReaderCallback_FP_MpiIrecvRequest = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_EvtReaderCallback_FP_MpiRecv = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64)

_EvtReaderCallback_FP_MpiIrecv = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_EvtReaderCallback_FP_MpiRequestTest = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_EvtReaderCallback_FP_MpiRequestCancelled = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_EvtReaderCallback_FP_MpiCollectiveBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList))

_EvtReaderCallback_FP_MpiCollectiveEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CollectiveOp, CommRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_EvtReaderCallback_FP_OmpFork = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32)

_EvtReaderCallback_FP_OmpJoin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList))

_EvtReaderCallback_FP_OmpAcquireLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32, ctypes.c_uint32)

_EvtReaderCallback_FP_OmpReleaseLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint32, ctypes.c_uint32)

_EvtReaderCallback_FP_OmpTaskCreate = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_EvtReaderCallback_FP_OmpTaskSwitch = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_EvtReaderCallback_FP_OmpTaskComplete = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_EvtReaderCallback_FP_Metric = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), MetricRef, ctypes.c_uint8, ctypes.POINTER(Type), ctypes.POINTER(MetricValue))

_EvtReaderCallback_FP_ParameterString = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ParameterRef, StringRef)

_EvtReaderCallback_FP_ParameterInt = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ParameterRef, ctypes.c_int64)

_EvtReaderCallback_FP_ParameterUnsignedInt = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ParameterRef, ctypes.c_uint64)

_EvtReaderCallback_FP_RmaWinCreate = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef)

_EvtReaderCallback_FP_RmaWinDestroy = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef)

_EvtReaderCallback_FP_RmaCollectiveBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList))

_EvtReaderCallback_FP_RmaCollectiveEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CollectiveOp, RmaSyncLevel, RmaWinRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_EvtReaderCallback_FP_RmaGroupSync = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaSyncLevel, RmaWinRef, GroupRef)

_EvtReaderCallback_FP_RmaRequestLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, ctypes.c_uint64, LockType)

_EvtReaderCallback_FP_RmaAcquireLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, ctypes.c_uint64, LockType)

_EvtReaderCallback_FP_RmaTryLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, ctypes.c_uint64, LockType)

_EvtReaderCallback_FP_RmaReleaseLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, ctypes.c_uint64)

_EvtReaderCallback_FP_RmaSync = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, RmaSyncType)

_EvtReaderCallback_FP_RmaWaitChange = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef)

_EvtReaderCallback_FP_RmaPut = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_EvtReaderCallback_FP_RmaGet = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_EvtReaderCallback_FP_RmaAtomic = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint32, RmaAtomicType, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_uint64)

_EvtReaderCallback_FP_RmaOpCompleteBlocking = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint64)

_EvtReaderCallback_FP_RmaOpCompleteNonBlocking = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint64)

_EvtReaderCallback_FP_RmaOpTest = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint64)

_EvtReaderCallback_FP_RmaOpCompleteRemote = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), RmaWinRef, ctypes.c_uint64)

_EvtReaderCallback_FP_ThreadFork = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), Paradigm, ctypes.c_uint32)

_EvtReaderCallback_FP_ThreadJoin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), Paradigm)

_EvtReaderCallback_FP_ThreadTeamBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef)

_EvtReaderCallback_FP_ThreadTeamEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef)

_EvtReaderCallback_FP_ThreadAcquireLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), Paradigm, ctypes.c_uint32, ctypes.c_uint32)

_EvtReaderCallback_FP_ThreadReleaseLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), Paradigm, ctypes.c_uint32, ctypes.c_uint32)

_EvtReaderCallback_FP_ThreadTaskCreate = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint32, ctypes.c_uint32)

_EvtReaderCallback_FP_ThreadTaskSwitch = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint32, ctypes.c_uint32)

_EvtReaderCallback_FP_ThreadTaskComplete = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint32, ctypes.c_uint32)

_EvtReaderCallback_FP_ThreadCreate = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint64)

_EvtReaderCallback_FP_ThreadBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint64)

_EvtReaderCallback_FP_ThreadWait = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint64)

_EvtReaderCallback_FP_ThreadEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CommRef, ctypes.c_uint64)

_EvtReaderCallback_FP_CallingContextEnter = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CallingContextRef, ctypes.c_uint32)

_EvtReaderCallback_FP_CallingContextLeave = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CallingContextRef)

_EvtReaderCallback_FP_CallingContextSample = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), CallingContextRef, ctypes.c_uint32, InterruptGeneratorRef)

_EvtReaderCallback_FP_IoCreateHandle = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, IoAccessMode, IoCreationFlag, IoStatusFlag)

_EvtReaderCallback_FP_IoDestroyHandle = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef)

_EvtReaderCallback_FP_IoDuplicateHandle = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, IoHandleRef, IoStatusFlag)

_EvtReaderCallback_FP_IoSeek = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, ctypes.c_int64, IoSeekOption, ctypes.c_uint64)

_EvtReaderCallback_FP_IoChangeStatusFlags = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, IoStatusFlag)

_EvtReaderCallback_FP_IoDeleteFile = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoParadigmRef, IoFileRef)

_EvtReaderCallback_FP_IoOperationBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, IoOperationMode, IoOperationFlag, ctypes.c_uint64, ctypes.c_uint64)

_EvtReaderCallback_FP_IoOperationTest = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, ctypes.c_uint64)

_EvtReaderCallback_FP_IoOperationIssued = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, ctypes.c_uint64)

_EvtReaderCallback_FP_IoOperationComplete = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, ctypes.c_uint64, ctypes.c_uint64)

_EvtReaderCallback_FP_IoOperationCancelled = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, ctypes.c_uint64)

_EvtReaderCallback_FP_IoAcquireLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, LockType)

_EvtReaderCallback_FP_IoReleaseLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, LockType)

_EvtReaderCallback_FP_IoTryLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), IoHandleRef, LockType)

_EvtReaderCallback_FP_ProgramBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), StringRef, ctypes.c_uint32, ctypes.POINTER(StringRef))

_EvtReaderCallback_FP_ProgramEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_uint64, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_int64)

def EvtReaderCallbacks_SetUnknownCallback(evtReaderCallbacks, unknownCallback):
    c_SetUnknownCallback = conf.lib.OTF2_EvtReaderCallbacks_SetUnknownCallback
    c_SetUnknownCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_Unknown ]
    c_SetUnknownCallback.restype = ErrorCode
    c_SetUnknownCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_Unknown,
                                         unknownCallback)
    c_SetUnknownCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetBufferFlushCallback(evtReaderCallbacks, bufferFlushCallback):
    c_SetBufferFlushCallback = conf.lib.OTF2_EvtReaderCallbacks_SetBufferFlushCallback
    c_SetBufferFlushCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_BufferFlush ]
    c_SetBufferFlushCallback.restype = ErrorCode
    c_SetBufferFlushCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_BufferFlush,
                                         bufferFlushCallback)
    c_SetBufferFlushCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetMeasurementOnOffCallback(evtReaderCallbacks, measurementOnOffCallback):
    c_SetMeasurementOnOffCallback = conf.lib.OTF2_EvtReaderCallbacks_SetMeasurementOnOffCallback
    c_SetMeasurementOnOffCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_MeasurementOnOff ]
    c_SetMeasurementOnOffCallback.restype = ErrorCode
    c_SetMeasurementOnOffCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_MeasurementOnOff,
                                         measurementOnOffCallback)
    c_SetMeasurementOnOffCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetEnterCallback(evtReaderCallbacks, enterCallback):
    c_SetEnterCallback = conf.lib.OTF2_EvtReaderCallbacks_SetEnterCallback
    c_SetEnterCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_Enter ]
    c_SetEnterCallback.restype = ErrorCode
    c_SetEnterCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_Enter,
                                         enterCallback)
    c_SetEnterCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetLeaveCallback(evtReaderCallbacks, leaveCallback):
    c_SetLeaveCallback = conf.lib.OTF2_EvtReaderCallbacks_SetLeaveCallback
    c_SetLeaveCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_Leave ]
    c_SetLeaveCallback.restype = ErrorCode
    c_SetLeaveCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_Leave,
                                         leaveCallback)
    c_SetLeaveCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetMpiSendCallback(evtReaderCallbacks, mpiSendCallback):
    c_SetMpiSendCallback = conf.lib.OTF2_EvtReaderCallbacks_SetMpiSendCallback
    c_SetMpiSendCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_MpiSend ]
    c_SetMpiSendCallback.restype = ErrorCode
    c_SetMpiSendCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_MpiSend,
                                         mpiSendCallback)
    c_SetMpiSendCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetMpiIsendCallback(evtReaderCallbacks, mpiIsendCallback):
    c_SetMpiIsendCallback = conf.lib.OTF2_EvtReaderCallbacks_SetMpiIsendCallback
    c_SetMpiIsendCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_MpiIsend ]
    c_SetMpiIsendCallback.restype = ErrorCode
    c_SetMpiIsendCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_MpiIsend,
                                         mpiIsendCallback)
    c_SetMpiIsendCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetMpiIsendCompleteCallback(evtReaderCallbacks, mpiIsendCompleteCallback):
    c_SetMpiIsendCompleteCallback = conf.lib.OTF2_EvtReaderCallbacks_SetMpiIsendCompleteCallback
    c_SetMpiIsendCompleteCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_MpiIsendComplete ]
    c_SetMpiIsendCompleteCallback.restype = ErrorCode
    c_SetMpiIsendCompleteCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_MpiIsendComplete,
                                         mpiIsendCompleteCallback)
    c_SetMpiIsendCompleteCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetMpiIrecvRequestCallback(evtReaderCallbacks, mpiIrecvRequestCallback):
    c_SetMpiIrecvRequestCallback = conf.lib.OTF2_EvtReaderCallbacks_SetMpiIrecvRequestCallback
    c_SetMpiIrecvRequestCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_MpiIrecvRequest ]
    c_SetMpiIrecvRequestCallback.restype = ErrorCode
    c_SetMpiIrecvRequestCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_MpiIrecvRequest,
                                         mpiIrecvRequestCallback)
    c_SetMpiIrecvRequestCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetMpiRecvCallback(evtReaderCallbacks, mpiRecvCallback):
    c_SetMpiRecvCallback = conf.lib.OTF2_EvtReaderCallbacks_SetMpiRecvCallback
    c_SetMpiRecvCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_MpiRecv ]
    c_SetMpiRecvCallback.restype = ErrorCode
    c_SetMpiRecvCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_MpiRecv,
                                         mpiRecvCallback)
    c_SetMpiRecvCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetMpiIrecvCallback(evtReaderCallbacks, mpiIrecvCallback):
    c_SetMpiIrecvCallback = conf.lib.OTF2_EvtReaderCallbacks_SetMpiIrecvCallback
    c_SetMpiIrecvCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_MpiIrecv ]
    c_SetMpiIrecvCallback.restype = ErrorCode
    c_SetMpiIrecvCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_MpiIrecv,
                                         mpiIrecvCallback)
    c_SetMpiIrecvCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetMpiRequestTestCallback(evtReaderCallbacks, mpiRequestTestCallback):
    c_SetMpiRequestTestCallback = conf.lib.OTF2_EvtReaderCallbacks_SetMpiRequestTestCallback
    c_SetMpiRequestTestCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_MpiRequestTest ]
    c_SetMpiRequestTestCallback.restype = ErrorCode
    c_SetMpiRequestTestCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_MpiRequestTest,
                                         mpiRequestTestCallback)
    c_SetMpiRequestTestCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetMpiRequestCancelledCallback(evtReaderCallbacks, mpiRequestCancelledCallback):
    c_SetMpiRequestCancelledCallback = conf.lib.OTF2_EvtReaderCallbacks_SetMpiRequestCancelledCallback
    c_SetMpiRequestCancelledCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_MpiRequestCancelled ]
    c_SetMpiRequestCancelledCallback.restype = ErrorCode
    c_SetMpiRequestCancelledCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_MpiRequestCancelled,
                                         mpiRequestCancelledCallback)
    c_SetMpiRequestCancelledCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetMpiCollectiveBeginCallback(evtReaderCallbacks, mpiCollectiveBeginCallback):
    c_SetMpiCollectiveBeginCallback = conf.lib.OTF2_EvtReaderCallbacks_SetMpiCollectiveBeginCallback
    c_SetMpiCollectiveBeginCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_MpiCollectiveBegin ]
    c_SetMpiCollectiveBeginCallback.restype = ErrorCode
    c_SetMpiCollectiveBeginCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_MpiCollectiveBegin,
                                         mpiCollectiveBeginCallback)
    c_SetMpiCollectiveBeginCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetMpiCollectiveEndCallback(evtReaderCallbacks, mpiCollectiveEndCallback):
    c_SetMpiCollectiveEndCallback = conf.lib.OTF2_EvtReaderCallbacks_SetMpiCollectiveEndCallback
    c_SetMpiCollectiveEndCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_MpiCollectiveEnd ]
    c_SetMpiCollectiveEndCallback.restype = ErrorCode
    c_SetMpiCollectiveEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_MpiCollectiveEnd,
                                         mpiCollectiveEndCallback)
    c_SetMpiCollectiveEndCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetOmpForkCallback(evtReaderCallbacks, ompForkCallback):
    c_SetOmpForkCallback = conf.lib.OTF2_EvtReaderCallbacks_SetOmpForkCallback
    c_SetOmpForkCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_OmpFork ]
    c_SetOmpForkCallback.restype = ErrorCode
    c_SetOmpForkCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_OmpFork,
                                         ompForkCallback)
    c_SetOmpForkCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetOmpJoinCallback(evtReaderCallbacks, ompJoinCallback):
    c_SetOmpJoinCallback = conf.lib.OTF2_EvtReaderCallbacks_SetOmpJoinCallback
    c_SetOmpJoinCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_OmpJoin ]
    c_SetOmpJoinCallback.restype = ErrorCode
    c_SetOmpJoinCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_OmpJoin,
                                         ompJoinCallback)
    c_SetOmpJoinCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetOmpAcquireLockCallback(evtReaderCallbacks, ompAcquireLockCallback):
    c_SetOmpAcquireLockCallback = conf.lib.OTF2_EvtReaderCallbacks_SetOmpAcquireLockCallback
    c_SetOmpAcquireLockCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_OmpAcquireLock ]
    c_SetOmpAcquireLockCallback.restype = ErrorCode
    c_SetOmpAcquireLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_OmpAcquireLock,
                                         ompAcquireLockCallback)
    c_SetOmpAcquireLockCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetOmpReleaseLockCallback(evtReaderCallbacks, ompReleaseLockCallback):
    c_SetOmpReleaseLockCallback = conf.lib.OTF2_EvtReaderCallbacks_SetOmpReleaseLockCallback
    c_SetOmpReleaseLockCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_OmpReleaseLock ]
    c_SetOmpReleaseLockCallback.restype = ErrorCode
    c_SetOmpReleaseLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_OmpReleaseLock,
                                         ompReleaseLockCallback)
    c_SetOmpReleaseLockCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetOmpTaskCreateCallback(evtReaderCallbacks, ompTaskCreateCallback):
    c_SetOmpTaskCreateCallback = conf.lib.OTF2_EvtReaderCallbacks_SetOmpTaskCreateCallback
    c_SetOmpTaskCreateCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_OmpTaskCreate ]
    c_SetOmpTaskCreateCallback.restype = ErrorCode
    c_SetOmpTaskCreateCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_OmpTaskCreate,
                                         ompTaskCreateCallback)
    c_SetOmpTaskCreateCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetOmpTaskSwitchCallback(evtReaderCallbacks, ompTaskSwitchCallback):
    c_SetOmpTaskSwitchCallback = conf.lib.OTF2_EvtReaderCallbacks_SetOmpTaskSwitchCallback
    c_SetOmpTaskSwitchCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_OmpTaskSwitch ]
    c_SetOmpTaskSwitchCallback.restype = ErrorCode
    c_SetOmpTaskSwitchCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_OmpTaskSwitch,
                                         ompTaskSwitchCallback)
    c_SetOmpTaskSwitchCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetOmpTaskCompleteCallback(evtReaderCallbacks, ompTaskCompleteCallback):
    c_SetOmpTaskCompleteCallback = conf.lib.OTF2_EvtReaderCallbacks_SetOmpTaskCompleteCallback
    c_SetOmpTaskCompleteCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_OmpTaskComplete ]
    c_SetOmpTaskCompleteCallback.restype = ErrorCode
    c_SetOmpTaskCompleteCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_OmpTaskComplete,
                                         ompTaskCompleteCallback)
    c_SetOmpTaskCompleteCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetMetricCallback(evtReaderCallbacks, metricCallback):
    c_SetMetricCallback = conf.lib.OTF2_EvtReaderCallbacks_SetMetricCallback
    c_SetMetricCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_Metric ]
    c_SetMetricCallback.restype = ErrorCode
    c_SetMetricCallback.errcheck = HandleErrorCode
    def convert_args_metric(metric, number_of_metrics, type_ids_array, metric_values_array):
        type_ids = [type_ids_array[i] for i in range(number_of_metrics)]
        metric_values = [metric_values_array[i] for i in range(number_of_metrics)]
        return metric, type_ids, metric_values
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_Metric,
                                         metricCallback, convert_args_metric)
    c_SetMetricCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetParameterStringCallback(evtReaderCallbacks, parameterStringCallback):
    c_SetParameterStringCallback = conf.lib.OTF2_EvtReaderCallbacks_SetParameterStringCallback
    c_SetParameterStringCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ParameterString ]
    c_SetParameterStringCallback.restype = ErrorCode
    c_SetParameterStringCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ParameterString,
                                         parameterStringCallback)
    c_SetParameterStringCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetParameterIntCallback(evtReaderCallbacks, parameterIntCallback):
    c_SetParameterIntCallback = conf.lib.OTF2_EvtReaderCallbacks_SetParameterIntCallback
    c_SetParameterIntCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ParameterInt ]
    c_SetParameterIntCallback.restype = ErrorCode
    c_SetParameterIntCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ParameterInt,
                                         parameterIntCallback)
    c_SetParameterIntCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetParameterUnsignedIntCallback(evtReaderCallbacks, parameterUnsignedIntCallback):
    c_SetParameterUnsignedIntCallback = conf.lib.OTF2_EvtReaderCallbacks_SetParameterUnsignedIntCallback
    c_SetParameterUnsignedIntCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ParameterUnsignedInt ]
    c_SetParameterUnsignedIntCallback.restype = ErrorCode
    c_SetParameterUnsignedIntCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ParameterUnsignedInt,
                                         parameterUnsignedIntCallback)
    c_SetParameterUnsignedIntCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaWinCreateCallback(evtReaderCallbacks, rmaWinCreateCallback):
    c_SetRmaWinCreateCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaWinCreateCallback
    c_SetRmaWinCreateCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaWinCreate ]
    c_SetRmaWinCreateCallback.restype = ErrorCode
    c_SetRmaWinCreateCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaWinCreate,
                                         rmaWinCreateCallback)
    c_SetRmaWinCreateCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaWinDestroyCallback(evtReaderCallbacks, rmaWinDestroyCallback):
    c_SetRmaWinDestroyCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaWinDestroyCallback
    c_SetRmaWinDestroyCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaWinDestroy ]
    c_SetRmaWinDestroyCallback.restype = ErrorCode
    c_SetRmaWinDestroyCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaWinDestroy,
                                         rmaWinDestroyCallback)
    c_SetRmaWinDestroyCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaCollectiveBeginCallback(evtReaderCallbacks, rmaCollectiveBeginCallback):
    c_SetRmaCollectiveBeginCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaCollectiveBeginCallback
    c_SetRmaCollectiveBeginCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaCollectiveBegin ]
    c_SetRmaCollectiveBeginCallback.restype = ErrorCode
    c_SetRmaCollectiveBeginCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaCollectiveBegin,
                                         rmaCollectiveBeginCallback)
    c_SetRmaCollectiveBeginCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaCollectiveEndCallback(evtReaderCallbacks, rmaCollectiveEndCallback):
    c_SetRmaCollectiveEndCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaCollectiveEndCallback
    c_SetRmaCollectiveEndCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaCollectiveEnd ]
    c_SetRmaCollectiveEndCallback.restype = ErrorCode
    c_SetRmaCollectiveEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaCollectiveEnd,
                                         rmaCollectiveEndCallback)
    c_SetRmaCollectiveEndCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaGroupSyncCallback(evtReaderCallbacks, rmaGroupSyncCallback):
    c_SetRmaGroupSyncCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaGroupSyncCallback
    c_SetRmaGroupSyncCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaGroupSync ]
    c_SetRmaGroupSyncCallback.restype = ErrorCode
    c_SetRmaGroupSyncCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaGroupSync,
                                         rmaGroupSyncCallback)
    c_SetRmaGroupSyncCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaRequestLockCallback(evtReaderCallbacks, rmaRequestLockCallback):
    c_SetRmaRequestLockCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaRequestLockCallback
    c_SetRmaRequestLockCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaRequestLock ]
    c_SetRmaRequestLockCallback.restype = ErrorCode
    c_SetRmaRequestLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaRequestLock,
                                         rmaRequestLockCallback)
    c_SetRmaRequestLockCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaAcquireLockCallback(evtReaderCallbacks, rmaAcquireLockCallback):
    c_SetRmaAcquireLockCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaAcquireLockCallback
    c_SetRmaAcquireLockCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaAcquireLock ]
    c_SetRmaAcquireLockCallback.restype = ErrorCode
    c_SetRmaAcquireLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaAcquireLock,
                                         rmaAcquireLockCallback)
    c_SetRmaAcquireLockCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaTryLockCallback(evtReaderCallbacks, rmaTryLockCallback):
    c_SetRmaTryLockCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaTryLockCallback
    c_SetRmaTryLockCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaTryLock ]
    c_SetRmaTryLockCallback.restype = ErrorCode
    c_SetRmaTryLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaTryLock,
                                         rmaTryLockCallback)
    c_SetRmaTryLockCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaReleaseLockCallback(evtReaderCallbacks, rmaReleaseLockCallback):
    c_SetRmaReleaseLockCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaReleaseLockCallback
    c_SetRmaReleaseLockCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaReleaseLock ]
    c_SetRmaReleaseLockCallback.restype = ErrorCode
    c_SetRmaReleaseLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaReleaseLock,
                                         rmaReleaseLockCallback)
    c_SetRmaReleaseLockCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaSyncCallback(evtReaderCallbacks, rmaSyncCallback):
    c_SetRmaSyncCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaSyncCallback
    c_SetRmaSyncCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaSync ]
    c_SetRmaSyncCallback.restype = ErrorCode
    c_SetRmaSyncCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaSync,
                                         rmaSyncCallback)
    c_SetRmaSyncCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaWaitChangeCallback(evtReaderCallbacks, rmaWaitChangeCallback):
    c_SetRmaWaitChangeCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaWaitChangeCallback
    c_SetRmaWaitChangeCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaWaitChange ]
    c_SetRmaWaitChangeCallback.restype = ErrorCode
    c_SetRmaWaitChangeCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaWaitChange,
                                         rmaWaitChangeCallback)
    c_SetRmaWaitChangeCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaPutCallback(evtReaderCallbacks, rmaPutCallback):
    c_SetRmaPutCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaPutCallback
    c_SetRmaPutCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaPut ]
    c_SetRmaPutCallback.restype = ErrorCode
    c_SetRmaPutCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaPut,
                                         rmaPutCallback)
    c_SetRmaPutCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaGetCallback(evtReaderCallbacks, rmaGetCallback):
    c_SetRmaGetCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaGetCallback
    c_SetRmaGetCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaGet ]
    c_SetRmaGetCallback.restype = ErrorCode
    c_SetRmaGetCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaGet,
                                         rmaGetCallback)
    c_SetRmaGetCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaAtomicCallback(evtReaderCallbacks, rmaAtomicCallback):
    c_SetRmaAtomicCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaAtomicCallback
    c_SetRmaAtomicCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaAtomic ]
    c_SetRmaAtomicCallback.restype = ErrorCode
    c_SetRmaAtomicCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaAtomic,
                                         rmaAtomicCallback)
    c_SetRmaAtomicCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaOpCompleteBlockingCallback(evtReaderCallbacks, rmaOpCompleteBlockingCallback):
    c_SetRmaOpCompleteBlockingCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaOpCompleteBlockingCallback
    c_SetRmaOpCompleteBlockingCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaOpCompleteBlocking ]
    c_SetRmaOpCompleteBlockingCallback.restype = ErrorCode
    c_SetRmaOpCompleteBlockingCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaOpCompleteBlocking,
                                         rmaOpCompleteBlockingCallback)
    c_SetRmaOpCompleteBlockingCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaOpCompleteNonBlockingCallback(evtReaderCallbacks, rmaOpCompleteNonBlockingCallback):
    c_SetRmaOpCompleteNonBlockingCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaOpCompleteNonBlockingCallback
    c_SetRmaOpCompleteNonBlockingCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaOpCompleteNonBlocking ]
    c_SetRmaOpCompleteNonBlockingCallback.restype = ErrorCode
    c_SetRmaOpCompleteNonBlockingCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaOpCompleteNonBlocking,
                                         rmaOpCompleteNonBlockingCallback)
    c_SetRmaOpCompleteNonBlockingCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaOpTestCallback(evtReaderCallbacks, rmaOpTestCallback):
    c_SetRmaOpTestCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaOpTestCallback
    c_SetRmaOpTestCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaOpTest ]
    c_SetRmaOpTestCallback.restype = ErrorCode
    c_SetRmaOpTestCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaOpTest,
                                         rmaOpTestCallback)
    c_SetRmaOpTestCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetRmaOpCompleteRemoteCallback(evtReaderCallbacks, rmaOpCompleteRemoteCallback):
    c_SetRmaOpCompleteRemoteCallback = conf.lib.OTF2_EvtReaderCallbacks_SetRmaOpCompleteRemoteCallback
    c_SetRmaOpCompleteRemoteCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_RmaOpCompleteRemote ]
    c_SetRmaOpCompleteRemoteCallback.restype = ErrorCode
    c_SetRmaOpCompleteRemoteCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_RmaOpCompleteRemote,
                                         rmaOpCompleteRemoteCallback)
    c_SetRmaOpCompleteRemoteCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadForkCallback(evtReaderCallbacks, threadForkCallback):
    c_SetThreadForkCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadForkCallback
    c_SetThreadForkCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadFork ]
    c_SetThreadForkCallback.restype = ErrorCode
    c_SetThreadForkCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadFork,
                                         threadForkCallback)
    c_SetThreadForkCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadJoinCallback(evtReaderCallbacks, threadJoinCallback):
    c_SetThreadJoinCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadJoinCallback
    c_SetThreadJoinCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadJoin ]
    c_SetThreadJoinCallback.restype = ErrorCode
    c_SetThreadJoinCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadJoin,
                                         threadJoinCallback)
    c_SetThreadJoinCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadTeamBeginCallback(evtReaderCallbacks, threadTeamBeginCallback):
    c_SetThreadTeamBeginCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadTeamBeginCallback
    c_SetThreadTeamBeginCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadTeamBegin ]
    c_SetThreadTeamBeginCallback.restype = ErrorCode
    c_SetThreadTeamBeginCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadTeamBegin,
                                         threadTeamBeginCallback)
    c_SetThreadTeamBeginCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadTeamEndCallback(evtReaderCallbacks, threadTeamEndCallback):
    c_SetThreadTeamEndCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadTeamEndCallback
    c_SetThreadTeamEndCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadTeamEnd ]
    c_SetThreadTeamEndCallback.restype = ErrorCode
    c_SetThreadTeamEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadTeamEnd,
                                         threadTeamEndCallback)
    c_SetThreadTeamEndCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadAcquireLockCallback(evtReaderCallbacks, threadAcquireLockCallback):
    c_SetThreadAcquireLockCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadAcquireLockCallback
    c_SetThreadAcquireLockCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadAcquireLock ]
    c_SetThreadAcquireLockCallback.restype = ErrorCode
    c_SetThreadAcquireLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadAcquireLock,
                                         threadAcquireLockCallback)
    c_SetThreadAcquireLockCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadReleaseLockCallback(evtReaderCallbacks, threadReleaseLockCallback):
    c_SetThreadReleaseLockCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadReleaseLockCallback
    c_SetThreadReleaseLockCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadReleaseLock ]
    c_SetThreadReleaseLockCallback.restype = ErrorCode
    c_SetThreadReleaseLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadReleaseLock,
                                         threadReleaseLockCallback)
    c_SetThreadReleaseLockCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadTaskCreateCallback(evtReaderCallbacks, threadTaskCreateCallback):
    c_SetThreadTaskCreateCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadTaskCreateCallback
    c_SetThreadTaskCreateCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadTaskCreate ]
    c_SetThreadTaskCreateCallback.restype = ErrorCode
    c_SetThreadTaskCreateCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadTaskCreate,
                                         threadTaskCreateCallback)
    c_SetThreadTaskCreateCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadTaskSwitchCallback(evtReaderCallbacks, threadTaskSwitchCallback):
    c_SetThreadTaskSwitchCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadTaskSwitchCallback
    c_SetThreadTaskSwitchCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadTaskSwitch ]
    c_SetThreadTaskSwitchCallback.restype = ErrorCode
    c_SetThreadTaskSwitchCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadTaskSwitch,
                                         threadTaskSwitchCallback)
    c_SetThreadTaskSwitchCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadTaskCompleteCallback(evtReaderCallbacks, threadTaskCompleteCallback):
    c_SetThreadTaskCompleteCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadTaskCompleteCallback
    c_SetThreadTaskCompleteCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadTaskComplete ]
    c_SetThreadTaskCompleteCallback.restype = ErrorCode
    c_SetThreadTaskCompleteCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadTaskComplete,
                                         threadTaskCompleteCallback)
    c_SetThreadTaskCompleteCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadCreateCallback(evtReaderCallbacks, threadCreateCallback):
    c_SetThreadCreateCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadCreateCallback
    c_SetThreadCreateCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadCreate ]
    c_SetThreadCreateCallback.restype = ErrorCode
    c_SetThreadCreateCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadCreate,
                                         threadCreateCallback)
    c_SetThreadCreateCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadBeginCallback(evtReaderCallbacks, threadBeginCallback):
    c_SetThreadBeginCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadBeginCallback
    c_SetThreadBeginCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadBegin ]
    c_SetThreadBeginCallback.restype = ErrorCode
    c_SetThreadBeginCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadBegin,
                                         threadBeginCallback)
    c_SetThreadBeginCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadWaitCallback(evtReaderCallbacks, threadWaitCallback):
    c_SetThreadWaitCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadWaitCallback
    c_SetThreadWaitCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadWait ]
    c_SetThreadWaitCallback.restype = ErrorCode
    c_SetThreadWaitCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadWait,
                                         threadWaitCallback)
    c_SetThreadWaitCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetThreadEndCallback(evtReaderCallbacks, threadEndCallback):
    c_SetThreadEndCallback = conf.lib.OTF2_EvtReaderCallbacks_SetThreadEndCallback
    c_SetThreadEndCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ThreadEnd ]
    c_SetThreadEndCallback.restype = ErrorCode
    c_SetThreadEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ThreadEnd,
                                         threadEndCallback)
    c_SetThreadEndCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetCallingContextEnterCallback(evtReaderCallbacks, callingContextEnterCallback):
    c_SetCallingContextEnterCallback = conf.lib.OTF2_EvtReaderCallbacks_SetCallingContextEnterCallback
    c_SetCallingContextEnterCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_CallingContextEnter ]
    c_SetCallingContextEnterCallback.restype = ErrorCode
    c_SetCallingContextEnterCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_CallingContextEnter,
                                         callingContextEnterCallback)
    c_SetCallingContextEnterCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetCallingContextLeaveCallback(evtReaderCallbacks, callingContextLeaveCallback):
    c_SetCallingContextLeaveCallback = conf.lib.OTF2_EvtReaderCallbacks_SetCallingContextLeaveCallback
    c_SetCallingContextLeaveCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_CallingContextLeave ]
    c_SetCallingContextLeaveCallback.restype = ErrorCode
    c_SetCallingContextLeaveCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_CallingContextLeave,
                                         callingContextLeaveCallback)
    c_SetCallingContextLeaveCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetCallingContextSampleCallback(evtReaderCallbacks, callingContextSampleCallback):
    c_SetCallingContextSampleCallback = conf.lib.OTF2_EvtReaderCallbacks_SetCallingContextSampleCallback
    c_SetCallingContextSampleCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_CallingContextSample ]
    c_SetCallingContextSampleCallback.restype = ErrorCode
    c_SetCallingContextSampleCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_CallingContextSample,
                                         callingContextSampleCallback)
    c_SetCallingContextSampleCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoCreateHandleCallback(evtReaderCallbacks, ioCreateHandleCallback):
    c_SetIoCreateHandleCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoCreateHandleCallback
    c_SetIoCreateHandleCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoCreateHandle ]
    c_SetIoCreateHandleCallback.restype = ErrorCode
    c_SetIoCreateHandleCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoCreateHandle,
                                         ioCreateHandleCallback)
    c_SetIoCreateHandleCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoDestroyHandleCallback(evtReaderCallbacks, ioDestroyHandleCallback):
    c_SetIoDestroyHandleCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoDestroyHandleCallback
    c_SetIoDestroyHandleCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoDestroyHandle ]
    c_SetIoDestroyHandleCallback.restype = ErrorCode
    c_SetIoDestroyHandleCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoDestroyHandle,
                                         ioDestroyHandleCallback)
    c_SetIoDestroyHandleCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoDuplicateHandleCallback(evtReaderCallbacks, ioDuplicateHandleCallback):
    c_SetIoDuplicateHandleCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoDuplicateHandleCallback
    c_SetIoDuplicateHandleCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoDuplicateHandle ]
    c_SetIoDuplicateHandleCallback.restype = ErrorCode
    c_SetIoDuplicateHandleCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoDuplicateHandle,
                                         ioDuplicateHandleCallback)
    c_SetIoDuplicateHandleCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoSeekCallback(evtReaderCallbacks, ioSeekCallback):
    c_SetIoSeekCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoSeekCallback
    c_SetIoSeekCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoSeek ]
    c_SetIoSeekCallback.restype = ErrorCode
    c_SetIoSeekCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoSeek,
                                         ioSeekCallback)
    c_SetIoSeekCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoChangeStatusFlagsCallback(evtReaderCallbacks, ioChangeStatusFlagsCallback):
    c_SetIoChangeStatusFlagsCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoChangeStatusFlagsCallback
    c_SetIoChangeStatusFlagsCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoChangeStatusFlags ]
    c_SetIoChangeStatusFlagsCallback.restype = ErrorCode
    c_SetIoChangeStatusFlagsCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoChangeStatusFlags,
                                         ioChangeStatusFlagsCallback)
    c_SetIoChangeStatusFlagsCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoDeleteFileCallback(evtReaderCallbacks, ioDeleteFileCallback):
    c_SetIoDeleteFileCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoDeleteFileCallback
    c_SetIoDeleteFileCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoDeleteFile ]
    c_SetIoDeleteFileCallback.restype = ErrorCode
    c_SetIoDeleteFileCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoDeleteFile,
                                         ioDeleteFileCallback)
    c_SetIoDeleteFileCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoOperationBeginCallback(evtReaderCallbacks, ioOperationBeginCallback):
    c_SetIoOperationBeginCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoOperationBeginCallback
    c_SetIoOperationBeginCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoOperationBegin ]
    c_SetIoOperationBeginCallback.restype = ErrorCode
    c_SetIoOperationBeginCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoOperationBegin,
                                         ioOperationBeginCallback)
    c_SetIoOperationBeginCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoOperationTestCallback(evtReaderCallbacks, ioOperationTestCallback):
    c_SetIoOperationTestCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoOperationTestCallback
    c_SetIoOperationTestCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoOperationTest ]
    c_SetIoOperationTestCallback.restype = ErrorCode
    c_SetIoOperationTestCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoOperationTest,
                                         ioOperationTestCallback)
    c_SetIoOperationTestCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoOperationIssuedCallback(evtReaderCallbacks, ioOperationIssuedCallback):
    c_SetIoOperationIssuedCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoOperationIssuedCallback
    c_SetIoOperationIssuedCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoOperationIssued ]
    c_SetIoOperationIssuedCallback.restype = ErrorCode
    c_SetIoOperationIssuedCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoOperationIssued,
                                         ioOperationIssuedCallback)
    c_SetIoOperationIssuedCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoOperationCompleteCallback(evtReaderCallbacks, ioOperationCompleteCallback):
    c_SetIoOperationCompleteCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoOperationCompleteCallback
    c_SetIoOperationCompleteCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoOperationComplete ]
    c_SetIoOperationCompleteCallback.restype = ErrorCode
    c_SetIoOperationCompleteCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoOperationComplete,
                                         ioOperationCompleteCallback)
    c_SetIoOperationCompleteCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoOperationCancelledCallback(evtReaderCallbacks, ioOperationCancelledCallback):
    c_SetIoOperationCancelledCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoOperationCancelledCallback
    c_SetIoOperationCancelledCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoOperationCancelled ]
    c_SetIoOperationCancelledCallback.restype = ErrorCode
    c_SetIoOperationCancelledCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoOperationCancelled,
                                         ioOperationCancelledCallback)
    c_SetIoOperationCancelledCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoAcquireLockCallback(evtReaderCallbacks, ioAcquireLockCallback):
    c_SetIoAcquireLockCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoAcquireLockCallback
    c_SetIoAcquireLockCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoAcquireLock ]
    c_SetIoAcquireLockCallback.restype = ErrorCode
    c_SetIoAcquireLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoAcquireLock,
                                         ioAcquireLockCallback)
    c_SetIoAcquireLockCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoReleaseLockCallback(evtReaderCallbacks, ioReleaseLockCallback):
    c_SetIoReleaseLockCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoReleaseLockCallback
    c_SetIoReleaseLockCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoReleaseLock ]
    c_SetIoReleaseLockCallback.restype = ErrorCode
    c_SetIoReleaseLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoReleaseLock,
                                         ioReleaseLockCallback)
    c_SetIoReleaseLockCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetIoTryLockCallback(evtReaderCallbacks, ioTryLockCallback):
    c_SetIoTryLockCallback = conf.lib.OTF2_EvtReaderCallbacks_SetIoTryLockCallback
    c_SetIoTryLockCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_IoTryLock ]
    c_SetIoTryLockCallback.restype = ErrorCode
    c_SetIoTryLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_IoTryLock,
                                         ioTryLockCallback)
    c_SetIoTryLockCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetProgramBeginCallback(evtReaderCallbacks, programBeginCallback):
    c_SetProgramBeginCallback = conf.lib.OTF2_EvtReaderCallbacks_SetProgramBeginCallback
    c_SetProgramBeginCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ProgramBegin ]
    c_SetProgramBeginCallback.restype = ErrorCode
    c_SetProgramBeginCallback.errcheck = HandleErrorCode
    def convert_args(program_name, number_of_arguments, arguments_array):
        arguments = [arguments_array[i] for i in range(number_of_arguments)]
        return program_name, arguments
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ProgramBegin,
                                         programBeginCallback, convert_args)
    c_SetProgramBeginCallback(evtReaderCallbacks, wrapped_callback)

def EvtReaderCallbacks_SetProgramEndCallback(evtReaderCallbacks, programEndCallback):
    c_SetProgramEndCallback = conf.lib.OTF2_EvtReaderCallbacks_SetProgramEndCallback
    c_SetProgramEndCallback.argtypes = [ ctypes.POINTER(EvtReaderCallbacks), _EvtReaderCallback_FP_ProgramEnd ]
    c_SetProgramEndCallback.restype = ErrorCode
    c_SetProgramEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_EvtReaderCallback_FP_ProgramEnd,
                                         programEndCallback)
    c_SetProgramEndCallback(evtReaderCallbacks, wrapped_callback)

__all__ = [
    'EvtReaderCallbacks',
    'EvtReaderCallbacks_New',
    'EvtReaderCallbacks_Delete',
    'EvtReaderCallbacks_Clear',
    'EvtReaderCallbacks_SetUnknownCallback',
    'EvtReaderCallbacks_SetBufferFlushCallback',
    'EvtReaderCallbacks_SetMeasurementOnOffCallback',
    'EvtReaderCallbacks_SetEnterCallback',
    'EvtReaderCallbacks_SetLeaveCallback',
    'EvtReaderCallbacks_SetMpiSendCallback',
    'EvtReaderCallbacks_SetMpiIsendCallback',
    'EvtReaderCallbacks_SetMpiIsendCompleteCallback',
    'EvtReaderCallbacks_SetMpiIrecvRequestCallback',
    'EvtReaderCallbacks_SetMpiRecvCallback',
    'EvtReaderCallbacks_SetMpiIrecvCallback',
    'EvtReaderCallbacks_SetMpiRequestTestCallback',
    'EvtReaderCallbacks_SetMpiRequestCancelledCallback',
    'EvtReaderCallbacks_SetMpiCollectiveBeginCallback',
    'EvtReaderCallbacks_SetMpiCollectiveEndCallback',
    'EvtReaderCallbacks_SetOmpForkCallback',
    'EvtReaderCallbacks_SetOmpJoinCallback',
    'EvtReaderCallbacks_SetOmpAcquireLockCallback',
    'EvtReaderCallbacks_SetOmpReleaseLockCallback',
    'EvtReaderCallbacks_SetOmpTaskCreateCallback',
    'EvtReaderCallbacks_SetOmpTaskSwitchCallback',
    'EvtReaderCallbacks_SetOmpTaskCompleteCallback',
    'EvtReaderCallbacks_SetMetricCallback',
    'EvtReaderCallbacks_SetParameterStringCallback',
    'EvtReaderCallbacks_SetParameterIntCallback',
    'EvtReaderCallbacks_SetParameterUnsignedIntCallback',
    'EvtReaderCallbacks_SetRmaWinCreateCallback',
    'EvtReaderCallbacks_SetRmaWinDestroyCallback',
    'EvtReaderCallbacks_SetRmaCollectiveBeginCallback',
    'EvtReaderCallbacks_SetRmaCollectiveEndCallback',
    'EvtReaderCallbacks_SetRmaGroupSyncCallback',
    'EvtReaderCallbacks_SetRmaRequestLockCallback',
    'EvtReaderCallbacks_SetRmaAcquireLockCallback',
    'EvtReaderCallbacks_SetRmaTryLockCallback',
    'EvtReaderCallbacks_SetRmaReleaseLockCallback',
    'EvtReaderCallbacks_SetRmaSyncCallback',
    'EvtReaderCallbacks_SetRmaWaitChangeCallback',
    'EvtReaderCallbacks_SetRmaPutCallback',
    'EvtReaderCallbacks_SetRmaGetCallback',
    'EvtReaderCallbacks_SetRmaAtomicCallback',
    'EvtReaderCallbacks_SetRmaOpCompleteBlockingCallback',
    'EvtReaderCallbacks_SetRmaOpCompleteNonBlockingCallback',
    'EvtReaderCallbacks_SetRmaOpTestCallback',
    'EvtReaderCallbacks_SetRmaOpCompleteRemoteCallback',
    'EvtReaderCallbacks_SetThreadForkCallback',
    'EvtReaderCallbacks_SetThreadJoinCallback',
    'EvtReaderCallbacks_SetThreadTeamBeginCallback',
    'EvtReaderCallbacks_SetThreadTeamEndCallback',
    'EvtReaderCallbacks_SetThreadAcquireLockCallback',
    'EvtReaderCallbacks_SetThreadReleaseLockCallback',
    'EvtReaderCallbacks_SetThreadTaskCreateCallback',
    'EvtReaderCallbacks_SetThreadTaskSwitchCallback',
    'EvtReaderCallbacks_SetThreadTaskCompleteCallback',
    'EvtReaderCallbacks_SetThreadCreateCallback',
    'EvtReaderCallbacks_SetThreadBeginCallback',
    'EvtReaderCallbacks_SetThreadWaitCallback',
    'EvtReaderCallbacks_SetThreadEndCallback',
    'EvtReaderCallbacks_SetCallingContextEnterCallback',
    'EvtReaderCallbacks_SetCallingContextLeaveCallback',
    'EvtReaderCallbacks_SetCallingContextSampleCallback',
    'EvtReaderCallbacks_SetIoCreateHandleCallback',
    'EvtReaderCallbacks_SetIoDestroyHandleCallback',
    'EvtReaderCallbacks_SetIoDuplicateHandleCallback',
    'EvtReaderCallbacks_SetIoSeekCallback',
    'EvtReaderCallbacks_SetIoChangeStatusFlagsCallback',
    'EvtReaderCallbacks_SetIoDeleteFileCallback',
    'EvtReaderCallbacks_SetIoOperationBeginCallback',
    'EvtReaderCallbacks_SetIoOperationTestCallback',
    'EvtReaderCallbacks_SetIoOperationIssuedCallback',
    'EvtReaderCallbacks_SetIoOperationCompleteCallback',
    'EvtReaderCallbacks_SetIoOperationCancelledCallback',
    'EvtReaderCallbacks_SetIoAcquireLockCallback',
    'EvtReaderCallbacks_SetIoReleaseLockCallback',
    'EvtReaderCallbacks_SetIoTryLockCallback',
    'EvtReaderCallbacks_SetProgramBeginCallback',
    'EvtReaderCallbacks_SetProgramEndCallback',
]
