
''' Generated by OTF2 Template Engine '''

import ctypes

from .Config import EnumBase, EnumBitset

class MeasurementMode(EnumBase, ctypes.c_uint8):
    pass

MEASUREMENT_ON = MeasurementMode._construct(1, "ON")
MEASUREMENT_OFF = MeasurementMode._construct(2, "OFF")

class CollectiveOp(EnumBase, ctypes.c_uint8):
    pass

COLLECTIVE_OP_BARRIER = CollectiveOp._construct(0, "BARRIER")
COLLECTIVE_OP_BCAST = CollectiveOp._construct(1, "BCAST")
COLLECTIVE_OP_GATHER = CollectiveOp._construct(2, "GATHER")
COLLECTIVE_OP_GATHERV = CollectiveOp._construct(3, "GATHERV")
COLLECTIVE_OP_SCATTER = CollectiveOp._construct(4, "SCATTER")
COLLECTIVE_OP_SCATTERV = CollectiveOp._construct(5, "SCATTERV")
COLLECTIVE_OP_ALLGATHER = CollectiveOp._construct(6, "ALLGATHER")
COLLECTIVE_OP_ALLGATHERV = CollectiveOp._construct(7, "ALLGATHERV")
COLLECTIVE_OP_ALLTOALL = CollectiveOp._construct(8, "ALLTOALL")
COLLECTIVE_OP_ALLTOALLV = CollectiveOp._construct(9, "ALLTOALLV")
COLLECTIVE_OP_ALLTOALLW = CollectiveOp._construct(10, "ALLTOALLW")
COLLECTIVE_OP_ALLREDUCE = CollectiveOp._construct(11, "ALLREDUCE")
COLLECTIVE_OP_REDUCE = CollectiveOp._construct(12, "REDUCE")
COLLECTIVE_OP_REDUCE_SCATTER = CollectiveOp._construct(13, "REDUCE_SCATTER")
COLLECTIVE_OP_SCAN = CollectiveOp._construct(14, "SCAN")
COLLECTIVE_OP_EXSCAN = CollectiveOp._construct(15, "EXSCAN")
COLLECTIVE_OP_REDUCE_SCATTER_BLOCK = CollectiveOp._construct(16, "REDUCE_SCATTER_BLOCK")
COLLECTIVE_OP_CREATE_HANDLE = CollectiveOp._construct(17, "CREATE_HANDLE")
COLLECTIVE_OP_DESTROY_HANDLE = CollectiveOp._construct(18, "DESTROY_HANDLE")
COLLECTIVE_OP_ALLOCATE = CollectiveOp._construct(19, "ALLOCATE")
COLLECTIVE_OP_DEALLOCATE = CollectiveOp._construct(20, "DEALLOCATE")
COLLECTIVE_OP_CREATE_HANDLE_AND_ALLOCATE = CollectiveOp._construct(21, "CREATE_HANDLE_AND_ALLOCATE")
COLLECTIVE_OP_DESTROY_HANDLE_AND_DEALLOCATE = CollectiveOp._construct(22, "DESTROY_HANDLE_AND_DEALLOCATE")

class RmaSyncType(EnumBase, ctypes.c_uint8):
    pass

RMA_SYNC_TYPE_MEMORY = RmaSyncType._construct(0, "MEMORY")
RMA_SYNC_TYPE_NOTIFY_IN = RmaSyncType._construct(1, "NOTIFY_IN")
RMA_SYNC_TYPE_NOTIFY_OUT = RmaSyncType._construct(2, "NOTIFY_OUT")

class RmaSyncLevel(EnumBitset, ctypes.c_uint32):
    pass

RMA_SYNC_LEVEL_NONE = RmaSyncLevel._construct(0, "NONE")
RMA_SYNC_LEVEL_PROCESS = RmaSyncLevel._construct(( 1 << 0 ), "PROCESS")
RMA_SYNC_LEVEL_MEMORY = RmaSyncLevel._construct(( 1 << 1 ), "MEMORY")

class LockType(EnumBase, ctypes.c_uint8):
    pass

LOCK_EXCLUSIVE = LockType._construct(0, "EXCLUSIVE")
LOCK_SHARED = LockType._construct(1, "SHARED")

class RmaAtomicType(EnumBase, ctypes.c_uint8):
    pass

RMA_ATOMIC_TYPE_ACCUMULATE = RmaAtomicType._construct(0, "ACCUMULATE")
RMA_ATOMIC_TYPE_INCREMENT = RmaAtomicType._construct(1, "INCREMENT")
RMA_ATOMIC_TYPE_TEST_AND_SET = RmaAtomicType._construct(2, "TEST_AND_SET")
RMA_ATOMIC_TYPE_COMPARE_AND_SWAP = RmaAtomicType._construct(3, "COMPARE_AND_SWAP")
RMA_ATOMIC_TYPE_SWAP = RmaAtomicType._construct(4, "SWAP")
RMA_ATOMIC_TYPE_FETCH_AND_ADD = RmaAtomicType._construct(5, "FETCH_AND_ADD")
RMA_ATOMIC_TYPE_FETCH_AND_INCREMENT = RmaAtomicType._construct(6, "FETCH_AND_INCREMENT")
RMA_ATOMIC_TYPE_FETCH_AND_ACCUMULATE = RmaAtomicType._construct(7, "FETCH_AND_ACCUMULATE")

class IoCreationFlag(EnumBitset, ctypes.c_uint32):
    pass

IO_CREATION_FLAG_NONE = IoCreationFlag._construct(0, "NONE")
IO_CREATION_FLAG_CREATE = IoCreationFlag._construct(1 << 0, "CREATE")
IO_CREATION_FLAG_TRUNCATE = IoCreationFlag._construct(1 << 1, "TRUNCATE")
IO_CREATION_FLAG_DIRECTORY = IoCreationFlag._construct(1 << 2, "DIRECTORY")
IO_CREATION_FLAG_EXCLUSIVE = IoCreationFlag._construct(1 << 3, "EXCLUSIVE")
IO_CREATION_FLAG_NO_CONTROLLING_TERMINAL = IoCreationFlag._construct(1 << 4, "NO_CONTROLLING_TERMINAL")
IO_CREATION_FLAG_NO_FOLLOW = IoCreationFlag._construct(1 << 5, "NO_FOLLOW")
IO_CREATION_FLAG_PATH = IoCreationFlag._construct(1 << 6, "PATH")
IO_CREATION_FLAG_TEMPORARY_FILE = IoCreationFlag._construct(1 <<7, "TEMPORARY_FILE")
IO_CREATION_FLAG_LARGEFILE = IoCreationFlag._construct(1 << 8, "LARGEFILE")
IO_CREATION_FLAG_NO_SEEK = IoCreationFlag._construct(1 << 9, "NO_SEEK")
IO_CREATION_FLAG_UNIQUE = IoCreationFlag._construct(1 << 10, "UNIQUE")

class IoSeekOption(EnumBase, ctypes.c_uint8):
    pass

IO_SEEK_FROM_START = IoSeekOption._construct(0, "FROM_START")
IO_SEEK_FROM_CURRENT = IoSeekOption._construct(1, "FROM_CURRENT")
IO_SEEK_FROM_END = IoSeekOption._construct(2, "FROM_END")
IO_SEEK_DATA = IoSeekOption._construct(3, "DATA")
IO_SEEK_HOLE = IoSeekOption._construct(4, "HOLE")

class IoOperationMode(EnumBase, ctypes.c_uint8):
    pass

IO_OPERATION_MODE_READ = IoOperationMode._construct(0, "READ")
IO_OPERATION_MODE_WRITE = IoOperationMode._construct(1, "WRITE")
IO_OPERATION_MODE_FLUSH = IoOperationMode._construct(2, "FLUSH")

class IoOperationFlag(EnumBitset, ctypes.c_uint32):
    pass

IO_OPERATION_FLAG_NONE = IoOperationFlag._construct(0, "NONE")
IO_OPERATION_FLAG_NON_BLOCKING = IoOperationFlag._construct(1 << 0, "NON_BLOCKING")
IO_OPERATION_FLAG_COLLECTIVE = IoOperationFlag._construct(1 << 1, "COLLECTIVE")

class MetricValue(ctypes.Union):
    _fields_ = [
        ("signed_int", ctypes.c_int64),
        ("unsigned_int", ctypes.c_uint64),
        ("floating_point", ctypes.c_double),
    ]

__all__ = [
    'MeasurementMode',
    'MEASUREMENT_ON',
    'MEASUREMENT_OFF',
    'CollectiveOp',
    'COLLECTIVE_OP_BARRIER',
    'COLLECTIVE_OP_BCAST',
    'COLLECTIVE_OP_GATHER',
    'COLLECTIVE_OP_GATHERV',
    'COLLECTIVE_OP_SCATTER',
    'COLLECTIVE_OP_SCATTERV',
    'COLLECTIVE_OP_ALLGATHER',
    'COLLECTIVE_OP_ALLGATHERV',
    'COLLECTIVE_OP_ALLTOALL',
    'COLLECTIVE_OP_ALLTOALLV',
    'COLLECTIVE_OP_ALLTOALLW',
    'COLLECTIVE_OP_ALLREDUCE',
    'COLLECTIVE_OP_REDUCE',
    'COLLECTIVE_OP_REDUCE_SCATTER',
    'COLLECTIVE_OP_SCAN',
    'COLLECTIVE_OP_EXSCAN',
    'COLLECTIVE_OP_REDUCE_SCATTER_BLOCK',
    'COLLECTIVE_OP_CREATE_HANDLE',
    'COLLECTIVE_OP_DESTROY_HANDLE',
    'COLLECTIVE_OP_ALLOCATE',
    'COLLECTIVE_OP_DEALLOCATE',
    'COLLECTIVE_OP_CREATE_HANDLE_AND_ALLOCATE',
    'COLLECTIVE_OP_DESTROY_HANDLE_AND_DEALLOCATE',
    'RmaSyncType',
    'RMA_SYNC_TYPE_MEMORY',
    'RMA_SYNC_TYPE_NOTIFY_IN',
    'RMA_SYNC_TYPE_NOTIFY_OUT',
    'RmaSyncLevel',
    'RMA_SYNC_LEVEL_NONE',
    'RMA_SYNC_LEVEL_PROCESS',
    'RMA_SYNC_LEVEL_MEMORY',
    'LockType',
    'LOCK_EXCLUSIVE',
    'LOCK_SHARED',
    'RmaAtomicType',
    'RMA_ATOMIC_TYPE_ACCUMULATE',
    'RMA_ATOMIC_TYPE_INCREMENT',
    'RMA_ATOMIC_TYPE_TEST_AND_SET',
    'RMA_ATOMIC_TYPE_COMPARE_AND_SWAP',
    'RMA_ATOMIC_TYPE_SWAP',
    'RMA_ATOMIC_TYPE_FETCH_AND_ADD',
    'RMA_ATOMIC_TYPE_FETCH_AND_INCREMENT',
    'RMA_ATOMIC_TYPE_FETCH_AND_ACCUMULATE',
    'IoCreationFlag',
    'IO_CREATION_FLAG_NONE',
    'IO_CREATION_FLAG_CREATE',
    'IO_CREATION_FLAG_TRUNCATE',
    'IO_CREATION_FLAG_DIRECTORY',
    'IO_CREATION_FLAG_EXCLUSIVE',
    'IO_CREATION_FLAG_NO_CONTROLLING_TERMINAL',
    'IO_CREATION_FLAG_NO_FOLLOW',
    'IO_CREATION_FLAG_PATH',
    'IO_CREATION_FLAG_TEMPORARY_FILE',
    'IO_CREATION_FLAG_LARGEFILE',
    'IO_CREATION_FLAG_NO_SEEK',
    'IO_CREATION_FLAG_UNIQUE',
    'IoSeekOption',
    'IO_SEEK_FROM_START',
    'IO_SEEK_FROM_CURRENT',
    'IO_SEEK_FROM_END',
    'IO_SEEK_DATA',
    'IO_SEEK_HOLE',
    'IoOperationMode',
    'IO_OPERATION_MODE_READ',
    'IO_OPERATION_MODE_WRITE',
    'IO_OPERATION_MODE_FLUSH',
    'IoOperationFlag',
    'IO_OPERATION_FLAG_NONE',
    'IO_OPERATION_FLAG_NON_BLOCKING',
    'IO_OPERATION_FLAG_COLLECTIVE',
    'MetricValue'
]
