
''' Generated by OTF2 Template Engine '''

import ctypes

from .Config import conf, StrParam
from .ErrorCodes import ErrorCode, HandleErrorCode
from .GeneralDefinitions import *
from .Definitions import *
from .AttributeValue import AttributeValue
from .IdMap import IdMap


class DefWriter(ctypes.Structure):
    pass

def DefWriter_GetLocationID(writer):
    c_GetLocationID = conf.lib.OTF2_DefWriter_GetLocationID
    c_GetLocationID.argtypes = [ ctypes.POINTER(DefWriter), ctypes.POINTER(LocationRef) ]
    c_GetLocationID.restype = ErrorCode
    c_GetLocationID.errcheck = HandleErrorCode
    location = LocationRef()
    c_GetLocationID(writer, ctypes.byref(location))
    return location.value

def DefWriter_WriteMappingTable(writerHandle, mappingType, idMap):
    c_WriteMappingTable = conf.lib.OTF2_DefWriter_WriteMappingTable
    c_WriteMappingTable.argtypes = [ ctypes.POINTER(DefWriter), MappingType, ctypes.POINTER(IdMap) ]
    c_WriteMappingTable.restype = ErrorCode
    c_WriteMappingTable.errcheck = HandleErrorCode
    c_WriteMappingTable(writerHandle, mappingType, idMap)

def DefWriter_WriteClockOffset(writerHandle, time, offset, standardDeviation):
    c_WriteClockOffset = conf.lib.OTF2_DefWriter_WriteClockOffset
    c_WriteClockOffset.argtypes = [ ctypes.POINTER(DefWriter), TimeStamp, ctypes.c_int64, ctypes.c_double ]
    c_WriteClockOffset.restype = ErrorCode
    c_WriteClockOffset.errcheck = HandleErrorCode
    c_WriteClockOffset(writerHandle, time, offset, standardDeviation)

def DefWriter_WriteString(writerHandle, self, string):
    c_WriteString = conf.lib.OTF2_DefWriter_WriteString
    c_WriteString.argtypes = [ ctypes.POINTER(DefWriter), StringRef, StrParam ]
    c_WriteString.restype = ErrorCode
    c_WriteString.errcheck = HandleErrorCode
    c_WriteString(writerHandle, self, string)

def DefWriter_WriteAttribute(writerHandle, self, name, description, type):
    c_WriteAttribute = conf.lib.OTF2_DefWriter_WriteAttribute
    c_WriteAttribute.argtypes = [ ctypes.POINTER(DefWriter), AttributeRef, StringRef, StringRef, Type ]
    c_WriteAttribute.restype = ErrorCode
    c_WriteAttribute.errcheck = HandleErrorCode
    c_WriteAttribute(writerHandle, self, name, description, type)

def DefWriter_WriteSystemTreeNode(writerHandle, self, name, className, parent):
    c_WriteSystemTreeNode = conf.lib.OTF2_DefWriter_WriteSystemTreeNode
    c_WriteSystemTreeNode.argtypes = [ ctypes.POINTER(DefWriter), SystemTreeNodeRef, StringRef, StringRef, SystemTreeNodeRef ]
    c_WriteSystemTreeNode.restype = ErrorCode
    c_WriteSystemTreeNode.errcheck = HandleErrorCode
    c_WriteSystemTreeNode(writerHandle, self, name, className, parent)

def DefWriter_WriteLocationGroup(writerHandle, self, name, locationGroupType, systemTreeParent):
    c_WriteLocationGroup = conf.lib.OTF2_DefWriter_WriteLocationGroup
    c_WriteLocationGroup.argtypes = [ ctypes.POINTER(DefWriter), LocationGroupRef, StringRef, LocationGroupType, SystemTreeNodeRef ]
    c_WriteLocationGroup.restype = ErrorCode
    c_WriteLocationGroup.errcheck = HandleErrorCode
    c_WriteLocationGroup(writerHandle, self, name, locationGroupType, systemTreeParent)

def DefWriter_WriteLocation(writerHandle, self, name, locationType, numberOfEvents, locationGroup):
    c_WriteLocation = conf.lib.OTF2_DefWriter_WriteLocation
    c_WriteLocation.argtypes = [ ctypes.POINTER(DefWriter), LocationRef, StringRef, LocationType, ctypes.c_uint64, LocationGroupRef ]
    c_WriteLocation.restype = ErrorCode
    c_WriteLocation.errcheck = HandleErrorCode
    c_WriteLocation(writerHandle, self, name, locationType, numberOfEvents, locationGroup)

def DefWriter_WriteRegion(writerHandle, self, name, canonicalName, description, regionRole, paradigm, regionFlags, sourceFile, beginLineNumber, endLineNumber):
    c_WriteRegion = conf.lib.OTF2_DefWriter_WriteRegion
    c_WriteRegion.argtypes = [ ctypes.POINTER(DefWriter), RegionRef, StringRef, StringRef, StringRef, RegionRole, Paradigm, RegionFlag, StringRef, ctypes.c_uint32, ctypes.c_uint32 ]
    c_WriteRegion.restype = ErrorCode
    c_WriteRegion.errcheck = HandleErrorCode
    c_WriteRegion(writerHandle, self, name, canonicalName, description, regionRole, paradigm, regionFlags, sourceFile, beginLineNumber, endLineNumber)

def DefWriter_WriteCallsite(writerHandle, self, sourceFile, lineNumber, enteredRegion, leftRegion):
    c_WriteCallsite = conf.lib.OTF2_DefWriter_WriteCallsite
    c_WriteCallsite.argtypes = [ ctypes.POINTER(DefWriter), CallsiteRef, StringRef, ctypes.c_uint32, RegionRef, RegionRef ]
    c_WriteCallsite.restype = ErrorCode
    c_WriteCallsite.errcheck = HandleErrorCode
    c_WriteCallsite(writerHandle, self, sourceFile, lineNumber, enteredRegion, leftRegion)

def DefWriter_WriteCallpath(writerHandle, self, parent, region):
    c_WriteCallpath = conf.lib.OTF2_DefWriter_WriteCallpath
    c_WriteCallpath.argtypes = [ ctypes.POINTER(DefWriter), CallpathRef, CallpathRef, RegionRef ]
    c_WriteCallpath.restype = ErrorCode
    c_WriteCallpath.errcheck = HandleErrorCode
    c_WriteCallpath(writerHandle, self, parent, region)

def DefWriter_WriteGroup(writerHandle, self, name, groupType, paradigm, groupFlags, members):
    numberOfMembers = len(members)
    array_type = ctypes.c_uint64 * numberOfMembers
    members_array = array_type()
    members_array[:] = members

    c_WriteGroup = conf.lib.OTF2_DefWriter_WriteGroup
    c_WriteGroup.argtypes = [ ctypes.POINTER(DefWriter), GroupRef, StringRef, GroupType, Paradigm, GroupFlag, ctypes.c_uint32, array_type ]
    c_WriteGroup.restype = ErrorCode
    c_WriteGroup.errcheck = HandleErrorCode
    c_WriteGroup(writerHandle, self, name, groupType, paradigm, groupFlags, numberOfMembers, members_array)

def DefWriter_WriteMetricMember(writerHandle, self, name, description, metricType, metricMode, valueType, base, exponent, unit):
    c_WriteMetricMember = conf.lib.OTF2_DefWriter_WriteMetricMember
    c_WriteMetricMember.argtypes = [ ctypes.POINTER(DefWriter), MetricMemberRef, StringRef, StringRef, MetricType, MetricMode, Type, Base, ctypes.c_int64, StringRef ]
    c_WriteMetricMember.restype = ErrorCode
    c_WriteMetricMember.errcheck = HandleErrorCode
    c_WriteMetricMember(writerHandle, self, name, description, metricType, metricMode, valueType, base, exponent, unit)

def DefWriter_WriteMetricClass(writerHandle, self, metricMembers, metricOccurrence, recorderKind):
    numberOfMetrics = len(metricMembers)
    array_type = MetricMemberRef * numberOfMetrics
    metric_member_array = array_type()
    metric_member_array[:] = metricMembers

    c_WriteMetricClass = conf.lib.OTF2_DefWriter_WriteMetricClass
    c_WriteMetricClass.argtypes = [ ctypes.POINTER(DefWriter), MetricRef, ctypes.c_uint8, array_type, MetricOccurrence, RecorderKind ]
    c_WriteMetricClass.restype = ErrorCode
    c_WriteMetricClass.errcheck = HandleErrorCode
    c_WriteMetricClass(writerHandle, self, numberOfMetrics, metric_member_array, metricOccurrence, recorderKind)

def DefWriter_WriteMetricInstance(writerHandle, self, metricClass, recorder, metricScope, scope):
    c_WriteMetricInstance = conf.lib.OTF2_DefWriter_WriteMetricInstance
    c_WriteMetricInstance.argtypes = [ ctypes.POINTER(DefWriter), MetricRef, MetricRef, LocationRef, MetricScope, ctypes.c_uint64 ]
    c_WriteMetricInstance.restype = ErrorCode
    c_WriteMetricInstance.errcheck = HandleErrorCode
    c_WriteMetricInstance(writerHandle, self, metricClass, recorder, metricScope, scope)

def DefWriter_WriteComm(writerHandle, self, name, group, parent):
    c_WriteComm = conf.lib.OTF2_DefWriter_WriteComm
    c_WriteComm.argtypes = [ ctypes.POINTER(DefWriter), CommRef, StringRef, GroupRef, CommRef ]
    c_WriteComm.restype = ErrorCode
    c_WriteComm.errcheck = HandleErrorCode
    c_WriteComm(writerHandle, self, name, group, parent)

def DefWriter_WriteParameter(writerHandle, self, name, parameterType):
    c_WriteParameter = conf.lib.OTF2_DefWriter_WriteParameter
    c_WriteParameter.argtypes = [ ctypes.POINTER(DefWriter), ParameterRef, StringRef, ParameterType ]
    c_WriteParameter.restype = ErrorCode
    c_WriteParameter.errcheck = HandleErrorCode
    c_WriteParameter(writerHandle, self, name, parameterType)

def DefWriter_WriteRmaWin(writerHandle, self, name, comm):
    c_WriteRmaWin = conf.lib.OTF2_DefWriter_WriteRmaWin
    c_WriteRmaWin.argtypes = [ ctypes.POINTER(DefWriter), RmaWinRef, StringRef, CommRef ]
    c_WriteRmaWin.restype = ErrorCode
    c_WriteRmaWin.errcheck = HandleErrorCode
    c_WriteRmaWin(writerHandle, self, name, comm)

def DefWriter_WriteMetricClassRecorder(writerHandle, metric, recorder):
    c_WriteMetricClassRecorder = conf.lib.OTF2_DefWriter_WriteMetricClassRecorder
    c_WriteMetricClassRecorder.argtypes = [ ctypes.POINTER(DefWriter), MetricRef, LocationRef ]
    c_WriteMetricClassRecorder.restype = ErrorCode
    c_WriteMetricClassRecorder.errcheck = HandleErrorCode
    c_WriteMetricClassRecorder(writerHandle, metric, recorder)

def DefWriter_WriteSystemTreeNodeProperty(writerHandle, systemTreeNode, name, type, value):
    c_WriteSystemTreeNodeProperty = conf.lib.OTF2_DefWriter_WriteSystemTreeNodeProperty
    c_WriteSystemTreeNodeProperty.argtypes = [ ctypes.POINTER(DefWriter), SystemTreeNodeRef, StringRef, Type, AttributeValue._arg_type ]
    c_WriteSystemTreeNodeProperty.restype = ErrorCode
    c_WriteSystemTreeNodeProperty.errcheck = HandleErrorCode
    c_WriteSystemTreeNodeProperty(writerHandle, systemTreeNode, name, type, value._arg_value)

def DefWriter_WriteSystemTreeNodeDomain(writerHandle, systemTreeNode, systemTreeDomain):
    c_WriteSystemTreeNodeDomain = conf.lib.OTF2_DefWriter_WriteSystemTreeNodeDomain
    c_WriteSystemTreeNodeDomain.argtypes = [ ctypes.POINTER(DefWriter), SystemTreeNodeRef, SystemTreeDomain ]
    c_WriteSystemTreeNodeDomain.restype = ErrorCode
    c_WriteSystemTreeNodeDomain.errcheck = HandleErrorCode
    c_WriteSystemTreeNodeDomain(writerHandle, systemTreeNode, systemTreeDomain)

def DefWriter_WriteLocationGroupProperty(writerHandle, locationGroup, name, type, value):
    c_WriteLocationGroupProperty = conf.lib.OTF2_DefWriter_WriteLocationGroupProperty
    c_WriteLocationGroupProperty.argtypes = [ ctypes.POINTER(DefWriter), LocationGroupRef, StringRef, Type, AttributeValue._arg_type ]
    c_WriteLocationGroupProperty.restype = ErrorCode
    c_WriteLocationGroupProperty.errcheck = HandleErrorCode
    c_WriteLocationGroupProperty(writerHandle, locationGroup, name, type, value._arg_value)

def DefWriter_WriteLocationProperty(writerHandle, location, name, type, value):
    c_WriteLocationProperty = conf.lib.OTF2_DefWriter_WriteLocationProperty
    c_WriteLocationProperty.argtypes = [ ctypes.POINTER(DefWriter), LocationRef, StringRef, Type, AttributeValue._arg_type ]
    c_WriteLocationProperty.restype = ErrorCode
    c_WriteLocationProperty.errcheck = HandleErrorCode
    c_WriteLocationProperty(writerHandle, location, name, type, value._arg_value)

def DefWriter_WriteCartDimension(writerHandle, self, name, size, cartPeriodicity):
    c_WriteCartDimension = conf.lib.OTF2_DefWriter_WriteCartDimension
    c_WriteCartDimension.argtypes = [ ctypes.POINTER(DefWriter), CartDimensionRef, StringRef, ctypes.c_uint32, CartPeriodicity ]
    c_WriteCartDimension.restype = ErrorCode
    c_WriteCartDimension.errcheck = HandleErrorCode
    c_WriteCartDimension(writerHandle, self, name, size, cartPeriodicity)

def DefWriter_WriteCartTopology(writerHandle, self, name, communicator, cartDimensions):
    numberOfDimensions = len(cartDimensions)
    array_type = CartDimensionRef * numberOfDimensions
    cart_dimensions_array = array_type()
    cart_dimensions_array[:] = cartDimensions

    c_WriteCartTopology = conf.lib.OTF2_DefWriter_WriteCartTopology
    c_WriteCartTopology.argtypes = [ ctypes.POINTER(DefWriter), CartTopologyRef, StringRef, CommRef, ctypes.c_uint8, array_type ]
    c_WriteCartTopology.restype = ErrorCode
    c_WriteCartTopology.errcheck = HandleErrorCode
    c_WriteCartTopology(writerHandle, self, name, communicator, numberOfDimensions, cart_dimensions_array)

def DefWriter_WriteCartCoordinate(writerHandle, cartTopology, rank, coordinates):
    numberOfDimensions = len(coordinates)
    array_type = ctypes.c_uint32 * numberOfDimensions
    coordinates_array = array_type()
    coordinates_array[:] = coordinates

    c_WriteCartCoordinate = conf.lib.OTF2_DefWriter_WriteCartCoordinate
    c_WriteCartCoordinate.argtypes = [ ctypes.POINTER(DefWriter), CartTopologyRef, ctypes.c_uint32, ctypes.c_uint8, array_type ]
    c_WriteCartCoordinate.restype = ErrorCode
    c_WriteCartCoordinate.errcheck = HandleErrorCode
    c_WriteCartCoordinate(writerHandle, cartTopology, rank, numberOfDimensions, coordinates_array)

def DefWriter_WriteSourceCodeLocation(writerHandle, self, file, lineNumber):
    c_WriteSourceCodeLocation = conf.lib.OTF2_DefWriter_WriteSourceCodeLocation
    c_WriteSourceCodeLocation.argtypes = [ ctypes.POINTER(DefWriter), SourceCodeLocationRef, StringRef, ctypes.c_uint32 ]
    c_WriteSourceCodeLocation.restype = ErrorCode
    c_WriteSourceCodeLocation.errcheck = HandleErrorCode
    c_WriteSourceCodeLocation(writerHandle, self, file, lineNumber)

def DefWriter_WriteCallingContext(writerHandle, self, region, sourceCodeLocation, parent):
    c_WriteCallingContext = conf.lib.OTF2_DefWriter_WriteCallingContext
    c_WriteCallingContext.argtypes = [ ctypes.POINTER(DefWriter), CallingContextRef, RegionRef, SourceCodeLocationRef, CallingContextRef ]
    c_WriteCallingContext.restype = ErrorCode
    c_WriteCallingContext.errcheck = HandleErrorCode
    c_WriteCallingContext(writerHandle, self, region, sourceCodeLocation, parent)

def DefWriter_WriteCallingContextProperty(writerHandle, callingContext, name, type, value):
    c_WriteCallingContextProperty = conf.lib.OTF2_DefWriter_WriteCallingContextProperty
    c_WriteCallingContextProperty.argtypes = [ ctypes.POINTER(DefWriter), CallingContextRef, StringRef, Type, AttributeValue._arg_type ]
    c_WriteCallingContextProperty.restype = ErrorCode
    c_WriteCallingContextProperty.errcheck = HandleErrorCode
    c_WriteCallingContextProperty(writerHandle, callingContext, name, type, value._arg_value)

def DefWriter_WriteInterruptGenerator(writerHandle, self, name, interruptGeneratorMode, base, exponent, period):
    c_WriteInterruptGenerator = conf.lib.OTF2_DefWriter_WriteInterruptGenerator
    c_WriteInterruptGenerator.argtypes = [ ctypes.POINTER(DefWriter), InterruptGeneratorRef, StringRef, InterruptGeneratorMode, Base, ctypes.c_int64, ctypes.c_uint64 ]
    c_WriteInterruptGenerator.restype = ErrorCode
    c_WriteInterruptGenerator.errcheck = HandleErrorCode
    c_WriteInterruptGenerator(writerHandle, self, name, interruptGeneratorMode, base, exponent, period)

def DefWriter_WriteIoFileProperty(writerHandle, ioFile, name, type, value):
    c_WriteIoFileProperty = conf.lib.OTF2_DefWriter_WriteIoFileProperty
    c_WriteIoFileProperty.argtypes = [ ctypes.POINTER(DefWriter), IoFileRef, StringRef, Type, AttributeValue._arg_type ]
    c_WriteIoFileProperty.restype = ErrorCode
    c_WriteIoFileProperty.errcheck = HandleErrorCode
    c_WriteIoFileProperty(writerHandle, ioFile, name, type, value._arg_value)

def DefWriter_WriteIoRegularFile(writerHandle, self, name, scope):
    c_WriteIoRegularFile = conf.lib.OTF2_DefWriter_WriteIoRegularFile
    c_WriteIoRegularFile.argtypes = [ ctypes.POINTER(DefWriter), IoFileRef, StringRef, SystemTreeNodeRef ]
    c_WriteIoRegularFile.restype = ErrorCode
    c_WriteIoRegularFile.errcheck = HandleErrorCode
    c_WriteIoRegularFile(writerHandle, self, name, scope)

def DefWriter_WriteIoDirectory(writerHandle, self, name, scope):
    c_WriteIoDirectory = conf.lib.OTF2_DefWriter_WriteIoDirectory
    c_WriteIoDirectory.argtypes = [ ctypes.POINTER(DefWriter), IoFileRef, StringRef, SystemTreeNodeRef ]
    c_WriteIoDirectory.restype = ErrorCode
    c_WriteIoDirectory.errcheck = HandleErrorCode
    c_WriteIoDirectory(writerHandle, self, name, scope)

def DefWriter_WriteIoHandle(writerHandle, self, name, file, ioParadigm, ioHandleFlags, comm, parent):
    c_WriteIoHandle = conf.lib.OTF2_DefWriter_WriteIoHandle
    c_WriteIoHandle.argtypes = [ ctypes.POINTER(DefWriter), IoHandleRef, StringRef, IoFileRef, IoParadigmRef, IoHandleFlag, CommRef, IoHandleRef ]
    c_WriteIoHandle.restype = ErrorCode
    c_WriteIoHandle.errcheck = HandleErrorCode
    c_WriteIoHandle(writerHandle, self, name, file, ioParadigm, ioHandleFlags, comm, parent)

def DefWriter_WriteIoPreCreatedHandleState(writerHandle, ioHandle, mode, statusFlags):
    c_WriteIoPreCreatedHandleState = conf.lib.OTF2_DefWriter_WriteIoPreCreatedHandleState
    c_WriteIoPreCreatedHandleState.argtypes = [ ctypes.POINTER(DefWriter), IoHandleRef, IoAccessMode, IoStatusFlag ]
    c_WriteIoPreCreatedHandleState.restype = ErrorCode
    c_WriteIoPreCreatedHandleState.errcheck = HandleErrorCode
    c_WriteIoPreCreatedHandleState(writerHandle, ioHandle, mode, statusFlags)

def DefWriter_WriteCallpathParameter(writerHandle, callpath, parameter, type, value):
    c_WriteCallpathParameter = conf.lib.OTF2_DefWriter_WriteCallpathParameter
    c_WriteCallpathParameter.argtypes = [ ctypes.POINTER(DefWriter), CallpathRef, ParameterRef, Type, AttributeValue._arg_type ]
    c_WriteCallpathParameter.restype = ErrorCode
    c_WriteCallpathParameter.errcheck = HandleErrorCode
    c_WriteCallpathParameter(writerHandle, callpath, parameter, type, value._arg_value)

__all__ = [
    'DefWriter',
    'DefWriter_GetLocationID',
    'DefWriter_WriteMappingTable',
    'DefWriter_WriteClockOffset',
    'DefWriter_WriteString',
    'DefWriter_WriteAttribute',
    'DefWriter_WriteSystemTreeNode',
    'DefWriter_WriteLocationGroup',
    'DefWriter_WriteLocation',
    'DefWriter_WriteRegion',
    'DefWriter_WriteCallsite',
    'DefWriter_WriteCallpath',
    'DefWriter_WriteGroup',
    'DefWriter_WriteMetricMember',
    'DefWriter_WriteMetricClass',
    'DefWriter_WriteMetricInstance',
    'DefWriter_WriteComm',
    'DefWriter_WriteParameter',
    'DefWriter_WriteRmaWin',
    'DefWriter_WriteMetricClassRecorder',
    'DefWriter_WriteSystemTreeNodeProperty',
    'DefWriter_WriteSystemTreeNodeDomain',
    'DefWriter_WriteLocationGroupProperty',
    'DefWriter_WriteLocationProperty',
    'DefWriter_WriteCartDimension',
    'DefWriter_WriteCartTopology',
    'DefWriter_WriteCartCoordinate',
    'DefWriter_WriteSourceCodeLocation',
    'DefWriter_WriteCallingContext',
    'DefWriter_WriteCallingContextProperty',
    'DefWriter_WriteInterruptGenerator',
    'DefWriter_WriteIoFileProperty',
    'DefWriter_WriteIoRegularFile',
    'DefWriter_WriteIoDirectory',
    'DefWriter_WriteIoHandle',
    'DefWriter_WriteIoPreCreatedHandleState',
    'DefWriter_WriteCallpathParameter',
]
