
""" Generated by OTF2 Template Engine """

import ctypes

from .Config import conf, StrParam
from .ErrorCodes import ErrorCode, HandleErrorCode
from .GeneralDefinitions import *
from .Definitions import *
from .Events import *


class AttributeValue(ctypes.Union):
    """
    ctypes does not support unions as (non-pointer) arguments
    _arg_value / _arg_type is a crude and evil hack to guess
    the right argument type. This type must be correct in terms of
    size (maximum of the union) and
    calling convention (architecture specific, but for AMD64 int usually wins).
    Whenever used as a direct function argument (also applies to callbacks)
    this type should be used instead of the union. Otherwise you get undefined
    behavior.
    """
    _arg_type = ctypes.c_uint64
    _fields_ = [
        ("uint8", ctypes.c_uint8),
        ("uint16", ctypes.c_uint16),
        ("uint32", ctypes.c_uint32),
        ("uint64", ctypes.c_uint64),
        ("int8", ctypes.c_int8),
        ("int16", ctypes.c_int16),
        ("int32", ctypes.c_int32),
        ("int64", ctypes.c_int64),
        ("float32", ctypes.c_float),
        ("float64", ctypes.c_double),
        ("stringRef", StringRef),
        ("attributeRef", AttributeRef),
        ("locationRef", LocationRef),
        ("regionRef", RegionRef),
        ("groupRef", GroupRef),
        ("metricRef", MetricRef),
        ("commRef", CommRef),
        ("parameterRef", ParameterRef),
        ("rmaWinRef", RmaWinRef),
        ("sourceCodeLocationRef", SourceCodeLocationRef),
        ("callingContextRef", CallingContextRef),
        ("interruptGeneratorRef", InterruptGeneratorRef),
        ("ioFileRef", IoFileRef),
        ("ioHandleRef", IoHandleRef),
        ("_arg_value", ctypes.c_uint64),
    ]

def AttributeValue_SetBoolean(enumValue, type_=Type(), value=AttributeValue()):
    c_SetBoolean = conf.lib.OTF2_AttributeValue_SetBoolean
    c_SetBoolean.argtypes = [ Boolean, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetBoolean.restype = ErrorCode
    c_SetBoolean.errcheck = HandleErrorCode
    c_SetBoolean(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetFileType(enumValue, type_=Type(), value=AttributeValue()):
    c_SetFileType = conf.lib.OTF2_AttributeValue_SetFileType
    c_SetFileType.argtypes = [ FileType, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetFileType.restype = ErrorCode
    c_SetFileType.errcheck = HandleErrorCode
    c_SetFileType(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetFileSubstrate(enumValue, type_=Type(), value=AttributeValue()):
    c_SetFileSubstrate = conf.lib.OTF2_AttributeValue_SetFileSubstrate
    c_SetFileSubstrate.argtypes = [ FileSubstrate, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetFileSubstrate.restype = ErrorCode
    c_SetFileSubstrate.errcheck = HandleErrorCode
    c_SetFileSubstrate(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetMappingType(enumValue, type_=Type(), value=AttributeValue()):
    c_SetMappingType = conf.lib.OTF2_AttributeValue_SetMappingType
    c_SetMappingType.argtypes = [ MappingType, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetMappingType.restype = ErrorCode
    c_SetMappingType.errcheck = HandleErrorCode
    c_SetMappingType(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetType(enumValue, type_=Type(), value=AttributeValue()):
    c_SetType = conf.lib.OTF2_AttributeValue_SetType
    c_SetType.argtypes = [ Type, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetType.restype = ErrorCode
    c_SetType.errcheck = HandleErrorCode
    c_SetType(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetParadigm(enumValue, type_=Type(), value=AttributeValue()):
    c_SetParadigm = conf.lib.OTF2_AttributeValue_SetParadigm
    c_SetParadigm.argtypes = [ Paradigm, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetParadigm.restype = ErrorCode
    c_SetParadigm.errcheck = HandleErrorCode
    c_SetParadigm(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetParadigmClass(enumValue, type_=Type(), value=AttributeValue()):
    c_SetParadigmClass = conf.lib.OTF2_AttributeValue_SetParadigmClass
    c_SetParadigmClass.argtypes = [ ParadigmClass, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetParadigmClass.restype = ErrorCode
    c_SetParadigmClass.errcheck = HandleErrorCode
    c_SetParadigmClass(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetParadigmProperty(enumValue, type_=Type(), value=AttributeValue()):
    c_SetParadigmProperty = conf.lib.OTF2_AttributeValue_SetParadigmProperty
    c_SetParadigmProperty.argtypes = [ ParadigmProperty, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetParadigmProperty.restype = ErrorCode
    c_SetParadigmProperty.errcheck = HandleErrorCode
    c_SetParadigmProperty(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetThumbnailType(enumValue, type_=Type(), value=AttributeValue()):
    c_SetThumbnailType = conf.lib.OTF2_AttributeValue_SetThumbnailType
    c_SetThumbnailType.argtypes = [ ThumbnailType, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetThumbnailType.restype = ErrorCode
    c_SetThumbnailType.errcheck = HandleErrorCode
    c_SetThumbnailType(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetSystemTreeDomain(enumValue, type_=Type(), value=AttributeValue()):
    c_SetSystemTreeDomain = conf.lib.OTF2_AttributeValue_SetSystemTreeDomain
    c_SetSystemTreeDomain.argtypes = [ SystemTreeDomain, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetSystemTreeDomain.restype = ErrorCode
    c_SetSystemTreeDomain.errcheck = HandleErrorCode
    c_SetSystemTreeDomain(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetLocationGroupType(enumValue, type_=Type(), value=AttributeValue()):
    c_SetLocationGroupType = conf.lib.OTF2_AttributeValue_SetLocationGroupType
    c_SetLocationGroupType.argtypes = [ LocationGroupType, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetLocationGroupType.restype = ErrorCode
    c_SetLocationGroupType.errcheck = HandleErrorCode
    c_SetLocationGroupType(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetLocationType(enumValue, type_=Type(), value=AttributeValue()):
    c_SetLocationType = conf.lib.OTF2_AttributeValue_SetLocationType
    c_SetLocationType.argtypes = [ LocationType, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetLocationType.restype = ErrorCode
    c_SetLocationType.errcheck = HandleErrorCode
    c_SetLocationType(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetRegionRole(enumValue, type_=Type(), value=AttributeValue()):
    c_SetRegionRole = conf.lib.OTF2_AttributeValue_SetRegionRole
    c_SetRegionRole.argtypes = [ RegionRole, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetRegionRole.restype = ErrorCode
    c_SetRegionRole.errcheck = HandleErrorCode
    c_SetRegionRole(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetRegionFlag(enumValue, type_=Type(), value=AttributeValue()):
    c_SetRegionFlag = conf.lib.OTF2_AttributeValue_SetRegionFlag
    c_SetRegionFlag.argtypes = [ RegionFlag, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetRegionFlag.restype = ErrorCode
    c_SetRegionFlag.errcheck = HandleErrorCode
    c_SetRegionFlag(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetGroupType(enumValue, type_=Type(), value=AttributeValue()):
    c_SetGroupType = conf.lib.OTF2_AttributeValue_SetGroupType
    c_SetGroupType.argtypes = [ GroupType, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetGroupType.restype = ErrorCode
    c_SetGroupType.errcheck = HandleErrorCode
    c_SetGroupType(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetGroupFlag(enumValue, type_=Type(), value=AttributeValue()):
    c_SetGroupFlag = conf.lib.OTF2_AttributeValue_SetGroupFlag
    c_SetGroupFlag.argtypes = [ GroupFlag, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetGroupFlag.restype = ErrorCode
    c_SetGroupFlag.errcheck = HandleErrorCode
    c_SetGroupFlag(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetBase(enumValue, type_=Type(), value=AttributeValue()):
    c_SetBase = conf.lib.OTF2_AttributeValue_SetBase
    c_SetBase.argtypes = [ Base, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetBase.restype = ErrorCode
    c_SetBase.errcheck = HandleErrorCode
    c_SetBase(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetMetricOccurrence(enumValue, type_=Type(), value=AttributeValue()):
    c_SetMetricOccurrence = conf.lib.OTF2_AttributeValue_SetMetricOccurrence
    c_SetMetricOccurrence.argtypes = [ MetricOccurrence, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetMetricOccurrence.restype = ErrorCode
    c_SetMetricOccurrence.errcheck = HandleErrorCode
    c_SetMetricOccurrence(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetMetricType(enumValue, type_=Type(), value=AttributeValue()):
    c_SetMetricType = conf.lib.OTF2_AttributeValue_SetMetricType
    c_SetMetricType.argtypes = [ MetricType, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetMetricType.restype = ErrorCode
    c_SetMetricType.errcheck = HandleErrorCode
    c_SetMetricType(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetMetricValueProperty(enumValue, type_=Type(), value=AttributeValue()):
    c_SetMetricValueProperty = conf.lib.OTF2_AttributeValue_SetMetricValueProperty
    c_SetMetricValueProperty.argtypes = [ MetricValueProperty, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetMetricValueProperty.restype = ErrorCode
    c_SetMetricValueProperty.errcheck = HandleErrorCode
    c_SetMetricValueProperty(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetMetricTiming(enumValue, type_=Type(), value=AttributeValue()):
    c_SetMetricTiming = conf.lib.OTF2_AttributeValue_SetMetricTiming
    c_SetMetricTiming.argtypes = [ MetricTiming, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetMetricTiming.restype = ErrorCode
    c_SetMetricTiming.errcheck = HandleErrorCode
    c_SetMetricTiming(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetMetricMode(enumValue, type_=Type(), value=AttributeValue()):
    c_SetMetricMode = conf.lib.OTF2_AttributeValue_SetMetricMode
    c_SetMetricMode.argtypes = [ MetricMode, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetMetricMode.restype = ErrorCode
    c_SetMetricMode.errcheck = HandleErrorCode
    c_SetMetricMode(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetMetricScope(enumValue, type_=Type(), value=AttributeValue()):
    c_SetMetricScope = conf.lib.OTF2_AttributeValue_SetMetricScope
    c_SetMetricScope.argtypes = [ MetricScope, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetMetricScope.restype = ErrorCode
    c_SetMetricScope.errcheck = HandleErrorCode
    c_SetMetricScope(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetRecorderKind(enumValue, type_=Type(), value=AttributeValue()):
    c_SetRecorderKind = conf.lib.OTF2_AttributeValue_SetRecorderKind
    c_SetRecorderKind.argtypes = [ RecorderKind, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetRecorderKind.restype = ErrorCode
    c_SetRecorderKind.errcheck = HandleErrorCode
    c_SetRecorderKind(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetParameterType(enumValue, type_=Type(), value=AttributeValue()):
    c_SetParameterType = conf.lib.OTF2_AttributeValue_SetParameterType
    c_SetParameterType.argtypes = [ ParameterType, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetParameterType.restype = ErrorCode
    c_SetParameterType.errcheck = HandleErrorCode
    c_SetParameterType(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetCartPeriodicity(enumValue, type_=Type(), value=AttributeValue()):
    c_SetCartPeriodicity = conf.lib.OTF2_AttributeValue_SetCartPeriodicity
    c_SetCartPeriodicity.argtypes = [ CartPeriodicity, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetCartPeriodicity.restype = ErrorCode
    c_SetCartPeriodicity.errcheck = HandleErrorCode
    c_SetCartPeriodicity(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetInterruptGeneratorMode(enumValue, type_=Type(), value=AttributeValue()):
    c_SetInterruptGeneratorMode = conf.lib.OTF2_AttributeValue_SetInterruptGeneratorMode
    c_SetInterruptGeneratorMode.argtypes = [ InterruptGeneratorMode, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetInterruptGeneratorMode.restype = ErrorCode
    c_SetInterruptGeneratorMode.errcheck = HandleErrorCode
    c_SetInterruptGeneratorMode(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetMeasurementMode(enumValue, type_=Type(), value=AttributeValue()):
    c_SetMeasurementMode = conf.lib.OTF2_AttributeValue_SetMeasurementMode
    c_SetMeasurementMode.argtypes = [ MeasurementMode, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetMeasurementMode.restype = ErrorCode
    c_SetMeasurementMode.errcheck = HandleErrorCode
    c_SetMeasurementMode(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetCollectiveOp(enumValue, type_=Type(), value=AttributeValue()):
    c_SetCollectiveOp = conf.lib.OTF2_AttributeValue_SetCollectiveOp
    c_SetCollectiveOp.argtypes = [ CollectiveOp, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetCollectiveOp.restype = ErrorCode
    c_SetCollectiveOp.errcheck = HandleErrorCode
    c_SetCollectiveOp(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetRmaSyncType(enumValue, type_=Type(), value=AttributeValue()):
    c_SetRmaSyncType = conf.lib.OTF2_AttributeValue_SetRmaSyncType
    c_SetRmaSyncType.argtypes = [ RmaSyncType, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetRmaSyncType.restype = ErrorCode
    c_SetRmaSyncType.errcheck = HandleErrorCode
    c_SetRmaSyncType(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetRmaSyncLevel(enumValue, type_=Type(), value=AttributeValue()):
    c_SetRmaSyncLevel = conf.lib.OTF2_AttributeValue_SetRmaSyncLevel
    c_SetRmaSyncLevel.argtypes = [ RmaSyncLevel, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetRmaSyncLevel.restype = ErrorCode
    c_SetRmaSyncLevel.errcheck = HandleErrorCode
    c_SetRmaSyncLevel(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetLockType(enumValue, type_=Type(), value=AttributeValue()):
    c_SetLockType = conf.lib.OTF2_AttributeValue_SetLockType
    c_SetLockType.argtypes = [ LockType, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetLockType.restype = ErrorCode
    c_SetLockType.errcheck = HandleErrorCode
    c_SetLockType(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetRmaAtomicType(enumValue, type_=Type(), value=AttributeValue()):
    c_SetRmaAtomicType = conf.lib.OTF2_AttributeValue_SetRmaAtomicType
    c_SetRmaAtomicType.argtypes = [ RmaAtomicType, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetRmaAtomicType.restype = ErrorCode
    c_SetRmaAtomicType.errcheck = HandleErrorCode
    c_SetRmaAtomicType(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetIoParadigmClass(enumValue, type_=Type(), value=AttributeValue()):
    c_SetIoParadigmClass = conf.lib.OTF2_AttributeValue_SetIoParadigmClass
    c_SetIoParadigmClass.argtypes = [ IoParadigmClass, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetIoParadigmClass.restype = ErrorCode
    c_SetIoParadigmClass.errcheck = HandleErrorCode
    c_SetIoParadigmClass(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetIoParadigmFlag(enumValue, type_=Type(), value=AttributeValue()):
    c_SetIoParadigmFlag = conf.lib.OTF2_AttributeValue_SetIoParadigmFlag
    c_SetIoParadigmFlag.argtypes = [ IoParadigmFlag, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetIoParadigmFlag.restype = ErrorCode
    c_SetIoParadigmFlag.errcheck = HandleErrorCode
    c_SetIoParadigmFlag(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetIoParadigmProperty(enumValue, type_=Type(), value=AttributeValue()):
    c_SetIoParadigmProperty = conf.lib.OTF2_AttributeValue_SetIoParadigmProperty
    c_SetIoParadigmProperty.argtypes = [ IoParadigmProperty, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetIoParadigmProperty.restype = ErrorCode
    c_SetIoParadigmProperty.errcheck = HandleErrorCode
    c_SetIoParadigmProperty(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetIoHandleFlag(enumValue, type_=Type(), value=AttributeValue()):
    c_SetIoHandleFlag = conf.lib.OTF2_AttributeValue_SetIoHandleFlag
    c_SetIoHandleFlag.argtypes = [ IoHandleFlag, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetIoHandleFlag.restype = ErrorCode
    c_SetIoHandleFlag.errcheck = HandleErrorCode
    c_SetIoHandleFlag(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetIoAccessMode(enumValue, type_=Type(), value=AttributeValue()):
    c_SetIoAccessMode = conf.lib.OTF2_AttributeValue_SetIoAccessMode
    c_SetIoAccessMode.argtypes = [ IoAccessMode, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetIoAccessMode.restype = ErrorCode
    c_SetIoAccessMode.errcheck = HandleErrorCode
    c_SetIoAccessMode(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetIoCreationFlag(enumValue, type_=Type(), value=AttributeValue()):
    c_SetIoCreationFlag = conf.lib.OTF2_AttributeValue_SetIoCreationFlag
    c_SetIoCreationFlag.argtypes = [ IoCreationFlag, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetIoCreationFlag.restype = ErrorCode
    c_SetIoCreationFlag.errcheck = HandleErrorCode
    c_SetIoCreationFlag(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetIoStatusFlag(enumValue, type_=Type(), value=AttributeValue()):
    c_SetIoStatusFlag = conf.lib.OTF2_AttributeValue_SetIoStatusFlag
    c_SetIoStatusFlag.argtypes = [ IoStatusFlag, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetIoStatusFlag.restype = ErrorCode
    c_SetIoStatusFlag.errcheck = HandleErrorCode
    c_SetIoStatusFlag(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetIoSeekOption(enumValue, type_=Type(), value=AttributeValue()):
    c_SetIoSeekOption = conf.lib.OTF2_AttributeValue_SetIoSeekOption
    c_SetIoSeekOption.argtypes = [ IoSeekOption, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetIoSeekOption.restype = ErrorCode
    c_SetIoSeekOption.errcheck = HandleErrorCode
    c_SetIoSeekOption(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetIoOperationMode(enumValue, type_=Type(), value=AttributeValue()):
    c_SetIoOperationMode = conf.lib.OTF2_AttributeValue_SetIoOperationMode
    c_SetIoOperationMode.argtypes = [ IoOperationMode, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetIoOperationMode.restype = ErrorCode
    c_SetIoOperationMode.errcheck = HandleErrorCode
    c_SetIoOperationMode(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_SetIoOperationFlag(enumValue, type_=Type(), value=AttributeValue()):
    c_SetIoOperationFlag = conf.lib.OTF2_AttributeValue_SetIoOperationFlag
    c_SetIoOperationFlag.argtypes = [ IoOperationFlag, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_SetIoOperationFlag.restype = ErrorCode
    c_SetIoOperationFlag.errcheck = HandleErrorCode
    c_SetIoOperationFlag(enumValue, ctypes.byref(type_), ctypes.byref(value))
    return (type_, value)

def AttributeValue_GetBoolean(type, enum_value=Boolean()):
    c_GetBoolean = conf.lib.OTF2_AttributeValue_GetBoolean
    c_GetBoolean.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(Boolean) ]
    c_GetBoolean.restype = ErrorCode
    c_GetBoolean.errcheck = HandleErrorCode
    c_GetBoolean(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetFileType(type, enum_value=FileType()):
    c_GetFileType = conf.lib.OTF2_AttributeValue_GetFileType
    c_GetFileType.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(FileType) ]
    c_GetFileType.restype = ErrorCode
    c_GetFileType.errcheck = HandleErrorCode
    c_GetFileType(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetFileSubstrate(type, enum_value=FileSubstrate()):
    c_GetFileSubstrate = conf.lib.OTF2_AttributeValue_GetFileSubstrate
    c_GetFileSubstrate.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(FileSubstrate) ]
    c_GetFileSubstrate.restype = ErrorCode
    c_GetFileSubstrate.errcheck = HandleErrorCode
    c_GetFileSubstrate(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetMappingType(type, enum_value=MappingType()):
    c_GetMappingType = conf.lib.OTF2_AttributeValue_GetMappingType
    c_GetMappingType.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(MappingType) ]
    c_GetMappingType.restype = ErrorCode
    c_GetMappingType.errcheck = HandleErrorCode
    c_GetMappingType(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetType(type, enum_value=Type()):
    c_GetType = conf.lib.OTF2_AttributeValue_GetType
    c_GetType.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(Type) ]
    c_GetType.restype = ErrorCode
    c_GetType.errcheck = HandleErrorCode
    c_GetType(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetParadigm(type, enum_value=Paradigm()):
    c_GetParadigm = conf.lib.OTF2_AttributeValue_GetParadigm
    c_GetParadigm.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(Paradigm) ]
    c_GetParadigm.restype = ErrorCode
    c_GetParadigm.errcheck = HandleErrorCode
    c_GetParadigm(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetParadigmClass(type, enum_value=ParadigmClass()):
    c_GetParadigmClass = conf.lib.OTF2_AttributeValue_GetParadigmClass
    c_GetParadigmClass.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(ParadigmClass) ]
    c_GetParadigmClass.restype = ErrorCode
    c_GetParadigmClass.errcheck = HandleErrorCode
    c_GetParadigmClass(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetParadigmProperty(type, enum_value=ParadigmProperty()):
    c_GetParadigmProperty = conf.lib.OTF2_AttributeValue_GetParadigmProperty
    c_GetParadigmProperty.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(ParadigmProperty) ]
    c_GetParadigmProperty.restype = ErrorCode
    c_GetParadigmProperty.errcheck = HandleErrorCode
    c_GetParadigmProperty(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetThumbnailType(type, enum_value=ThumbnailType()):
    c_GetThumbnailType = conf.lib.OTF2_AttributeValue_GetThumbnailType
    c_GetThumbnailType.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(ThumbnailType) ]
    c_GetThumbnailType.restype = ErrorCode
    c_GetThumbnailType.errcheck = HandleErrorCode
    c_GetThumbnailType(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetSystemTreeDomain(type, enum_value=SystemTreeDomain()):
    c_GetSystemTreeDomain = conf.lib.OTF2_AttributeValue_GetSystemTreeDomain
    c_GetSystemTreeDomain.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(SystemTreeDomain) ]
    c_GetSystemTreeDomain.restype = ErrorCode
    c_GetSystemTreeDomain.errcheck = HandleErrorCode
    c_GetSystemTreeDomain(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetLocationGroupType(type, enum_value=LocationGroupType()):
    c_GetLocationGroupType = conf.lib.OTF2_AttributeValue_GetLocationGroupType
    c_GetLocationGroupType.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(LocationGroupType) ]
    c_GetLocationGroupType.restype = ErrorCode
    c_GetLocationGroupType.errcheck = HandleErrorCode
    c_GetLocationGroupType(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetLocationType(type, enum_value=LocationType()):
    c_GetLocationType = conf.lib.OTF2_AttributeValue_GetLocationType
    c_GetLocationType.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(LocationType) ]
    c_GetLocationType.restype = ErrorCode
    c_GetLocationType.errcheck = HandleErrorCode
    c_GetLocationType(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetRegionRole(type, enum_value=RegionRole()):
    c_GetRegionRole = conf.lib.OTF2_AttributeValue_GetRegionRole
    c_GetRegionRole.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(RegionRole) ]
    c_GetRegionRole.restype = ErrorCode
    c_GetRegionRole.errcheck = HandleErrorCode
    c_GetRegionRole(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetRegionFlag(type, enum_value=RegionFlag()):
    c_GetRegionFlag = conf.lib.OTF2_AttributeValue_GetRegionFlag
    c_GetRegionFlag.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(RegionFlag) ]
    c_GetRegionFlag.restype = ErrorCode
    c_GetRegionFlag.errcheck = HandleErrorCode
    c_GetRegionFlag(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetGroupType(type, enum_value=GroupType()):
    c_GetGroupType = conf.lib.OTF2_AttributeValue_GetGroupType
    c_GetGroupType.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(GroupType) ]
    c_GetGroupType.restype = ErrorCode
    c_GetGroupType.errcheck = HandleErrorCode
    c_GetGroupType(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetGroupFlag(type, enum_value=GroupFlag()):
    c_GetGroupFlag = conf.lib.OTF2_AttributeValue_GetGroupFlag
    c_GetGroupFlag.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(GroupFlag) ]
    c_GetGroupFlag.restype = ErrorCode
    c_GetGroupFlag.errcheck = HandleErrorCode
    c_GetGroupFlag(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetBase(type, enum_value=Base()):
    c_GetBase = conf.lib.OTF2_AttributeValue_GetBase
    c_GetBase.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(Base) ]
    c_GetBase.restype = ErrorCode
    c_GetBase.errcheck = HandleErrorCode
    c_GetBase(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetMetricOccurrence(type, enum_value=MetricOccurrence()):
    c_GetMetricOccurrence = conf.lib.OTF2_AttributeValue_GetMetricOccurrence
    c_GetMetricOccurrence.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(MetricOccurrence) ]
    c_GetMetricOccurrence.restype = ErrorCode
    c_GetMetricOccurrence.errcheck = HandleErrorCode
    c_GetMetricOccurrence(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetMetricType(type, enum_value=MetricType()):
    c_GetMetricType = conf.lib.OTF2_AttributeValue_GetMetricType
    c_GetMetricType.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(MetricType) ]
    c_GetMetricType.restype = ErrorCode
    c_GetMetricType.errcheck = HandleErrorCode
    c_GetMetricType(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetMetricValueProperty(type, enum_value=MetricValueProperty()):
    c_GetMetricValueProperty = conf.lib.OTF2_AttributeValue_GetMetricValueProperty
    c_GetMetricValueProperty.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(MetricValueProperty) ]
    c_GetMetricValueProperty.restype = ErrorCode
    c_GetMetricValueProperty.errcheck = HandleErrorCode
    c_GetMetricValueProperty(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetMetricTiming(type, enum_value=MetricTiming()):
    c_GetMetricTiming = conf.lib.OTF2_AttributeValue_GetMetricTiming
    c_GetMetricTiming.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(MetricTiming) ]
    c_GetMetricTiming.restype = ErrorCode
    c_GetMetricTiming.errcheck = HandleErrorCode
    c_GetMetricTiming(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetMetricMode(type, enum_value=MetricMode()):
    c_GetMetricMode = conf.lib.OTF2_AttributeValue_GetMetricMode
    c_GetMetricMode.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(MetricMode) ]
    c_GetMetricMode.restype = ErrorCode
    c_GetMetricMode.errcheck = HandleErrorCode
    c_GetMetricMode(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetMetricScope(type, enum_value=MetricScope()):
    c_GetMetricScope = conf.lib.OTF2_AttributeValue_GetMetricScope
    c_GetMetricScope.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(MetricScope) ]
    c_GetMetricScope.restype = ErrorCode
    c_GetMetricScope.errcheck = HandleErrorCode
    c_GetMetricScope(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetRecorderKind(type, enum_value=RecorderKind()):
    c_GetRecorderKind = conf.lib.OTF2_AttributeValue_GetRecorderKind
    c_GetRecorderKind.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(RecorderKind) ]
    c_GetRecorderKind.restype = ErrorCode
    c_GetRecorderKind.errcheck = HandleErrorCode
    c_GetRecorderKind(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetParameterType(type, enum_value=ParameterType()):
    c_GetParameterType = conf.lib.OTF2_AttributeValue_GetParameterType
    c_GetParameterType.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(ParameterType) ]
    c_GetParameterType.restype = ErrorCode
    c_GetParameterType.errcheck = HandleErrorCode
    c_GetParameterType(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetCartPeriodicity(type, enum_value=CartPeriodicity()):
    c_GetCartPeriodicity = conf.lib.OTF2_AttributeValue_GetCartPeriodicity
    c_GetCartPeriodicity.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(CartPeriodicity) ]
    c_GetCartPeriodicity.restype = ErrorCode
    c_GetCartPeriodicity.errcheck = HandleErrorCode
    c_GetCartPeriodicity(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetInterruptGeneratorMode(type, enum_value=InterruptGeneratorMode()):
    c_GetInterruptGeneratorMode = conf.lib.OTF2_AttributeValue_GetInterruptGeneratorMode
    c_GetInterruptGeneratorMode.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(InterruptGeneratorMode) ]
    c_GetInterruptGeneratorMode.restype = ErrorCode
    c_GetInterruptGeneratorMode.errcheck = HandleErrorCode
    c_GetInterruptGeneratorMode(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetMeasurementMode(type, enum_value=MeasurementMode()):
    c_GetMeasurementMode = conf.lib.OTF2_AttributeValue_GetMeasurementMode
    c_GetMeasurementMode.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(MeasurementMode) ]
    c_GetMeasurementMode.restype = ErrorCode
    c_GetMeasurementMode.errcheck = HandleErrorCode
    c_GetMeasurementMode(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetCollectiveOp(type, enum_value=CollectiveOp()):
    c_GetCollectiveOp = conf.lib.OTF2_AttributeValue_GetCollectiveOp
    c_GetCollectiveOp.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(CollectiveOp) ]
    c_GetCollectiveOp.restype = ErrorCode
    c_GetCollectiveOp.errcheck = HandleErrorCode
    c_GetCollectiveOp(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetRmaSyncType(type, enum_value=RmaSyncType()):
    c_GetRmaSyncType = conf.lib.OTF2_AttributeValue_GetRmaSyncType
    c_GetRmaSyncType.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(RmaSyncType) ]
    c_GetRmaSyncType.restype = ErrorCode
    c_GetRmaSyncType.errcheck = HandleErrorCode
    c_GetRmaSyncType(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetRmaSyncLevel(type, enum_value=RmaSyncLevel()):
    c_GetRmaSyncLevel = conf.lib.OTF2_AttributeValue_GetRmaSyncLevel
    c_GetRmaSyncLevel.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(RmaSyncLevel) ]
    c_GetRmaSyncLevel.restype = ErrorCode
    c_GetRmaSyncLevel.errcheck = HandleErrorCode
    c_GetRmaSyncLevel(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetLockType(type, enum_value=LockType()):
    c_GetLockType = conf.lib.OTF2_AttributeValue_GetLockType
    c_GetLockType.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(LockType) ]
    c_GetLockType.restype = ErrorCode
    c_GetLockType.errcheck = HandleErrorCode
    c_GetLockType(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetRmaAtomicType(type, enum_value=RmaAtomicType()):
    c_GetRmaAtomicType = conf.lib.OTF2_AttributeValue_GetRmaAtomicType
    c_GetRmaAtomicType.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(RmaAtomicType) ]
    c_GetRmaAtomicType.restype = ErrorCode
    c_GetRmaAtomicType.errcheck = HandleErrorCode
    c_GetRmaAtomicType(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetIoParadigmClass(type, enum_value=IoParadigmClass()):
    c_GetIoParadigmClass = conf.lib.OTF2_AttributeValue_GetIoParadigmClass
    c_GetIoParadigmClass.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(IoParadigmClass) ]
    c_GetIoParadigmClass.restype = ErrorCode
    c_GetIoParadigmClass.errcheck = HandleErrorCode
    c_GetIoParadigmClass(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetIoParadigmFlag(type, enum_value=IoParadigmFlag()):
    c_GetIoParadigmFlag = conf.lib.OTF2_AttributeValue_GetIoParadigmFlag
    c_GetIoParadigmFlag.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(IoParadigmFlag) ]
    c_GetIoParadigmFlag.restype = ErrorCode
    c_GetIoParadigmFlag.errcheck = HandleErrorCode
    c_GetIoParadigmFlag(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetIoParadigmProperty(type, enum_value=IoParadigmProperty()):
    c_GetIoParadigmProperty = conf.lib.OTF2_AttributeValue_GetIoParadigmProperty
    c_GetIoParadigmProperty.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(IoParadigmProperty) ]
    c_GetIoParadigmProperty.restype = ErrorCode
    c_GetIoParadigmProperty.errcheck = HandleErrorCode
    c_GetIoParadigmProperty(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetIoHandleFlag(type, enum_value=IoHandleFlag()):
    c_GetIoHandleFlag = conf.lib.OTF2_AttributeValue_GetIoHandleFlag
    c_GetIoHandleFlag.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(IoHandleFlag) ]
    c_GetIoHandleFlag.restype = ErrorCode
    c_GetIoHandleFlag.errcheck = HandleErrorCode
    c_GetIoHandleFlag(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetIoAccessMode(type, enum_value=IoAccessMode()):
    c_GetIoAccessMode = conf.lib.OTF2_AttributeValue_GetIoAccessMode
    c_GetIoAccessMode.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(IoAccessMode) ]
    c_GetIoAccessMode.restype = ErrorCode
    c_GetIoAccessMode.errcheck = HandleErrorCode
    c_GetIoAccessMode(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetIoCreationFlag(type, enum_value=IoCreationFlag()):
    c_GetIoCreationFlag = conf.lib.OTF2_AttributeValue_GetIoCreationFlag
    c_GetIoCreationFlag.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(IoCreationFlag) ]
    c_GetIoCreationFlag.restype = ErrorCode
    c_GetIoCreationFlag.errcheck = HandleErrorCode
    c_GetIoCreationFlag(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetIoStatusFlag(type, enum_value=IoStatusFlag()):
    c_GetIoStatusFlag = conf.lib.OTF2_AttributeValue_GetIoStatusFlag
    c_GetIoStatusFlag.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(IoStatusFlag) ]
    c_GetIoStatusFlag.restype = ErrorCode
    c_GetIoStatusFlag.errcheck = HandleErrorCode
    c_GetIoStatusFlag(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetIoSeekOption(type, enum_value=IoSeekOption()):
    c_GetIoSeekOption = conf.lib.OTF2_AttributeValue_GetIoSeekOption
    c_GetIoSeekOption.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(IoSeekOption) ]
    c_GetIoSeekOption.restype = ErrorCode
    c_GetIoSeekOption.errcheck = HandleErrorCode
    c_GetIoSeekOption(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetIoOperationMode(type, enum_value=IoOperationMode()):
    c_GetIoOperationMode = conf.lib.OTF2_AttributeValue_GetIoOperationMode
    c_GetIoOperationMode.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(IoOperationMode) ]
    c_GetIoOperationMode.restype = ErrorCode
    c_GetIoOperationMode.errcheck = HandleErrorCode
    c_GetIoOperationMode(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

def AttributeValue_GetIoOperationFlag(type, enum_value=IoOperationFlag()):
    c_GetIoOperationFlag = conf.lib.OTF2_AttributeValue_GetIoOperationFlag
    c_GetIoOperationFlag.argtypes = [ Type, AttributeValue._arg_type, ctypes.POINTER(IoOperationFlag) ]
    c_GetIoOperationFlag.restype = ErrorCode
    c_GetIoOperationFlag.errcheck = HandleErrorCode
    c_GetIoOperationFlag(type, value._arg_value, ctypes.byref(enum_value))
    return enum_value

__all__ = [
    'AttributeValue',
    'AttributeValue_SetBoolean',
    'AttributeValue_GetBoolean',
    'AttributeValue_SetFileType',
    'AttributeValue_GetFileType',
    'AttributeValue_SetFileSubstrate',
    'AttributeValue_GetFileSubstrate',
    'AttributeValue_SetMappingType',
    'AttributeValue_GetMappingType',
    'AttributeValue_SetType',
    'AttributeValue_GetType',
    'AttributeValue_SetParadigm',
    'AttributeValue_GetParadigm',
    'AttributeValue_SetParadigmClass',
    'AttributeValue_GetParadigmClass',
    'AttributeValue_SetParadigmProperty',
    'AttributeValue_GetParadigmProperty',
    'AttributeValue_SetThumbnailType',
    'AttributeValue_GetThumbnailType',
    'AttributeValue_SetSystemTreeDomain',
    'AttributeValue_GetSystemTreeDomain',
    'AttributeValue_SetLocationGroupType',
    'AttributeValue_GetLocationGroupType',
    'AttributeValue_SetLocationType',
    'AttributeValue_GetLocationType',
    'AttributeValue_SetRegionRole',
    'AttributeValue_GetRegionRole',
    'AttributeValue_SetRegionFlag',
    'AttributeValue_GetRegionFlag',
    'AttributeValue_SetGroupType',
    'AttributeValue_GetGroupType',
    'AttributeValue_SetGroupFlag',
    'AttributeValue_GetGroupFlag',
    'AttributeValue_SetBase',
    'AttributeValue_GetBase',
    'AttributeValue_SetMetricOccurrence',
    'AttributeValue_GetMetricOccurrence',
    'AttributeValue_SetMetricType',
    'AttributeValue_GetMetricType',
    'AttributeValue_SetMetricValueProperty',
    'AttributeValue_GetMetricValueProperty',
    'AttributeValue_SetMetricTiming',
    'AttributeValue_GetMetricTiming',
    'AttributeValue_SetMetricMode',
    'AttributeValue_GetMetricMode',
    'AttributeValue_SetMetricScope',
    'AttributeValue_GetMetricScope',
    'AttributeValue_SetRecorderKind',
    'AttributeValue_GetRecorderKind',
    'AttributeValue_SetParameterType',
    'AttributeValue_GetParameterType',
    'AttributeValue_SetCartPeriodicity',
    'AttributeValue_GetCartPeriodicity',
    'AttributeValue_SetInterruptGeneratorMode',
    'AttributeValue_GetInterruptGeneratorMode',
    'AttributeValue_SetMeasurementMode',
    'AttributeValue_GetMeasurementMode',
    'AttributeValue_SetCollectiveOp',
    'AttributeValue_GetCollectiveOp',
    'AttributeValue_SetRmaSyncType',
    'AttributeValue_GetRmaSyncType',
    'AttributeValue_SetRmaSyncLevel',
    'AttributeValue_GetRmaSyncLevel',
    'AttributeValue_SetLockType',
    'AttributeValue_GetLockType',
    'AttributeValue_SetRmaAtomicType',
    'AttributeValue_GetRmaAtomicType',
    'AttributeValue_SetIoParadigmClass',
    'AttributeValue_GetIoParadigmClass',
    'AttributeValue_SetIoParadigmFlag',
    'AttributeValue_GetIoParadigmFlag',
    'AttributeValue_SetIoParadigmProperty',
    'AttributeValue_GetIoParadigmProperty',
    'AttributeValue_SetIoHandleFlag',
    'AttributeValue_GetIoHandleFlag',
    'AttributeValue_SetIoAccessMode',
    'AttributeValue_GetIoAccessMode',
    'AttributeValue_SetIoCreationFlag',
    'AttributeValue_GetIoCreationFlag',
    'AttributeValue_SetIoStatusFlag',
    'AttributeValue_GetIoStatusFlag',
    'AttributeValue_SetIoSeekOption',
    'AttributeValue_GetIoSeekOption',
    'AttributeValue_SetIoOperationMode',
    'AttributeValue_GetIoOperationMode',
    'AttributeValue_SetIoOperationFlag',
    'AttributeValue_GetIoOperationFlag',
]
