
''' Generated by OTF2 Template Engine '''

import ctypes

from .Config import conf, StrParam
from .ErrorCodes import ErrorCode, HandleErrorCode
from .GeneralDefinitions import *
from .AttributeValue import AttributeValue


class AttributeList(ctypes.Structure):
    pass

def AttributeList_New():
    c_New = conf.lib.OTF2_AttributeList_New
    c_New.argtypes = []
    c_New.restype = ctypes.POINTER(AttributeList)
    # NOTE: Do not errcheck here. This function returns a value, not an error code
    return c_New()

def AttributeList_Delete(attributeList):
    c_Delete = conf.lib.OTF2_AttributeList_Delete
    c_Delete.argtypes = [ ctypes.POINTER(AttributeList) ]
    c_Delete.restype = ErrorCode
    c_Delete.errcheck = HandleErrorCode
    c_Delete(attributeList)

def AttributeList_AddAttribute(attributeList, attribute, type, attributeValue):
    c_AddAttribute = conf.lib.OTF2_AttributeList_AddAttribute
    c_AddAttribute.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, Type, AttributeValue._arg_type ]
    c_AddAttribute.restype = ErrorCode
    c_AddAttribute.errcheck = HandleErrorCode
    c_AddAttribute(attributeList, attribute, type, attributeValue._arg_value)

def AttributeList_AddUint8(attributeList, attribute, uint8Value):
    c_AddUint8 = conf.lib.OTF2_AttributeList_AddUint8
    c_AddUint8.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.c_uint8 ]
    c_AddUint8.restype = ErrorCode
    c_AddUint8.errcheck = HandleErrorCode
    c_AddUint8(attributeList, attribute, uint8Value)

def AttributeList_AddUint16(attributeList, attribute, uint16Value):
    c_AddUint16 = conf.lib.OTF2_AttributeList_AddUint16
    c_AddUint16.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.c_uint16 ]
    c_AddUint16.restype = ErrorCode
    c_AddUint16.errcheck = HandleErrorCode
    c_AddUint16(attributeList, attribute, uint16Value)

def AttributeList_AddUint32(attributeList, attribute, uint32Value):
    c_AddUint32 = conf.lib.OTF2_AttributeList_AddUint32
    c_AddUint32.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.c_uint32 ]
    c_AddUint32.restype = ErrorCode
    c_AddUint32.errcheck = HandleErrorCode
    c_AddUint32(attributeList, attribute, uint32Value)

def AttributeList_AddUint64(attributeList, attribute, uint64Value):
    c_AddUint64 = conf.lib.OTF2_AttributeList_AddUint64
    c_AddUint64.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.c_uint64 ]
    c_AddUint64.restype = ErrorCode
    c_AddUint64.errcheck = HandleErrorCode
    c_AddUint64(attributeList, attribute, uint64Value)

def AttributeList_AddInt8(attributeList, attribute, int8Value):
    c_AddInt8 = conf.lib.OTF2_AttributeList_AddInt8
    c_AddInt8.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.c_int8 ]
    c_AddInt8.restype = ErrorCode
    c_AddInt8.errcheck = HandleErrorCode
    c_AddInt8(attributeList, attribute, int8Value)

def AttributeList_AddInt16(attributeList, attribute, int16Value):
    c_AddInt16 = conf.lib.OTF2_AttributeList_AddInt16
    c_AddInt16.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.c_int16 ]
    c_AddInt16.restype = ErrorCode
    c_AddInt16.errcheck = HandleErrorCode
    c_AddInt16(attributeList, attribute, int16Value)

def AttributeList_AddInt32(attributeList, attribute, int32Value):
    c_AddInt32 = conf.lib.OTF2_AttributeList_AddInt32
    c_AddInt32.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.c_int32 ]
    c_AddInt32.restype = ErrorCode
    c_AddInt32.errcheck = HandleErrorCode
    c_AddInt32(attributeList, attribute, int32Value)

def AttributeList_AddInt64(attributeList, attribute, int64Value):
    c_AddInt64 = conf.lib.OTF2_AttributeList_AddInt64
    c_AddInt64.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.c_int64 ]
    c_AddInt64.restype = ErrorCode
    c_AddInt64.errcheck = HandleErrorCode
    c_AddInt64(attributeList, attribute, int64Value)

def AttributeList_AddFloat(attributeList, attribute, float32Value):
    c_AddFloat = conf.lib.OTF2_AttributeList_AddFloat
    c_AddFloat.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.c_float ]
    c_AddFloat.restype = ErrorCode
    c_AddFloat.errcheck = HandleErrorCode
    c_AddFloat(attributeList, attribute, float32Value)

def AttributeList_AddDouble(attributeList, attribute, float64Value):
    c_AddDouble = conf.lib.OTF2_AttributeList_AddDouble
    c_AddDouble.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.c_double ]
    c_AddDouble.restype = ErrorCode
    c_AddDouble.errcheck = HandleErrorCode
    c_AddDouble(attributeList, attribute, float64Value)

def AttributeList_AddString(attributeList, attribute, stringRef):
    c_AddString = conf.lib.OTF2_AttributeList_AddString
    c_AddString.argtypes = [ctypes.POINTER(AttributeList), AttributeRef, StringRef]
    c_AddString.restype = ErrorCode
    c_AddString.errcheck = HandleErrorCode
    c_AddString(attributeList, attribute, stringRef)

def AttributeList_AddStringRef(attributeList, attribute, stringRef):
    c_AddStringRef = conf.lib.OTF2_AttributeList_AddStringRef
    c_AddStringRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, StringRef ]
    c_AddStringRef.restype = ErrorCode
    c_AddStringRef.errcheck = HandleErrorCode
    c_AddStringRef(attributeList, attribute, stringRef)

def AttributeList_AddAttributeRef(attributeList, attribute, attributeRef):
    c_AddAttributeRef = conf.lib.OTF2_AttributeList_AddAttributeRef
    c_AddAttributeRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, AttributeRef ]
    c_AddAttributeRef.restype = ErrorCode
    c_AddAttributeRef.errcheck = HandleErrorCode
    c_AddAttributeRef(attributeList, attribute, attributeRef)

def AttributeList_AddLocationRef(attributeList, attribute, locationRef):
    c_AddLocationRef = conf.lib.OTF2_AttributeList_AddLocationRef
    c_AddLocationRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, LocationRef ]
    c_AddLocationRef.restype = ErrorCode
    c_AddLocationRef.errcheck = HandleErrorCode
    c_AddLocationRef(attributeList, attribute, locationRef)

def AttributeList_AddRegionRef(attributeList, attribute, regionRef):
    c_AddRegionRef = conf.lib.OTF2_AttributeList_AddRegionRef
    c_AddRegionRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, RegionRef ]
    c_AddRegionRef.restype = ErrorCode
    c_AddRegionRef.errcheck = HandleErrorCode
    c_AddRegionRef(attributeList, attribute, regionRef)

def AttributeList_AddGroupRef(attributeList, attribute, groupRef):
    c_AddGroupRef = conf.lib.OTF2_AttributeList_AddGroupRef
    c_AddGroupRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, GroupRef ]
    c_AddGroupRef.restype = ErrorCode
    c_AddGroupRef.errcheck = HandleErrorCode
    c_AddGroupRef(attributeList, attribute, groupRef)

def AttributeList_AddMetricRef(attributeList, attribute, metricRef):
    c_AddMetricRef = conf.lib.OTF2_AttributeList_AddMetricRef
    c_AddMetricRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, MetricRef ]
    c_AddMetricRef.restype = ErrorCode
    c_AddMetricRef.errcheck = HandleErrorCode
    c_AddMetricRef(attributeList, attribute, metricRef)

def AttributeList_AddCommRef(attributeList, attribute, commRef):
    c_AddCommRef = conf.lib.OTF2_AttributeList_AddCommRef
    c_AddCommRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, CommRef ]
    c_AddCommRef.restype = ErrorCode
    c_AddCommRef.errcheck = HandleErrorCode
    c_AddCommRef(attributeList, attribute, commRef)

def AttributeList_AddParameterRef(attributeList, attribute, parameterRef):
    c_AddParameterRef = conf.lib.OTF2_AttributeList_AddParameterRef
    c_AddParameterRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ParameterRef ]
    c_AddParameterRef.restype = ErrorCode
    c_AddParameterRef.errcheck = HandleErrorCode
    c_AddParameterRef(attributeList, attribute, parameterRef)

def AttributeList_AddRmaWinRef(attributeList, attribute, rmaWinRef):
    c_AddRmaWinRef = conf.lib.OTF2_AttributeList_AddRmaWinRef
    c_AddRmaWinRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, RmaWinRef ]
    c_AddRmaWinRef.restype = ErrorCode
    c_AddRmaWinRef.errcheck = HandleErrorCode
    c_AddRmaWinRef(attributeList, attribute, rmaWinRef)

def AttributeList_AddSourceCodeLocationRef(attributeList, attribute, sourceCodeLocationRef):
    c_AddSourceCodeLocationRef = conf.lib.OTF2_AttributeList_AddSourceCodeLocationRef
    c_AddSourceCodeLocationRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, SourceCodeLocationRef ]
    c_AddSourceCodeLocationRef.restype = ErrorCode
    c_AddSourceCodeLocationRef.errcheck = HandleErrorCode
    c_AddSourceCodeLocationRef(attributeList, attribute, sourceCodeLocationRef)

def AttributeList_AddCallingContextRef(attributeList, attribute, callingContextRef):
    c_AddCallingContextRef = conf.lib.OTF2_AttributeList_AddCallingContextRef
    c_AddCallingContextRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, CallingContextRef ]
    c_AddCallingContextRef.restype = ErrorCode
    c_AddCallingContextRef.errcheck = HandleErrorCode
    c_AddCallingContextRef(attributeList, attribute, callingContextRef)

def AttributeList_AddInterruptGeneratorRef(attributeList, attribute, interruptGeneratorRef):
    c_AddInterruptGeneratorRef = conf.lib.OTF2_AttributeList_AddInterruptGeneratorRef
    c_AddInterruptGeneratorRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, InterruptGeneratorRef ]
    c_AddInterruptGeneratorRef.restype = ErrorCode
    c_AddInterruptGeneratorRef.errcheck = HandleErrorCode
    c_AddInterruptGeneratorRef(attributeList, attribute, interruptGeneratorRef)

def AttributeList_AddIoFileRef(attributeList, attribute, ioFileRef):
    c_AddIoFileRef = conf.lib.OTF2_AttributeList_AddIoFileRef
    c_AddIoFileRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, IoFileRef ]
    c_AddIoFileRef.restype = ErrorCode
    c_AddIoFileRef.errcheck = HandleErrorCode
    c_AddIoFileRef(attributeList, attribute, ioFileRef)

def AttributeList_AddIoHandleRef(attributeList, attribute, ioHandleRef):
    c_AddIoHandleRef = conf.lib.OTF2_AttributeList_AddIoHandleRef
    c_AddIoHandleRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, IoHandleRef ]
    c_AddIoHandleRef.restype = ErrorCode
    c_AddIoHandleRef.errcheck = HandleErrorCode
    c_AddIoHandleRef(attributeList, attribute, ioHandleRef)

def AttributeList_RemoveAttribute(attributeList, attribute):
    c_RemoveAttribute = conf.lib.OTF2_AttributeList_RemoveAttribute
    c_RemoveAttribute.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef ]
    c_RemoveAttribute.restype = ErrorCode
    c_RemoveAttribute.errcheck = HandleErrorCode
    c_RemoveAttribute(attributeList, attribute)

def AttributeList_RemoveAllAttributes(attributeList):
    c_RemoveAllAttributes = conf.lib.OTF2_AttributeList_RemoveAllAttributes
    c_RemoveAllAttributes.argtypes = [ ctypes.POINTER(AttributeList) ]
    c_RemoveAllAttributes.restype = ErrorCode
    c_RemoveAllAttributes.errcheck = HandleErrorCode
    c_RemoveAllAttributes(attributeList)

def AttributeList_TestAttributeByID(attributeList, attribute):
    c_TestAttributeByID = conf.lib.OTF2_AttributeList_TestAttributeByID
    c_TestAttributeByID.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef ]
    c_TestAttributeByID.restype = ctypes.c_bool
    return c_TestAttributeByID(attributeList, attribute)

def AttributeList_GetAttributeByID(attributeList, attribute, attributeType = Type(), attributeValue = AttributeValue()):
    c_GetAttributeByID = conf.lib.OTF2_AttributeList_GetAttributeByID
    c_GetAttributeByID.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_GetAttributeByID.restype = ErrorCode
    c_GetAttributeByID.errcheck = HandleErrorCode
    c_GetAttributeByID(attributeList, attribute, ctypes.byref(attributeType), ctypes.byref(attributeValue))
    return (attributeType, attributeValue)

def AttributeList_GetUint8(attributeList, attribute):
    c_GetUint8 = conf.lib.OTF2_AttributeList_GetUint8
    c_GetUint8.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(ctypes.c_uint8) ]
    c_GetUint8.restype = ErrorCode
    c_GetUint8.errcheck = HandleErrorCode
    uint8Value = ctypes.c_uint8()
    c_GetUint8(attributeList, attribute, ctypes.byref(uint8Value))
    return uint8Value.value

def AttributeList_GetUint16(attributeList, attribute):
    c_GetUint16 = conf.lib.OTF2_AttributeList_GetUint16
    c_GetUint16.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(ctypes.c_uint16) ]
    c_GetUint16.restype = ErrorCode
    c_GetUint16.errcheck = HandleErrorCode
    uint16Value = ctypes.c_uint16()
    c_GetUint16(attributeList, attribute, ctypes.byref(uint16Value))
    return uint16Value.value

def AttributeList_GetUint32(attributeList, attribute):
    c_GetUint32 = conf.lib.OTF2_AttributeList_GetUint32
    c_GetUint32.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(ctypes.c_uint32) ]
    c_GetUint32.restype = ErrorCode
    c_GetUint32.errcheck = HandleErrorCode
    uint32Value = ctypes.c_uint32()
    c_GetUint32(attributeList, attribute, ctypes.byref(uint32Value))
    return uint32Value.value

def AttributeList_GetUint64(attributeList, attribute):
    c_GetUint64 = conf.lib.OTF2_AttributeList_GetUint64
    c_GetUint64.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(ctypes.c_uint64) ]
    c_GetUint64.restype = ErrorCode
    c_GetUint64.errcheck = HandleErrorCode
    uint64Value = ctypes.c_uint64()
    c_GetUint64(attributeList, attribute, ctypes.byref(uint64Value))
    return uint64Value.value

def AttributeList_GetInt8(attributeList, attribute):
    c_GetInt8 = conf.lib.OTF2_AttributeList_GetInt8
    c_GetInt8.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(ctypes.c_int8) ]
    c_GetInt8.restype = ErrorCode
    c_GetInt8.errcheck = HandleErrorCode
    int8Value = ctypes.c_int8()
    c_GetInt8(attributeList, attribute, ctypes.byref(int8Value))
    return int8Value.value

def AttributeList_GetInt16(attributeList, attribute):
    c_GetInt16 = conf.lib.OTF2_AttributeList_GetInt16
    c_GetInt16.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(ctypes.c_int16) ]
    c_GetInt16.restype = ErrorCode
    c_GetInt16.errcheck = HandleErrorCode
    int16Value = ctypes.c_int16()
    c_GetInt16(attributeList, attribute, ctypes.byref(int16Value))
    return int16Value.value

def AttributeList_GetInt32(attributeList, attribute):
    c_GetInt32 = conf.lib.OTF2_AttributeList_GetInt32
    c_GetInt32.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(ctypes.c_int32) ]
    c_GetInt32.restype = ErrorCode
    c_GetInt32.errcheck = HandleErrorCode
    int32Value = ctypes.c_int32()
    c_GetInt32(attributeList, attribute, ctypes.byref(int32Value))
    return int32Value.value

def AttributeList_GetInt64(attributeList, attribute):
    c_GetInt64 = conf.lib.OTF2_AttributeList_GetInt64
    c_GetInt64.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(ctypes.c_int64) ]
    c_GetInt64.restype = ErrorCode
    c_GetInt64.errcheck = HandleErrorCode
    int64Value = ctypes.c_int64()
    c_GetInt64(attributeList, attribute, ctypes.byref(int64Value))
    return int64Value.value

def AttributeList_GetFloat(attributeList, attribute):
    c_GetFloat = conf.lib.OTF2_AttributeList_GetFloat
    c_GetFloat.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(ctypes.c_float) ]
    c_GetFloat.restype = ErrorCode
    c_GetFloat.errcheck = HandleErrorCode
    float32Value = ctypes.c_float()
    c_GetFloat(attributeList, attribute, ctypes.byref(float32Value))
    return float32Value.value

def AttributeList_GetDouble(attributeList, attribute):
    c_GetDouble = conf.lib.OTF2_AttributeList_GetDouble
    c_GetDouble.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(ctypes.c_double) ]
    c_GetDouble.restype = ErrorCode
    c_GetDouble.errcheck = HandleErrorCode
    float64Value = ctypes.c_double()
    c_GetDouble(attributeList, attribute, ctypes.byref(float64Value))
    return float64Value.value

def AttributeList_GetString(attributeList, attribute):
    c_GetString = conf.lib.OTF2_AttributeList_GetString
    c_GetString.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(StringRef) ]
    c_GetString.restype = ErrorCode
    c_GetString.errcheck = HandleErrorCode
    stringRef = StringRef()
    c_GetString(attributeList, attribute, ctypes.byref(stringRef))
    return stringRef.value

def AttributeList_GetStringRef(attributeList, attribute):
    c_GetStringRef = conf.lib.OTF2_AttributeList_GetStringRef
    c_GetStringRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(StringRef) ]
    c_GetStringRef.restype = ErrorCode
    c_GetStringRef.errcheck = HandleErrorCode
    stringRef = StringRef()
    c_GetStringRef(attributeList, attribute, ctypes.byref(stringRef))
    return stringRef.value

def AttributeList_GetAttributeRef(attributeList, attribute):
    c_GetAttributeRef = conf.lib.OTF2_AttributeList_GetAttributeRef
    c_GetAttributeRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(AttributeRef) ]
    c_GetAttributeRef.restype = ErrorCode
    c_GetAttributeRef.errcheck = HandleErrorCode
    attributeRef = AttributeRef()
    c_GetAttributeRef(attributeList, attribute, ctypes.byref(attributeRef))
    return attributeRef.value

def AttributeList_GetLocationRef(attributeList, attribute):
    c_GetLocationRef = conf.lib.OTF2_AttributeList_GetLocationRef
    c_GetLocationRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(LocationRef) ]
    c_GetLocationRef.restype = ErrorCode
    c_GetLocationRef.errcheck = HandleErrorCode
    locationRef = LocationRef()
    c_GetLocationRef(attributeList, attribute, ctypes.byref(locationRef))
    return locationRef.value

def AttributeList_GetRegionRef(attributeList, attribute):
    c_GetRegionRef = conf.lib.OTF2_AttributeList_GetRegionRef
    c_GetRegionRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(RegionRef) ]
    c_GetRegionRef.restype = ErrorCode
    c_GetRegionRef.errcheck = HandleErrorCode
    regionRef = RegionRef()
    c_GetRegionRef(attributeList, attribute, ctypes.byref(regionRef))
    return regionRef.value

def AttributeList_GetGroupRef(attributeList, attribute):
    c_GetGroupRef = conf.lib.OTF2_AttributeList_GetGroupRef
    c_GetGroupRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(GroupRef) ]
    c_GetGroupRef.restype = ErrorCode
    c_GetGroupRef.errcheck = HandleErrorCode
    groupRef = GroupRef()
    c_GetGroupRef(attributeList, attribute, ctypes.byref(groupRef))
    return groupRef.value

def AttributeList_GetMetricRef(attributeList, attribute):
    c_GetMetricRef = conf.lib.OTF2_AttributeList_GetMetricRef
    c_GetMetricRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(MetricRef) ]
    c_GetMetricRef.restype = ErrorCode
    c_GetMetricRef.errcheck = HandleErrorCode
    metricRef = MetricRef()
    c_GetMetricRef(attributeList, attribute, ctypes.byref(metricRef))
    return metricRef.value

def AttributeList_GetCommRef(attributeList, attribute):
    c_GetCommRef = conf.lib.OTF2_AttributeList_GetCommRef
    c_GetCommRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(CommRef) ]
    c_GetCommRef.restype = ErrorCode
    c_GetCommRef.errcheck = HandleErrorCode
    commRef = CommRef()
    c_GetCommRef(attributeList, attribute, ctypes.byref(commRef))
    return commRef.value

def AttributeList_GetParameterRef(attributeList, attribute):
    c_GetParameterRef = conf.lib.OTF2_AttributeList_GetParameterRef
    c_GetParameterRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(ParameterRef) ]
    c_GetParameterRef.restype = ErrorCode
    c_GetParameterRef.errcheck = HandleErrorCode
    parameterRef = ParameterRef()
    c_GetParameterRef(attributeList, attribute, ctypes.byref(parameterRef))
    return parameterRef.value

def AttributeList_GetRmaWinRef(attributeList, attribute):
    c_GetRmaWinRef = conf.lib.OTF2_AttributeList_GetRmaWinRef
    c_GetRmaWinRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(RmaWinRef) ]
    c_GetRmaWinRef.restype = ErrorCode
    c_GetRmaWinRef.errcheck = HandleErrorCode
    rmaWinRef = RmaWinRef()
    c_GetRmaWinRef(attributeList, attribute, ctypes.byref(rmaWinRef))
    return rmaWinRef.value

def AttributeList_GetSourceCodeLocationRef(attributeList, attribute):
    c_GetSourceCodeLocationRef = conf.lib.OTF2_AttributeList_GetSourceCodeLocationRef
    c_GetSourceCodeLocationRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(SourceCodeLocationRef) ]
    c_GetSourceCodeLocationRef.restype = ErrorCode
    c_GetSourceCodeLocationRef.errcheck = HandleErrorCode
    sourceCodeLocationRef = SourceCodeLocationRef()
    c_GetSourceCodeLocationRef(attributeList, attribute, ctypes.byref(sourceCodeLocationRef))
    return sourceCodeLocationRef.value

def AttributeList_GetCallingContextRef(attributeList, attribute):
    c_GetCallingContextRef = conf.lib.OTF2_AttributeList_GetCallingContextRef
    c_GetCallingContextRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(CallingContextRef) ]
    c_GetCallingContextRef.restype = ErrorCode
    c_GetCallingContextRef.errcheck = HandleErrorCode
    callingContextRef = CallingContextRef()
    c_GetCallingContextRef(attributeList, attribute, ctypes.byref(callingContextRef))
    return callingContextRef.value

def AttributeList_GetInterruptGeneratorRef(attributeList, attribute):
    c_GetInterruptGeneratorRef = conf.lib.OTF2_AttributeList_GetInterruptGeneratorRef
    c_GetInterruptGeneratorRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(InterruptGeneratorRef) ]
    c_GetInterruptGeneratorRef.restype = ErrorCode
    c_GetInterruptGeneratorRef.errcheck = HandleErrorCode
    interruptGeneratorRef = InterruptGeneratorRef()
    c_GetInterruptGeneratorRef(attributeList, attribute, ctypes.byref(interruptGeneratorRef))
    return interruptGeneratorRef.value

def AttributeList_GetIoFileRef(attributeList, attribute):
    c_GetIoFileRef = conf.lib.OTF2_AttributeList_GetIoFileRef
    c_GetIoFileRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(IoFileRef) ]
    c_GetIoFileRef.restype = ErrorCode
    c_GetIoFileRef.errcheck = HandleErrorCode
    ioFileRef = IoFileRef()
    c_GetIoFileRef(attributeList, attribute, ctypes.byref(ioFileRef))
    return ioFileRef.value

def AttributeList_GetIoHandleRef(attributeList, attribute):
    c_GetIoHandleRef = conf.lib.OTF2_AttributeList_GetIoHandleRef
    c_GetIoHandleRef.argtypes = [ ctypes.POINTER(AttributeList), AttributeRef, ctypes.POINTER(IoHandleRef) ]
    c_GetIoHandleRef.restype = ErrorCode
    c_GetIoHandleRef.errcheck = HandleErrorCode
    ioHandleRef = IoHandleRef()
    c_GetIoHandleRef(attributeList, attribute, ctypes.byref(ioHandleRef))
    return ioHandleRef.value

def AttributeList_GetAttributeByIndex(attributeList, index, attribute = AttributeRef(),
                                      attributeType = Type(),attributeValue = AttributeValue()):
    c_GetAttributeByIndex = conf.lib.OTF2_AttributeList_GetAttributeByIndex
    c_GetAttributeByIndex.argtypes = [ ctypes.POINTER(AttributeList), ctypes.c_uint32, ctypes.POINTER(AttributeRef), ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_GetAttributeByIndex.restype = ErrorCode
    c_GetAttributeByIndex.errcheck = HandleErrorCode
    c_GetAttributeByIndex(attributeList, index, ctypes.byref(attribute), ctypes.byref(attributeType), ctypes.byref(attributeValue))
    return (attribute.value, attributeType, attributeValue)

def AttributeList_PopAttribute(attributeList, attribute = AttributeRef(),
                               attributeType = Type(), attributeValue = AttributeValue()):
    c_PopAttribute = conf.lib.OTF2_AttributeList_PopAttribute
    c_PopAttribute.argtypes = [ ctypes.POINTER(AttributeList), ctypes.POINTER(AttributeRef), ctypes.POINTER(Type), ctypes.POINTER(AttributeValue) ]
    c_PopAttribute.restype = ErrorCode
    c_PopAttribute.errcheck = HandleErrorCode
    c_PopAttribute(attributeList, ctypes.byref(attribute), ctypes.byref(attributeType), ctypes.byref(attributeValue))
    return (attribute.value, attributeType, attributeValue)

def AttributeList_GetNumberOfElements(attributeList):
    c_GetNumberOfElements = conf.lib.OTF2_AttributeList_GetNumberOfElements
    c_GetNumberOfElements.argtype = [ ctypes.POINTER(AttributeList) ]
    c_GetNumberOfElements.restype = ctypes.c_uint32
    return c_GetNumberOfElements(attributeList)

__all__ = [
    'AttributeList',
    'AttributeList_New',
    'AttributeList_Delete',
    'AttributeList_AddAttribute',
    'AttributeList_AddString',
    'AttributeList_AddUint8',
    'AttributeList_GetUint8',
    'AttributeList_AddUint16',
    'AttributeList_GetUint16',
    'AttributeList_AddUint32',
    'AttributeList_GetUint32',
    'AttributeList_AddUint64',
    'AttributeList_GetUint64',
    'AttributeList_AddInt8',
    'AttributeList_GetInt8',
    'AttributeList_AddInt16',
    'AttributeList_GetInt16',
    'AttributeList_AddInt32',
    'AttributeList_GetInt32',
    'AttributeList_AddInt64',
    'AttributeList_GetInt64',
    'AttributeList_AddFloat',
    'AttributeList_GetFloat',
    'AttributeList_AddDouble',
    'AttributeList_GetDouble',
    'AttributeList_RemoveAttribute',
    'AttributeList_RemoveAllAttributes',
    'AttributeList_TestAttributeByID',
    'AttributeList_GetAttributeByID',
    'AttributeList_AddStringRef',
    'AttributeList_GetStringRef',
    'AttributeList_AddAttributeRef',
    'AttributeList_GetAttributeRef',
    'AttributeList_AddLocationRef',
    'AttributeList_GetLocationRef',
    'AttributeList_AddRegionRef',
    'AttributeList_GetRegionRef',
    'AttributeList_AddGroupRef',
    'AttributeList_GetGroupRef',
    'AttributeList_AddMetricRef',
    'AttributeList_GetMetricRef',
    'AttributeList_AddCommRef',
    'AttributeList_GetCommRef',
    'AttributeList_AddParameterRef',
    'AttributeList_GetParameterRef',
    'AttributeList_AddRmaWinRef',
    'AttributeList_GetRmaWinRef',
    'AttributeList_AddSourceCodeLocationRef',
    'AttributeList_GetSourceCodeLocationRef',
    'AttributeList_AddCallingContextRef',
    'AttributeList_GetCallingContextRef',
    'AttributeList_AddInterruptGeneratorRef',
    'AttributeList_GetInterruptGeneratorRef',
    'AttributeList_AddIoFileRef',
    'AttributeList_GetIoFileRef',
    'AttributeList_AddIoHandleRef',
    'AttributeList_GetIoHandleRef',
    'AttributeList_GetString',
    'AttributeList_GetAttributeByIndex',
    'AttributeList_PopAttribute',
    'AttributeList_GetNumberOfElements'
]
