<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile>
  <compound kind="group">
    <name>usage</name>
    <title>OTF2 usage examples</title>
    <filename>group__usage.html</filename>
  </compound>
  <compound kind="group">
    <name>records</name>
    <title>OTF2 records</title>
    <filename>group__records.html</filename>
    <subgroup>records_definition</subgroup>
    <subgroup>records_event</subgroup>
    <subgroup>records_marker</subgroup>
    <subgroup>records_snap</subgroup>
  </compound>
  <compound kind="group">
    <name>callbacks</name>
    <title>OTF2 callbacks</title>
    <filename>group__callbacks.html</filename>
  </compound>
  <compound kind="group">
    <name>usage_tools</name>
    <title>Usage of OTF2 tools</title>
    <filename>group__usage__tools.html</filename>
    <subgroup>otf2_config_tool</subgroup>
    <subgroup>otf2_print_tool</subgroup>
    <subgroup>otf2_snapshots_tool</subgroup>
    <subgroup>otf2_marker_tool</subgroup>
    <subgroup>otf2_estimator_tool</subgroup>
  </compound>
  <compound kind="group">
    <name>otf2_config_tool</name>
    <title>OTF2 config tool</title>
    <filename>group__otf2__config__tool.html</filename>
  </compound>
  <compound kind="group">
    <name>otf2_print_tool</name>
    <title>OTF2 print tool</title>
    <filename>group__otf2__print__tool.html</filename>
  </compound>
  <compound kind="group">
    <name>otf2_snapshots_tool</name>
    <title>OTF2 snapshots tool</title>
    <filename>group__otf2__snapshots__tool.html</filename>
  </compound>
  <compound kind="group">
    <name>otf2_marker_tool</name>
    <title>OTF2 marker tool</title>
    <filename>group__otf2__marker__tool.html</filename>
  </compound>
  <compound kind="group">
    <name>otf2_estimator_tool</name>
    <title>OTF2 estimator tool</title>
    <filename>group__otf2__estimator__tool.html</filename>
  </compound>
  <compound kind="group">
    <name>io</name>
    <title>OTF2 I/O recording</title>
    <filename>group__io.html</filename>
    <page>group__io</page>
    <page>group__io</page>
  </compound>
  <compound kind="group">
    <name>records_definition</name>
    <title>List of all definition records</title>
    <filename>group__records__definition.html</filename>
    <docanchor file="group__records__definition">ClockProperties</docanchor>
    <docanchor file="group__records__definition">ClockProperties_timerResolution</docanchor>
    <docanchor file="group__records__definition">ClockProperties_globalOffset</docanchor>
    <docanchor file="group__records__definition">ClockProperties_traceLength</docanchor>
    <docanchor file="group__records__definition">Paradigm</docanchor>
    <docanchor file="group__records__definition">Paradigm_paradigm</docanchor>
    <docanchor file="group__records__definition">Paradigm_name</docanchor>
    <docanchor file="group__records__definition">Paradigm_paradigmClass</docanchor>
    <docanchor file="group__records__definition">ParadigmProperty</docanchor>
    <docanchor file="group__records__definition">ParadigmProperty_paradigm</docanchor>
    <docanchor file="group__records__definition">ParadigmProperty_property</docanchor>
    <docanchor file="group__records__definition">ParadigmProperty_type</docanchor>
    <docanchor file="group__records__definition">ParadigmProperty_value</docanchor>
    <docanchor file="group__records__definition">IoParadigm</docanchor>
    <docanchor file="group__records__definition">IoParadigm_identification</docanchor>
    <docanchor file="group__records__definition">IoParadigm_name</docanchor>
    <docanchor file="group__records__definition">IoParadigm_ioParadigmClass</docanchor>
    <docanchor file="group__records__definition">IoParadigm_ioParadigmFlags</docanchor>
    <docanchor file="group__records__definition">IoParadigm_numberOfProperties</docanchor>
    <docanchor file="group__records__definition">IoParadigm_properties</docanchor>
    <docanchor file="group__records__definition">IoParadigm_types</docanchor>
    <docanchor file="group__records__definition">IoParadigm_values</docanchor>
    <docanchor file="group__records__definition">MappingTable</docanchor>
    <docanchor file="group__records__definition">MappingTable_mappingType</docanchor>
    <docanchor file="group__records__definition">MappingTable_idMap</docanchor>
    <docanchor file="group__records__definition">ClockOffset</docanchor>
    <docanchor file="group__records__definition">ClockOffset_time</docanchor>
    <docanchor file="group__records__definition">ClockOffset_offset</docanchor>
    <docanchor file="group__records__definition">ClockOffset_standardDeviation</docanchor>
    <docanchor file="group__records__definition">String</docanchor>
    <docanchor file="group__records__definition">String_string</docanchor>
    <docanchor file="group__records__definition">Attribute</docanchor>
    <docanchor file="group__records__definition">Attribute_name</docanchor>
    <docanchor file="group__records__definition">Attribute_description</docanchor>
    <docanchor file="group__records__definition">Attribute_type</docanchor>
    <docanchor file="group__records__definition">SystemTreeNode</docanchor>
    <docanchor file="group__records__definition">SystemTreeNode_name</docanchor>
    <docanchor file="group__records__definition">SystemTreeNode_className</docanchor>
    <docanchor file="group__records__definition">SystemTreeNode_parent</docanchor>
    <docanchor file="group__records__definition">LocationGroup</docanchor>
    <docanchor file="group__records__definition">LocationGroup_name</docanchor>
    <docanchor file="group__records__definition">LocationGroup_locationGroupType</docanchor>
    <docanchor file="group__records__definition">LocationGroup_systemTreeParent</docanchor>
    <docanchor file="group__records__definition">Location</docanchor>
    <docanchor file="group__records__definition">Location_name</docanchor>
    <docanchor file="group__records__definition">Location_locationType</docanchor>
    <docanchor file="group__records__definition">Location_numberOfEvents</docanchor>
    <docanchor file="group__records__definition">Location_locationGroup</docanchor>
    <docanchor file="group__records__definition">Region</docanchor>
    <docanchor file="group__records__definition">Region_name</docanchor>
    <docanchor file="group__records__definition">Region_canonicalName</docanchor>
    <docanchor file="group__records__definition">Region_description</docanchor>
    <docanchor file="group__records__definition">Region_regionRole</docanchor>
    <docanchor file="group__records__definition">Region_paradigm</docanchor>
    <docanchor file="group__records__definition">Region_regionFlags</docanchor>
    <docanchor file="group__records__definition">Region_sourceFile</docanchor>
    <docanchor file="group__records__definition">Region_beginLineNumber</docanchor>
    <docanchor file="group__records__definition">Region_endLineNumber</docanchor>
    <docanchor file="group__records__definition">Callsite</docanchor>
    <docanchor file="group__records__definition">Callsite_sourceFile</docanchor>
    <docanchor file="group__records__definition">Callsite_lineNumber</docanchor>
    <docanchor file="group__records__definition">Callsite_enteredRegion</docanchor>
    <docanchor file="group__records__definition">Callsite_leftRegion</docanchor>
    <docanchor file="group__records__definition">Callpath</docanchor>
    <docanchor file="group__records__definition">Callpath_parent</docanchor>
    <docanchor file="group__records__definition">Callpath_region</docanchor>
    <docanchor file="group__records__definition">Group</docanchor>
    <docanchor file="group__records__definition">Group_name</docanchor>
    <docanchor file="group__records__definition">Group_groupType</docanchor>
    <docanchor file="group__records__definition">Group_paradigm</docanchor>
    <docanchor file="group__records__definition">Group_groupFlags</docanchor>
    <docanchor file="group__records__definition">Group_numberOfMembers</docanchor>
    <docanchor file="group__records__definition">Group_members</docanchor>
    <docanchor file="group__records__definition">MetricMember</docanchor>
    <docanchor file="group__records__definition">MetricMember_name</docanchor>
    <docanchor file="group__records__definition">MetricMember_description</docanchor>
    <docanchor file="group__records__definition">MetricMember_metricType</docanchor>
    <docanchor file="group__records__definition">MetricMember_metricMode</docanchor>
    <docanchor file="group__records__definition">MetricMember_valueType</docanchor>
    <docanchor file="group__records__definition">MetricMember_base</docanchor>
    <docanchor file="group__records__definition">MetricMember_exponent</docanchor>
    <docanchor file="group__records__definition">MetricMember_unit</docanchor>
    <docanchor file="group__records__event">Metric</docanchor>
    <docanchor file="group__records__definition">MetricClass</docanchor>
    <docanchor file="group__records__definition">MetricClass_numberOfMetrics</docanchor>
    <docanchor file="group__records__definition">MetricClass_metricMembers</docanchor>
    <docanchor file="group__records__definition">MetricClass_metricOccurrence</docanchor>
    <docanchor file="group__records__definition">MetricClass_recorderKind</docanchor>
    <docanchor file="group__records__definition">MetricInstance</docanchor>
    <docanchor file="group__records__definition">MetricInstance_metricClass</docanchor>
    <docanchor file="group__records__definition">MetricInstance_recorder</docanchor>
    <docanchor file="group__records__definition">MetricInstance_metricScope</docanchor>
    <docanchor file="group__records__definition">MetricInstance_scope</docanchor>
    <docanchor file="group__records__definition">Comm</docanchor>
    <docanchor file="group__records__definition">Comm_name</docanchor>
    <docanchor file="group__records__definition">Comm_group</docanchor>
    <docanchor file="group__records__definition">Comm_parent</docanchor>
    <docanchor file="group__records__definition">Parameter</docanchor>
    <docanchor file="group__records__definition">Parameter_name</docanchor>
    <docanchor file="group__records__definition">Parameter_parameterType</docanchor>
    <docanchor file="group__records__definition">RmaWin</docanchor>
    <docanchor file="group__records__definition">RmaWin_name</docanchor>
    <docanchor file="group__records__definition">RmaWin_comm</docanchor>
    <docanchor file="group__records__definition">MetricClassRecorder</docanchor>
    <docanchor file="group__records__definition">MetricClassRecorder_metric</docanchor>
    <docanchor file="group__records__definition">MetricClassRecorder_recorder</docanchor>
    <docanchor file="group__records__definition">SystemTreeNodeProperty</docanchor>
    <docanchor file="group__records__definition">SystemTreeNodeProperty_systemTreeNode</docanchor>
    <docanchor file="group__records__definition">SystemTreeNodeProperty_name</docanchor>
    <docanchor file="group__records__definition">SystemTreeNodeProperty_type</docanchor>
    <docanchor file="group__records__definition">SystemTreeNodeProperty_value</docanchor>
    <docanchor file="group__records__definition">SystemTreeNodeDomain</docanchor>
    <docanchor file="group__records__definition">SystemTreeNodeDomain_systemTreeNode</docanchor>
    <docanchor file="group__records__definition">SystemTreeNodeDomain_systemTreeDomain</docanchor>
    <docanchor file="group__records__definition">LocationGroupProperty</docanchor>
    <docanchor file="group__records__definition">LocationGroupProperty_locationGroup</docanchor>
    <docanchor file="group__records__definition">LocationGroupProperty_name</docanchor>
    <docanchor file="group__records__definition">LocationGroupProperty_type</docanchor>
    <docanchor file="group__records__definition">LocationGroupProperty_value</docanchor>
    <docanchor file="group__records__definition">LocationProperty</docanchor>
    <docanchor file="group__records__definition">LocationProperty_location</docanchor>
    <docanchor file="group__records__definition">LocationProperty_name</docanchor>
    <docanchor file="group__records__definition">LocationProperty_type</docanchor>
    <docanchor file="group__records__definition">LocationProperty_value</docanchor>
    <docanchor file="group__records__definition">CartDimension</docanchor>
    <docanchor file="group__records__definition">CartDimension_name</docanchor>
    <docanchor file="group__records__definition">CartDimension_size</docanchor>
    <docanchor file="group__records__definition">CartDimension_cartPeriodicity</docanchor>
    <docanchor file="group__records__definition">CartTopology</docanchor>
    <docanchor file="group__records__definition">CartTopology_name</docanchor>
    <docanchor file="group__records__definition">CartTopology_communicator</docanchor>
    <docanchor file="group__records__definition">CartTopology_numberOfDimensions</docanchor>
    <docanchor file="group__records__definition">CartTopology_cartDimensions</docanchor>
    <docanchor file="group__records__definition">CartCoordinate</docanchor>
    <docanchor file="group__records__definition">CartCoordinate_cartTopology</docanchor>
    <docanchor file="group__records__definition">CartCoordinate_rank</docanchor>
    <docanchor file="group__records__definition">CartCoordinate_numberOfDimensions</docanchor>
    <docanchor file="group__records__definition">CartCoordinate_coordinates</docanchor>
    <docanchor file="group__records__definition">SourceCodeLocation</docanchor>
    <docanchor file="group__records__definition">SourceCodeLocation_file</docanchor>
    <docanchor file="group__records__definition">SourceCodeLocation_lineNumber</docanchor>
    <docanchor file="group__records__definition">CallingContext</docanchor>
    <docanchor file="group__records__definition">CallingContext_region</docanchor>
    <docanchor file="group__records__definition">CallingContext_sourceCodeLocation</docanchor>
    <docanchor file="group__records__definition">CallingContext_parent</docanchor>
    <docanchor file="group__records__definition">CallingContextProperty</docanchor>
    <docanchor file="group__records__definition">CallingContextProperty_callingContext</docanchor>
    <docanchor file="group__records__definition">CallingContextProperty_name</docanchor>
    <docanchor file="group__records__definition">CallingContextProperty_type</docanchor>
    <docanchor file="group__records__definition">CallingContextProperty_value</docanchor>
    <docanchor file="group__records__definition">InterruptGenerator</docanchor>
    <docanchor file="group__records__definition">InterruptGenerator_name</docanchor>
    <docanchor file="group__records__definition">InterruptGenerator_interruptGeneratorMode</docanchor>
    <docanchor file="group__records__definition">InterruptGenerator_base</docanchor>
    <docanchor file="group__records__definition">InterruptGenerator_exponent</docanchor>
    <docanchor file="group__records__definition">InterruptGenerator_period</docanchor>
    <docanchor file="group__records__definition">IoFileProperty</docanchor>
    <docanchor file="group__records__definition">IoFileProperty_ioFile</docanchor>
    <docanchor file="group__records__definition">IoFileProperty_name</docanchor>
    <docanchor file="group__records__definition">IoFileProperty_type</docanchor>
    <docanchor file="group__records__definition">IoFileProperty_value</docanchor>
    <docanchor file="group__records__definition">IoFile</docanchor>
    <docanchor file="group__records__definition">IoRegularFile</docanchor>
    <docanchor file="group__records__definition">IoRegularFile_name</docanchor>
    <docanchor file="group__records__definition">IoRegularFile_scope</docanchor>
    <docanchor file="group__records__definition">IoDirectory</docanchor>
    <docanchor file="group__records__definition">IoDirectory_name</docanchor>
    <docanchor file="group__records__definition">IoDirectory_scope</docanchor>
    <docanchor file="group__records__definition">IoHandle</docanchor>
    <docanchor file="group__records__definition">IoHandle_name</docanchor>
    <docanchor file="group__records__definition">IoHandle_file</docanchor>
    <docanchor file="group__records__definition">IoHandle_ioParadigm</docanchor>
    <docanchor file="group__records__definition">IoHandle_ioHandleFlags</docanchor>
    <docanchor file="group__records__definition">IoHandle_comm</docanchor>
    <docanchor file="group__records__definition">IoHandle_parent</docanchor>
    <docanchor file="group__records__definition">IoPreCreatedHandleState</docanchor>
    <docanchor file="group__records__definition">IoPreCreatedHandleState_ioHandle</docanchor>
    <docanchor file="group__records__definition">IoPreCreatedHandleState_mode</docanchor>
    <docanchor file="group__records__definition">IoPreCreatedHandleState_statusFlags</docanchor>
    <docanchor file="group__records__definition">CallpathParameter</docanchor>
    <docanchor file="group__records__definition">CallpathParameter_callpath</docanchor>
    <docanchor file="group__records__definition">CallpathParameter_parameter</docanchor>
    <docanchor file="group__records__definition">CallpathParameter_type</docanchor>
    <docanchor file="group__records__definition">CallpathParameter_value</docanchor>
  </compound>
  <compound kind="group">
    <name>records_event</name>
    <title>List of all event records</title>
    <filename>group__records__event.html</filename>
    <docanchor file="group__records__event">BufferFlush</docanchor>
    <docanchor file="group__records__event">BufferFlush_stopTime</docanchor>
    <docanchor file="group__records__event">MeasurementOnOff</docanchor>
    <docanchor file="group__records__event">MeasurementOnOff_measurementMode</docanchor>
    <docanchor file="group__records__event">Enter</docanchor>
    <docanchor file="group__records__event">Enter_region</docanchor>
    <docanchor file="group__records__event">Leave</docanchor>
    <docanchor file="group__records__event">Leave_region</docanchor>
    <docanchor file="group__records__event">MpiSend</docanchor>
    <docanchor file="group__records__event">MpiSend_receiver</docanchor>
    <docanchor file="group__records__event">MpiSend_communicator</docanchor>
    <docanchor file="group__records__event">MpiSend_msgTag</docanchor>
    <docanchor file="group__records__event">MpiSend_msgLength</docanchor>
    <docanchor file="group__records__event">MpiIsend</docanchor>
    <docanchor file="group__records__event">MpiIsend_receiver</docanchor>
    <docanchor file="group__records__event">MpiIsend_communicator</docanchor>
    <docanchor file="group__records__event">MpiIsend_msgTag</docanchor>
    <docanchor file="group__records__event">MpiIsend_msgLength</docanchor>
    <docanchor file="group__records__event">MpiIsend_requestID</docanchor>
    <docanchor file="group__records__event">MpiIsendComplete</docanchor>
    <docanchor file="group__records__event">MpiIsendComplete_requestID</docanchor>
    <docanchor file="group__records__event">MpiIrecvRequest</docanchor>
    <docanchor file="group__records__event">MpiIrecvRequest_requestID</docanchor>
    <docanchor file="group__records__event">MpiRecv</docanchor>
    <docanchor file="group__records__event">MpiRecv_sender</docanchor>
    <docanchor file="group__records__event">MpiRecv_communicator</docanchor>
    <docanchor file="group__records__event">MpiRecv_msgTag</docanchor>
    <docanchor file="group__records__event">MpiRecv_msgLength</docanchor>
    <docanchor file="group__records__event">MpiIrecv</docanchor>
    <docanchor file="group__records__event">MpiIrecv_sender</docanchor>
    <docanchor file="group__records__event">MpiIrecv_communicator</docanchor>
    <docanchor file="group__records__event">MpiIrecv_msgTag</docanchor>
    <docanchor file="group__records__event">MpiIrecv_msgLength</docanchor>
    <docanchor file="group__records__event">MpiIrecv_requestID</docanchor>
    <docanchor file="group__records__event">MpiRequestTest</docanchor>
    <docanchor file="group__records__event">MpiRequestTest_requestID</docanchor>
    <docanchor file="group__records__event">MpiRequestCancelled</docanchor>
    <docanchor file="group__records__event">MpiRequestCancelled_requestID</docanchor>
    <docanchor file="group__records__event">MpiCollectiveBegin</docanchor>
    <docanchor file="group__records__event">MpiCollectiveEnd</docanchor>
    <docanchor file="group__records__event">MpiCollectiveEnd_collectiveOp</docanchor>
    <docanchor file="group__records__event">MpiCollectiveEnd_communicator</docanchor>
    <docanchor file="group__records__event">MpiCollectiveEnd_root</docanchor>
    <docanchor file="group__records__event">MpiCollectiveEnd_sizeSent</docanchor>
    <docanchor file="group__records__event">MpiCollectiveEnd_sizeReceived</docanchor>
    <docanchor file="group__records__event">OmpFork</docanchor>
    <docanchor file="group__records__event">OmpFork_numberOfRequestedThreads</docanchor>
    <docanchor file="group__records__event">OmpJoin</docanchor>
    <docanchor file="group__records__event">OmpAcquireLock</docanchor>
    <docanchor file="group__records__event">OmpAcquireLock_lockID</docanchor>
    <docanchor file="group__records__event">OmpAcquireLock_acquisitionOrder</docanchor>
    <docanchor file="group__records__event">OmpReleaseLock</docanchor>
    <docanchor file="group__records__event">OmpReleaseLock_lockID</docanchor>
    <docanchor file="group__records__event">OmpReleaseLock_acquisitionOrder</docanchor>
    <docanchor file="group__records__event">OmpTaskCreate</docanchor>
    <docanchor file="group__records__event">OmpTaskCreate_taskID</docanchor>
    <docanchor file="group__records__event">OmpTaskSwitch</docanchor>
    <docanchor file="group__records__event">OmpTaskSwitch_taskID</docanchor>
    <docanchor file="group__records__event">OmpTaskComplete</docanchor>
    <docanchor file="group__records__event">OmpTaskComplete_taskID</docanchor>
    <docanchor file="group__records__event">Metric_metric</docanchor>
    <docanchor file="group__records__event">Metric_numberOfMetrics</docanchor>
    <docanchor file="group__records__event">Metric_typeIDs</docanchor>
    <docanchor file="group__records__event">Metric_metricValues</docanchor>
    <docanchor file="group__records__event">ParameterString</docanchor>
    <docanchor file="group__records__event">ParameterString_parameter</docanchor>
    <docanchor file="group__records__event">ParameterString_string</docanchor>
    <docanchor file="group__records__event">ParameterInt</docanchor>
    <docanchor file="group__records__event">ParameterInt_parameter</docanchor>
    <docanchor file="group__records__event">ParameterInt_value</docanchor>
    <docanchor file="group__records__event">ParameterUnsignedInt</docanchor>
    <docanchor file="group__records__event">ParameterUnsignedInt_parameter</docanchor>
    <docanchor file="group__records__event">ParameterUnsignedInt_value</docanchor>
    <docanchor file="group__records__event">RmaWinCreate</docanchor>
    <docanchor file="group__records__event">RmaWinCreate_win</docanchor>
    <docanchor file="group__records__event">RmaWinDestroy</docanchor>
    <docanchor file="group__records__event">RmaWinDestroy_win</docanchor>
    <docanchor file="group__records__event">RmaCollectiveBegin</docanchor>
    <docanchor file="group__records__event">RmaCollectiveEnd</docanchor>
    <docanchor file="group__records__event">RmaCollectiveEnd_collectiveOp</docanchor>
    <docanchor file="group__records__event">RmaCollectiveEnd_syncLevel</docanchor>
    <docanchor file="group__records__event">RmaCollectiveEnd_win</docanchor>
    <docanchor file="group__records__event">RmaCollectiveEnd_root</docanchor>
    <docanchor file="group__records__event">RmaCollectiveEnd_bytesSent</docanchor>
    <docanchor file="group__records__event">RmaCollectiveEnd_bytesReceived</docanchor>
    <docanchor file="group__records__event">RmaGroupSync</docanchor>
    <docanchor file="group__records__event">RmaGroupSync_syncLevel</docanchor>
    <docanchor file="group__records__event">RmaGroupSync_win</docanchor>
    <docanchor file="group__records__event">RmaGroupSync_group</docanchor>
    <docanchor file="group__records__event">RmaRequestLock</docanchor>
    <docanchor file="group__records__event">RmaRequestLock_win</docanchor>
    <docanchor file="group__records__event">RmaRequestLock_remote</docanchor>
    <docanchor file="group__records__event">RmaRequestLock_lockId</docanchor>
    <docanchor file="group__records__event">RmaRequestLock_lockType</docanchor>
    <docanchor file="group__records__event">RmaAcquireLock</docanchor>
    <docanchor file="group__records__event">RmaAcquireLock_win</docanchor>
    <docanchor file="group__records__event">RmaAcquireLock_remote</docanchor>
    <docanchor file="group__records__event">RmaAcquireLock_lockId</docanchor>
    <docanchor file="group__records__event">RmaAcquireLock_lockType</docanchor>
    <docanchor file="group__records__event">RmaTryLock</docanchor>
    <docanchor file="group__records__event">RmaTryLock_win</docanchor>
    <docanchor file="group__records__event">RmaTryLock_remote</docanchor>
    <docanchor file="group__records__event">RmaTryLock_lockId</docanchor>
    <docanchor file="group__records__event">RmaTryLock_lockType</docanchor>
    <docanchor file="group__records__event">RmaReleaseLock</docanchor>
    <docanchor file="group__records__event">RmaReleaseLock_win</docanchor>
    <docanchor file="group__records__event">RmaReleaseLock_remote</docanchor>
    <docanchor file="group__records__event">RmaReleaseLock_lockId</docanchor>
    <docanchor file="group__records__event">RmaSync</docanchor>
    <docanchor file="group__records__event">RmaSync_win</docanchor>
    <docanchor file="group__records__event">RmaSync_remote</docanchor>
    <docanchor file="group__records__event">RmaSync_syncType</docanchor>
    <docanchor file="group__records__event">RmaWaitChange</docanchor>
    <docanchor file="group__records__event">RmaWaitChange_win</docanchor>
    <docanchor file="group__records__event">RmaPut</docanchor>
    <docanchor file="group__records__event">RmaPut_win</docanchor>
    <docanchor file="group__records__event">RmaPut_remote</docanchor>
    <docanchor file="group__records__event">RmaPut_bytes</docanchor>
    <docanchor file="group__records__event">RmaPut_matchingId</docanchor>
    <docanchor file="group__records__event">RmaGet</docanchor>
    <docanchor file="group__records__event">RmaGet_win</docanchor>
    <docanchor file="group__records__event">RmaGet_remote</docanchor>
    <docanchor file="group__records__event">RmaGet_bytes</docanchor>
    <docanchor file="group__records__event">RmaGet_matchingId</docanchor>
    <docanchor file="group__records__event">RmaAtomic</docanchor>
    <docanchor file="group__records__event">RmaAtomic_win</docanchor>
    <docanchor file="group__records__event">RmaAtomic_remote</docanchor>
    <docanchor file="group__records__event">RmaAtomic_type</docanchor>
    <docanchor file="group__records__event">RmaAtomic_bytesSent</docanchor>
    <docanchor file="group__records__event">RmaAtomic_bytesReceived</docanchor>
    <docanchor file="group__records__event">RmaAtomic_matchingId</docanchor>
    <docanchor file="group__records__event">RmaOpCompleteBlocking</docanchor>
    <docanchor file="group__records__event">RmaOpCompleteBlocking_win</docanchor>
    <docanchor file="group__records__event">RmaOpCompleteBlocking_matchingId</docanchor>
    <docanchor file="group__records__event">RmaOpCompleteNonBlocking</docanchor>
    <docanchor file="group__records__event">RmaOpCompleteNonBlocking_win</docanchor>
    <docanchor file="group__records__event">RmaOpCompleteNonBlocking_matchingId</docanchor>
    <docanchor file="group__records__event">RmaOpTest</docanchor>
    <docanchor file="group__records__event">RmaOpTest_win</docanchor>
    <docanchor file="group__records__event">RmaOpTest_matchingId</docanchor>
    <docanchor file="group__records__event">RmaOpCompleteRemote</docanchor>
    <docanchor file="group__records__event">RmaOpCompleteRemote_win</docanchor>
    <docanchor file="group__records__event">RmaOpCompleteRemote_matchingId</docanchor>
    <docanchor file="group__records__event">ThreadFork</docanchor>
    <docanchor file="group__records__event">ThreadFork_model</docanchor>
    <docanchor file="group__records__event">ThreadFork_numberOfRequestedThreads</docanchor>
    <docanchor file="group__records__event">ThreadJoin</docanchor>
    <docanchor file="group__records__event">ThreadJoin_model</docanchor>
    <docanchor file="group__records__event">ThreadTeamBegin</docanchor>
    <docanchor file="group__records__event">ThreadTeamBegin_threadTeam</docanchor>
    <docanchor file="group__records__event">ThreadTeamEnd</docanchor>
    <docanchor file="group__records__event">ThreadTeamEnd_threadTeam</docanchor>
    <docanchor file="group__records__event">ThreadAcquireLock</docanchor>
    <docanchor file="group__records__event">ThreadAcquireLock_model</docanchor>
    <docanchor file="group__records__event">ThreadAcquireLock_lockID</docanchor>
    <docanchor file="group__records__event">ThreadAcquireLock_acquisitionOrder</docanchor>
    <docanchor file="group__records__event">ThreadReleaseLock</docanchor>
    <docanchor file="group__records__event">ThreadReleaseLock_model</docanchor>
    <docanchor file="group__records__event">ThreadReleaseLock_lockID</docanchor>
    <docanchor file="group__records__event">ThreadReleaseLock_acquisitionOrder</docanchor>
    <docanchor file="group__records__event">ThreadTaskCreate</docanchor>
    <docanchor file="group__records__event">ThreadTaskCreate_threadTeam</docanchor>
    <docanchor file="group__records__event">ThreadTaskCreate_creatingThread</docanchor>
    <docanchor file="group__records__event">ThreadTaskCreate_generationNumber</docanchor>
    <docanchor file="group__records__event">ThreadTaskSwitch</docanchor>
    <docanchor file="group__records__event">ThreadTaskSwitch_threadTeam</docanchor>
    <docanchor file="group__records__event">ThreadTaskSwitch_creatingThread</docanchor>
    <docanchor file="group__records__event">ThreadTaskSwitch_generationNumber</docanchor>
    <docanchor file="group__records__event">ThreadTaskComplete</docanchor>
    <docanchor file="group__records__event">ThreadTaskComplete_threadTeam</docanchor>
    <docanchor file="group__records__event">ThreadTaskComplete_creatingThread</docanchor>
    <docanchor file="group__records__event">ThreadTaskComplete_generationNumber</docanchor>
    <docanchor file="group__records__event">ThreadCreate</docanchor>
    <docanchor file="group__records__event">ThreadCreate_threadContingent</docanchor>
    <docanchor file="group__records__event">ThreadCreate_sequenceCount</docanchor>
    <docanchor file="group__records__event">ThreadBegin</docanchor>
    <docanchor file="group__records__event">ThreadBegin_threadContingent</docanchor>
    <docanchor file="group__records__event">ThreadBegin_sequenceCount</docanchor>
    <docanchor file="group__records__event">ThreadWait</docanchor>
    <docanchor file="group__records__event">ThreadWait_threadContingent</docanchor>
    <docanchor file="group__records__event">ThreadWait_sequenceCount</docanchor>
    <docanchor file="group__records__event">ThreadEnd</docanchor>
    <docanchor file="group__records__event">ThreadEnd_threadContingent</docanchor>
    <docanchor file="group__records__event">ThreadEnd_sequenceCount</docanchor>
    <docanchor file="group__records__event">CallingContextEnter</docanchor>
    <docanchor file="group__records__event">CallingContextEnter_callingContext</docanchor>
    <docanchor file="group__records__event">CallingContextEnter_unwindDistance</docanchor>
    <docanchor file="group__records__event">CallingContextLeave</docanchor>
    <docanchor file="group__records__event">CallingContextLeave_callingContext</docanchor>
    <docanchor file="group__records__event">CallingContextSample</docanchor>
    <docanchor file="group__records__event">CallingContextSample_callingContext</docanchor>
    <docanchor file="group__records__event">CallingContextSample_unwindDistance</docanchor>
    <docanchor file="group__records__event">CallingContextSample_interruptGenerator</docanchor>
    <docanchor file="group__records__event">IoCreateHandle</docanchor>
    <docanchor file="group__records__event">IoCreateHandle_handle</docanchor>
    <docanchor file="group__records__event">IoCreateHandle_mode</docanchor>
    <docanchor file="group__records__event">IoCreateHandle_creationFlags</docanchor>
    <docanchor file="group__records__event">IoCreateHandle_statusFlags</docanchor>
    <docanchor file="group__records__event">IoDestroyHandle</docanchor>
    <docanchor file="group__records__event">IoDestroyHandle_handle</docanchor>
    <docanchor file="group__records__event">IoDuplicateHandle</docanchor>
    <docanchor file="group__records__event">IoDuplicateHandle_oldHandle</docanchor>
    <docanchor file="group__records__event">IoDuplicateHandle_newHandle</docanchor>
    <docanchor file="group__records__event">IoDuplicateHandle_statusFlags</docanchor>
    <docanchor file="group__records__event">IoSeek</docanchor>
    <docanchor file="group__records__event">IoSeek_handle</docanchor>
    <docanchor file="group__records__event">IoSeek_offsetRequest</docanchor>
    <docanchor file="group__records__event">IoSeek_whence</docanchor>
    <docanchor file="group__records__event">IoSeek_offsetResult</docanchor>
    <docanchor file="group__records__event">IoChangeStatusFlags</docanchor>
    <docanchor file="group__records__event">IoChangeStatusFlags_handle</docanchor>
    <docanchor file="group__records__event">IoChangeStatusFlags_statusFlags</docanchor>
    <docanchor file="group__records__event">IoDeleteFile</docanchor>
    <docanchor file="group__records__event">IoDeleteFile_ioParadigm</docanchor>
    <docanchor file="group__records__event">IoDeleteFile_file</docanchor>
    <docanchor file="group__records__event">IoOperationBegin</docanchor>
    <docanchor file="group__records__event">IoOperationBegin_handle</docanchor>
    <docanchor file="group__records__event">IoOperationBegin_mode</docanchor>
    <docanchor file="group__records__event">IoOperationBegin_operationFlags</docanchor>
    <docanchor file="group__records__event">IoOperationBegin_bytesRequest</docanchor>
    <docanchor file="group__records__event">IoOperationBegin_matchingId</docanchor>
    <docanchor file="group__records__event">IoOperationTest</docanchor>
    <docanchor file="group__records__event">IoOperationTest_handle</docanchor>
    <docanchor file="group__records__event">IoOperationTest_matchingId</docanchor>
    <docanchor file="group__records__event">IoOperationIssued</docanchor>
    <docanchor file="group__records__event">IoOperationIssued_handle</docanchor>
    <docanchor file="group__records__event">IoOperationIssued_matchingId</docanchor>
    <docanchor file="group__records__event">IoOperationComplete</docanchor>
    <docanchor file="group__records__event">IoOperationComplete_handle</docanchor>
    <docanchor file="group__records__event">IoOperationComplete_bytesResult</docanchor>
    <docanchor file="group__records__event">IoOperationComplete_matchingId</docanchor>
    <docanchor file="group__records__event">IoOperationCancelled</docanchor>
    <docanchor file="group__records__event">IoOperationCancelled_handle</docanchor>
    <docanchor file="group__records__event">IoOperationCancelled_matchingId</docanchor>
    <docanchor file="group__records__event">IoAcquireLock</docanchor>
    <docanchor file="group__records__event">IoAcquireLock_handle</docanchor>
    <docanchor file="group__records__event">IoAcquireLock_lockType</docanchor>
    <docanchor file="group__records__event">IoReleaseLock</docanchor>
    <docanchor file="group__records__event">IoReleaseLock_handle</docanchor>
    <docanchor file="group__records__event">IoReleaseLock_lockType</docanchor>
    <docanchor file="group__records__event">IoTryLock</docanchor>
    <docanchor file="group__records__event">IoTryLock_handle</docanchor>
    <docanchor file="group__records__event">IoTryLock_lockType</docanchor>
    <docanchor file="group__records__event">ProgramBegin</docanchor>
    <docanchor file="group__records__event">ProgramBegin_programName</docanchor>
    <docanchor file="group__records__event">ProgramBegin_numberOfArguments</docanchor>
    <docanchor file="group__records__event">ProgramBegin_programArguments</docanchor>
    <docanchor file="group__records__event">ProgramEnd</docanchor>
    <docanchor file="group__records__event">ProgramEnd_exitStatus</docanchor>
  </compound>
  <compound kind="group">
    <name>records_marker</name>
    <title>List of all marker records</title>
    <filename>group__records__marker.html</filename>
    <docanchor file="group__records__marker">DefMarker</docanchor>
    <docanchor file="group__records__marker">DefMarker_markerGroup</docanchor>
    <docanchor file="group__records__marker">DefMarker_markerCategory</docanchor>
    <docanchor file="group__records__marker">DefMarker_severity</docanchor>
    <docanchor file="group__records__marker">Marker</docanchor>
    <docanchor file="group__records__marker">Marker_duration</docanchor>
    <docanchor file="group__records__marker">Marker_marker</docanchor>
    <docanchor file="group__records__marker">Marker_scope</docanchor>
    <docanchor file="group__records__marker">Marker_scopeRef</docanchor>
    <docanchor file="group__records__marker">Marker_text</docanchor>
  </compound>
  <compound kind="group">
    <name>records_snap</name>
    <title>List of all snapshot records</title>
    <filename>group__records__snap.html</filename>
    <docanchor file="group__records__snap">SnapshotStart</docanchor>
    <docanchor file="group__records__snap">SnapshotStart_numberOfRecords</docanchor>
    <docanchor file="group__records__snap">SnapshotEnd</docanchor>
    <docanchor file="group__records__snap">SnapshotEnd_contReadPos</docanchor>
    <docanchor file="group__records__snap">MeasurementOnOffSnap</docanchor>
    <docanchor file="group__records__snap">MeasurementOnOffSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">MeasurementOnOffSnap_measurementMode</docanchor>
    <docanchor file="group__records__snap">EnterSnap</docanchor>
    <docanchor file="group__records__snap">EnterSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">EnterSnap_region</docanchor>
    <docanchor file="group__records__snap">MpiSendSnap</docanchor>
    <docanchor file="group__records__snap">MpiSendSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">MpiSendSnap_receiver</docanchor>
    <docanchor file="group__records__snap">MpiSendSnap_communicator</docanchor>
    <docanchor file="group__records__snap">MpiSendSnap_msgTag</docanchor>
    <docanchor file="group__records__snap">MpiSendSnap_msgLength</docanchor>
    <docanchor file="group__records__snap">MpiIsendSnap</docanchor>
    <docanchor file="group__records__snap">MpiIsendSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">MpiIsendSnap_receiver</docanchor>
    <docanchor file="group__records__snap">MpiIsendSnap_communicator</docanchor>
    <docanchor file="group__records__snap">MpiIsendSnap_msgTag</docanchor>
    <docanchor file="group__records__snap">MpiIsendSnap_msgLength</docanchor>
    <docanchor file="group__records__snap">MpiIsendSnap_requestID</docanchor>
    <docanchor file="group__records__snap">MpiIsendCompleteSnap</docanchor>
    <docanchor file="group__records__snap">MpiIsendCompleteSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">MpiIsendCompleteSnap_requestID</docanchor>
    <docanchor file="group__records__snap">MpiRecvSnap</docanchor>
    <docanchor file="group__records__snap">MpiRecvSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">MpiRecvSnap_sender</docanchor>
    <docanchor file="group__records__snap">MpiRecvSnap_communicator</docanchor>
    <docanchor file="group__records__snap">MpiRecvSnap_msgTag</docanchor>
    <docanchor file="group__records__snap">MpiRecvSnap_msgLength</docanchor>
    <docanchor file="group__records__snap">MpiIrecvRequestSnap</docanchor>
    <docanchor file="group__records__snap">MpiIrecvRequestSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">MpiIrecvRequestSnap_requestID</docanchor>
    <docanchor file="group__records__snap">MpiIrecvSnap</docanchor>
    <docanchor file="group__records__snap">MpiIrecvSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">MpiIrecvSnap_sender</docanchor>
    <docanchor file="group__records__snap">MpiIrecvSnap_communicator</docanchor>
    <docanchor file="group__records__snap">MpiIrecvSnap_msgTag</docanchor>
    <docanchor file="group__records__snap">MpiIrecvSnap_msgLength</docanchor>
    <docanchor file="group__records__snap">MpiIrecvSnap_requestID</docanchor>
    <docanchor file="group__records__snap">MpiCollectiveBeginSnap</docanchor>
    <docanchor file="group__records__snap">MpiCollectiveBeginSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">MpiCollectiveEndSnap</docanchor>
    <docanchor file="group__records__snap">MpiCollectiveEndSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">MpiCollectiveEndSnap_collectiveOp</docanchor>
    <docanchor file="group__records__snap">MpiCollectiveEndSnap_communicator</docanchor>
    <docanchor file="group__records__snap">MpiCollectiveEndSnap_root</docanchor>
    <docanchor file="group__records__snap">MpiCollectiveEndSnap_sizeSent</docanchor>
    <docanchor file="group__records__snap">MpiCollectiveEndSnap_sizeReceived</docanchor>
    <docanchor file="group__records__snap">OmpForkSnap</docanchor>
    <docanchor file="group__records__snap">OmpForkSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">OmpForkSnap_numberOfRequestedThreads</docanchor>
    <docanchor file="group__records__snap">OmpAcquireLockSnap</docanchor>
    <docanchor file="group__records__snap">OmpAcquireLockSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">OmpAcquireLockSnap_lockID</docanchor>
    <docanchor file="group__records__snap">OmpAcquireLockSnap_acquisitionOrder</docanchor>
    <docanchor file="group__records__snap">OmpTaskCreateSnap</docanchor>
    <docanchor file="group__records__snap">OmpTaskCreateSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">OmpTaskCreateSnap_taskID</docanchor>
    <docanchor file="group__records__snap">OmpTaskSwitchSnap</docanchor>
    <docanchor file="group__records__snap">OmpTaskSwitchSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">OmpTaskSwitchSnap_taskID</docanchor>
    <docanchor file="group__records__snap">MetricSnap</docanchor>
    <docanchor file="group__records__snap">MetricSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">MetricSnap_metric</docanchor>
    <docanchor file="group__records__snap">MetricSnap_numberOfMetrics</docanchor>
    <docanchor file="group__records__snap">MetricSnap_typeIDs</docanchor>
    <docanchor file="group__records__snap">MetricSnap_metricValues</docanchor>
    <docanchor file="group__records__snap">ParameterStringSnap</docanchor>
    <docanchor file="group__records__snap">ParameterStringSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">ParameterStringSnap_parameter</docanchor>
    <docanchor file="group__records__snap">ParameterStringSnap_string</docanchor>
    <docanchor file="group__records__snap">ParameterIntSnap</docanchor>
    <docanchor file="group__records__snap">ParameterIntSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">ParameterIntSnap_parameter</docanchor>
    <docanchor file="group__records__snap">ParameterIntSnap_value</docanchor>
    <docanchor file="group__records__snap">ParameterUnsignedIntSnap</docanchor>
    <docanchor file="group__records__snap">ParameterUnsignedIntSnap_origEventTime</docanchor>
    <docanchor file="group__records__snap">ParameterUnsignedIntSnap_parameter</docanchor>
    <docanchor file="group__records__snap">ParameterUnsignedIntSnap_value</docanchor>
  </compound>
  <compound kind="page">
    <name>installationfile</name>
    <title>OTF2 INSTALL</title>
    <filename>installationfile</filename>
  </compound>
  <compound kind="page">
    <name>otf2_known_io_paradigms</name>
    <title>Known OTF2 I/O paradigms</title>
    <filename>group__io</filename>
    <docanchor file="group__io">POSIX</docanchor>
    <docanchor file="group__io">ISOC</docanchor>
    <docanchor file="group__io">MPI-IO</docanchor>
    <docanchor file="group__io">netCDF</docanchor>
    <docanchor file="group__io">PnetCDF</docanchor>
    <docanchor file="group__io">HDF5</docanchor>
    <docanchor file="group__io">ADIOS</docanchor>
  </compound>
  <compound kind="page">
    <name>otf2_io_operation_event_order</name>
    <title>Event order for I/O operation records</title>
    <filename>group__io</filename>
  </compound>
  <compound kind="page">
    <name>index</name>
    <title>Open Trace Format 2</title>
    <filename>index</filename>
    <docanchor file="index" title="Introduction">introduction</docanchor>
    <docanchor file="index" title="Get started">get_started</docanchor>
  </compound>
</tagfile>
