/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2016                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2015                                                     **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  Copyright (c) 2015                                                     **
**  RWTH Aachen University, JARA-HPC                                       **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


/*-------------------------------------------------------------------------*/
/**
 *  @file
 *  @ingroup CUBE_lib.network
 *  @brief   Definition of the class cube::Serializable
 **/
/*-------------------------------------------------------------------------*/


#include <config.h>

#include "CubeSerializable.h"

#include "CubeConnection.h"

using namespace cube;

namespace cube
{
// --- Serialization ------------------------------------------------------

void
Serializable::serialize(Connection& connection) const
{
    connection << this->get_serialization_key();
    pack(connection);
}
}    // namespace cube
