/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2016                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2015                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEPL0SCANNER_H
#define CUBEPL0SCANNER_H

// Flex expects the signature of yylex to be defined in the macro YY_DECL, and
// the C++ parser expects it to be declared. We can factor both as follows.

#ifndef YY_DECL

#define YY_DECL                                         \
    cubeplparser::CubePL0Parser::token_type                             \
    cubeplparser::CubePL0Scanner::lex(                          \
        cubeplparser::CubePL0Parser::semantic_type * yylval,             \
        cubeplparser::CubePL0Parser::location_type * yylloc              \
        )
#endif

#ifndef __FLEX_LEXER_H
//#define yyFlexLexer Cube3FlexLexer
#include "FlexLexer.h"
#undef yyFlexLexer
#endif

#include "CubePL0Parser.h"

namespace cubeplparser
{
/** Scanner is a derived class to add some extra function to the scanner
 * class. Flex itself creates a class named yyFlexLexer, which is renamed using
 * macros to CubeparserFlexLexer. However we change the context of the generated
 * yylex() function to be contained within the Scanner class. This is required
 * because the yylex() defined in yyFlexLexer has no parameters. */
class CubePL0Scanner : public yyFlexLexer
{
public:
    /** Create a new scanner object. The streams arg_yyin and arg_yyout default
     * to cin and cout, but that assignment is only made when initializing in
     * yylex(). */
    CubePL0Scanner( std::istream*        arg_yyin = 0,
                    std::ostream*        arg_yyout = 0,
                    CubePL0ParseContext* parseContext = NULL );

    /** Required for virtual functions */
    virtual
    ~CubePL0Scanner();

    /** This is the main lexing function. It is generated by flex according to
     * the macro declaration YY_DECL above. The generated bison parser then
     * calls this virtual function to fetch new tokens. */
    virtual CubePL0Parser::token_type
    lex(
        CubePL0Parser::semantic_type* yylval,
        CubePL0Parser::location_type* yylloc
        );

private:

    CubePL0ParseContext* parseContext;
};
} // namespace parser

#endif // SCANNER_H
