/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2016                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2015                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


/**
 * \file Cube4Scanner.h
 * \brief Provides a lixical analyzer for cube4 meta part.
 */

#ifndef CUBE4SCANNER_H
#define CUBE4SCANNER_H

// Flex expects the signature of yylex to be defined in the macro YY_DECL, and
// the C++ parser expects it to be declared. We can factor both as follows.

#ifndef YY_DECL

#define YY_DECL                                         \
    cubeparser::Cube4Parser::token_type                         \
    cubeparser::Cube4Scanner::lex(                              \
        cubeparser::Cube4Parser::semantic_type * yylval,         \
        cubeparser::Cube4Parser::location_type * yylloc          \
        )
#endif

#ifndef __FLEX_LEXER_H
//#define yyFlexLexer Cube4FlexLexer
#include "FlexLexer.h"
#undef yyFlexLexer
#endif

#include "Cube4Parser.h"
#include "Cube.h"
#include "CubeIstream.h"

namespace cubeparser
{
/** Scanner is a derived class to add some extra function to the scanner
 * class. Flex itself creates a class named yyFlexLexer, which is renamed using
 * macros to CubeparserFlexLexer. However we change the context of the generated
 * yylex() function to be contained within the Scanner class. This is required
 * because the yylex() defined in yyFlexLexer has no parameters. */
class Cube4Scanner : public yyFlexLexer
{
public:
    /** Create a new scanner object. The streams arg_yyin and arg_yyout default
     * to cin and cout, but that assignment is only made when initializing in
     * yylex(). */
    Cube4Scanner( cube::CubeIstream*     _stream = 0,
                  std::ostream*     arg_yyout = 0,
                  ParseContext*     parseContext = NULL,
                  class cube::Cube* cube_yyarg = NULL );

    /** Required for virtual functions */
    virtual
    ~Cube4Scanner();

    /** This is the main lexing function. It is generated by flex according to
     * the macro declaration YY_DECL above. The generated bison parser then
     * calls this virtual function to fetch new tokens. */
    virtual Cube4Parser::token_type
    lex(
        Cube4Parser::semantic_type* yylval,
        Cube4Parser::location_type* yylloc
        );

private:

    ParseContext* parseContext;
    cube::Cube*   cube;
    cube::CubeIstream * stream_in;
};
} // namespace cubeparser

#endif // Cube4SCANNER_H
