#define shmem_sum_int2_to_all_L shmem_sum_int2_to_all
#define shmem_sum_int2_to_all_U SHMEM_SUM_INT2_TO_ALL

#define shmem_sum_int4_to_all_L shmem_sum_int4_to_all
#define shmem_sum_int4_to_all_U SHMEM_SUM_INT4_TO_ALL

#define shmem_sum_int8_to_all_L shmem_sum_int8_to_all
#define shmem_sum_int8_to_all_U SHMEM_SUM_INT8_TO_ALL

#define shmem_sum_real4_to_all_L shmem_sum_real4_to_all
#define shmem_sum_real4_to_all_U SHMEM_SUM_REAL4_TO_ALL

#define shmem_sum_real8_to_all_L shmem_sum_real8_to_all
#define shmem_sum_real8_to_all_U SHMEM_SUM_REAL8_TO_ALL

#define shmem_sum_real16_to_all_L shmem_sum_real16_to_all
#define shmem_sum_real16_to_all_U SHMEM_SUM_REAL16_TO_ALL

#define shmem_prod_int2_to_all_L shmem_prod_int2_to_all
#define shmem_prod_int2_to_all_U SHMEM_PROD_INT2_TO_ALL

#define shmem_prod_int4_to_all_L shmem_prod_int4_to_all
#define shmem_prod_int4_to_all_U SHMEM_PROD_INT4_TO_ALL

#define shmem_prod_int8_to_all_L shmem_prod_int8_to_all
#define shmem_prod_int8_to_all_U SHMEM_PROD_INT8_TO_ALL

#define shmem_prod_real4_to_all_L shmem_prod_real4_to_all
#define shmem_prod_real4_to_all_U SHMEM_PROD_REAL4_TO_ALL

#define shmem_prod_real8_to_all_L shmem_prod_real8_to_all
#define shmem_prod_real8_to_all_U SHMEM_PROD_REAL8_TO_ALL

#define shmem_prod_real16_to_all_L shmem_prod_real16_to_all
#define shmem_prod_real16_to_all_U SHMEM_PROD_REAL16_TO_ALL

#define shmem_max_int2_to_all_L shmem_max_int2_to_all
#define shmem_max_int2_to_all_U SHMEM_MAX_INT2_TO_ALL

#define shmem_max_int4_to_all_L shmem_max_int4_to_all
#define shmem_max_int4_to_all_U SHMEM_MAX_INT4_TO_ALL

#define shmem_max_int8_to_all_L shmem_max_int8_to_all
#define shmem_max_int8_to_all_U SHMEM_MAX_INT8_TO_ALL

#define shmem_max_real4_to_all_L shmem_max_real4_to_all
#define shmem_max_real4_to_all_U SHMEM_MAX_REAL4_TO_ALL

#define shmem_max_real8_to_all_L shmem_max_real8_to_all
#define shmem_max_real8_to_all_U SHMEM_MAX_REAL8_TO_ALL

#define shmem_max_real16_to_all_L shmem_max_real16_to_all
#define shmem_max_real16_to_all_U SHMEM_MAX_REAL16_TO_ALL

#define shmem_min_int2_to_all_L shmem_min_int2_to_all
#define shmem_min_int2_to_all_U SHMEM_MIN_INT2_TO_ALL

#define shmem_min_int4_to_all_L shmem_min_int4_to_all
#define shmem_min_int4_to_all_U SHMEM_MIN_INT4_TO_ALL

#define shmem_min_int8_to_all_L shmem_min_int8_to_all
#define shmem_min_int8_to_all_U SHMEM_MIN_INT8_TO_ALL

#define shmem_min_real4_to_all_L shmem_min_real4_to_all
#define shmem_min_real4_to_all_U SHMEM_MIN_REAL4_TO_ALL

#define shmem_min_real8_to_all_L shmem_min_real8_to_all
#define shmem_min_real8_to_all_U SHMEM_MIN_REAL8_TO_ALL

#define shmem_min_real16_to_all_L shmem_min_real16_to_all
#define shmem_min_real16_to_all_U SHMEM_MIN_REAL16_TO_ALL

#define shmem_and_int2_to_all_L shmem_and_int2_to_all
#define shmem_and_int2_to_all_U SHMEM_AND_INT2_TO_ALL

#define shmem_and_int4_to_all_L shmem_and_int4_to_all
#define shmem_and_int4_to_all_U SHMEM_AND_INT4_TO_ALL

#define shmem_and_int8_to_all_L shmem_and_int8_to_all
#define shmem_and_int8_to_all_U SHMEM_AND_INT8_TO_ALL

#define shmem_or_int2_to_all_L shmem_or_int2_to_all
#define shmem_or_int2_to_all_U SHMEM_OR_INT2_TO_ALL

#define shmem_or_int4_to_all_L shmem_or_int4_to_all
#define shmem_or_int4_to_all_U SHMEM_OR_INT4_TO_ALL

#define shmem_or_int8_to_all_L shmem_or_int8_to_all
#define shmem_or_int8_to_all_U SHMEM_OR_INT8_TO_ALL

#define shmem_xor_int2_to_all_L shmem_xor_int2_to_all
#define shmem_xor_int2_to_all_U SHMEM_XOR_INT2_TO_ALL

#define shmem_xor_int4_to_all_L shmem_xor_int4_to_all
#define shmem_xor_int4_to_all_U SHMEM_XOR_INT4_TO_ALL

#define shmem_xor_int8_to_all_L shmem_xor_int8_to_all
#define shmem_xor_int8_to_all_U SHMEM_XOR_INT8_TO_ALL

#define shmem_xor_int8_to_all_L shmem_xor_int8_to_all
#define shmem_xor_int8_to_all_U SHMEM_XOR_INT8_TO_ALL

#define shmem_sum_comp4_to_all_L shmem_sum_comp4_to_all
#define shmem_sum_comp4_to_all_U SHMEM_SUM_COMP4_TO_ALL

#define shmem_sum_comp8_to_all_L shmem_sum_comp8_to_all
#define shmem_sum_comp8_to_all_U SHMEM_SUM_COMP8_TO_ALL

#define shmem_prod_comp4_to_all_L shmem_prod_comp4_to_all
#define shmem_prod_comp4_to_all_U SHMEM_PROD_COMP4_TO_ALL

#define shmem_prod_comp8_to_all_L shmem_prod_comp8_to_all
#define shmem_prod_comp8_to_all_U SHMEM_PROD_COMP8_TO_ALL



/* *INDENT-OFF* */

#define SHMEM_FORTRAN_REDUCTION( OP, F_FUNCNAME, C_FUNCNAME, DATATYPE )         \
    void                                                                        \
    FSUB( shmem_ ## F_FUNCNAME ## _ ## OP ## _to_all )( DATATYPE *target,       \
                                                        DATATYPE *source,       \
                                                        int      *nReduce,      \
                                                        int      *peStart,      \
                                                        int      *logPeStride,  \
                                                        int      *peSize,       \
                                                        DATATYPE *pWork,        \
                                                        int      *pSync )       \
    {                                                                           \
        SCOREP_IN_MEASUREMENT_INCREMENT();                                      \
        shmem_ ## C_FUNCNAME ## _ ## OP ## _to_all ( target,                    \
                                                     source,                    \
                                                     *nReduce,                  \
                                                     *peStart,                  \
                                                     *logPeStride,              \
                                                     *peSize,                   \
                                                     pWork,                     \
                                                     ( long * ) pSync );        \
        SCOREP_IN_MEASUREMENT_DECREMENT();                                      \
    }

/* *INDENT-ON* */

#if SHMEM_HAVE_DECL( SHMEM_SHORT_SUM_TO_ALL )
SHMEM_FORTRAN_REDUCTION( sum,  int2,   short,      short )
#endif
#if SHMEM_HAVE_DECL( SHMEM_INT_SUM_TO_ALL )
SHMEM_FORTRAN_REDUCTION( sum,  int4,   int,        int )
#endif
#if SHMEM_HAVE_DECL( SHMEM_LONG_SUM_TO_ALL )
SHMEM_FORTRAN_REDUCTION( sum,  int8,   long,       long )
#endif
#if SHMEM_HAVE_DECL( SHMEM_FLOAT_SUM_TO_ALL )
SHMEM_FORTRAN_REDUCTION( sum,  real4,  float,      float )
#endif
#if SHMEM_HAVE_DECL( SHMEM_DOUBLE_SUM_TO_ALL )
SHMEM_FORTRAN_REDUCTION( sum,  real8,  double,     double )
#endif
#if SHMEM_HAVE_DECL( SHMEM_LONGDOUBLE_SUM_TO_ALL )
SHMEM_FORTRAN_REDUCTION( sum,  real16, longdouble, long double )
#endif
#if SHMEM_HAVE_DECL( SHMEM_COMPLEXF_SUM_TO_ALL )
SHMEM_FORTRAN_REDUCTION( sum,  comp4,  complexf,   float complex )
#endif
#if SHMEM_HAVE_DECL( SHMEM_COMPLEXD_SUM_TO_ALL )
SHMEM_FORTRAN_REDUCTION( sum,  comp8,  complexd,   double complex )
#endif
#if SHMEM_HAVE_DECL( SHMEM_SHORT_PROD_TO_ALL )
SHMEM_FORTRAN_REDUCTION( prod, int2,   short,      short )
#endif
#if SHMEM_HAVE_DECL( SHMEM_INT_PROD_TO_ALL )
SHMEM_FORTRAN_REDUCTION( prod, int4,   int,        int )
#endif
#if SHMEM_HAVE_DECL( SHMEM_LONG_PROD_TO_ALL )
SHMEM_FORTRAN_REDUCTION( prod, int8,   long,       long )
#endif
#if SHMEM_HAVE_DECL( SHMEM_FLOAT_PROD_TO_ALL )
SHMEM_FORTRAN_REDUCTION( prod, real4,  float,      float )
#endif
#if SHMEM_HAVE_DECL( SHMEM_DOUBLE_PROD_TO_ALL )
SHMEM_FORTRAN_REDUCTION( prod, real8,  double,     double )
#endif
#if SHMEM_HAVE_DECL( SHMEM_LONGDOUBLE_PROD_TO_ALL )
SHMEM_FORTRAN_REDUCTION( prod, real16, longdouble, long double )
#endif
#if SHMEM_HAVE_DECL( SHMEM_COMPLEXF_PROD_TO_ALL )
SHMEM_FORTRAN_REDUCTION( prod, comp4,  complexf,   float complex )
#endif
#if SHMEM_HAVE_DECL( SHMEM_COMPLEXD_PROD_TO_ALL )
SHMEM_FORTRAN_REDUCTION( prod, comp8,  complexd,   double complex )
#endif
#if SHMEM_HAVE_DECL( SHMEM_SHORT_MAX_TO_ALL )
SHMEM_FORTRAN_REDUCTION( max,  int2,   short,      short )
#endif
#if SHMEM_HAVE_DECL( SHMEM_INT_MAX_TO_ALL )
SHMEM_FORTRAN_REDUCTION( max,  int4,   int,        int )
#endif
#if SHMEM_HAVE_DECL( SHMEM_LONG_MAX_TO_ALL )
SHMEM_FORTRAN_REDUCTION( max,  int8,   long,       long )
#endif
#if SHMEM_HAVE_DECL( SHMEM_FLOAT_MAX_TO_ALL )
SHMEM_FORTRAN_REDUCTION( max,  real4,  float,      float )
#endif
#if SHMEM_HAVE_DECL( SHMEM_DOUBLE_MAX_TO_ALL )
SHMEM_FORTRAN_REDUCTION( max,  real8,  double,     double )
#endif
#if SHMEM_HAVE_DECL( SHMEM_LONGDOUBLE_MAX_TO_ALL )
SHMEM_FORTRAN_REDUCTION( max,  real16, longdouble, long double )
#endif
#if SHMEM_HAVE_DECL( SHMEM_SHORT_MIN_TO_ALL )
SHMEM_FORTRAN_REDUCTION( min,  int2,   short,      short )
#endif
#if SHMEM_HAVE_DECL( SHMEM_INT_MIN_TO_ALL )
SHMEM_FORTRAN_REDUCTION( min,  int4,   int,        int )
#endif
#if SHMEM_HAVE_DECL( SHMEM_LONG_MIN_TO_ALL )
SHMEM_FORTRAN_REDUCTION( min,  int8,   long,       long )
#endif
#if SHMEM_HAVE_DECL( SHMEM_FLOAT_MIN_TO_ALL )
SHMEM_FORTRAN_REDUCTION( min,  real4,  float,      float )
#endif
#if SHMEM_HAVE_DECL( SHMEM_DOUBLE_MIN_TO_ALL )
SHMEM_FORTRAN_REDUCTION( min,  real8,  double,     double )
#endif
#if SHMEM_HAVE_DECL( SHMEM_LONGDOUBLE_MIN_TO_ALL )
SHMEM_FORTRAN_REDUCTION( min,  real16, longdouble, long double )
#endif
#if SHMEM_HAVE_DECL( SHMEM_SHORT_AND_TO_ALL )
SHMEM_FORTRAN_REDUCTION( and,  int2,   short,      short )
#endif
#if SHMEM_HAVE_DECL( SHMEM_INT_AND_TO_ALL )
SHMEM_FORTRAN_REDUCTION( and,  int4,   int,        int )
#endif
#if SHMEM_HAVE_DECL( SHMEM_LONG_AND_TO_ALL )
SHMEM_FORTRAN_REDUCTION( and,  int8,   long,       long )
#endif
#if SHMEM_HAVE_DECL( SHMEM_SHORT_OR_TO_ALL )
SHMEM_FORTRAN_REDUCTION( or,   int2,   short,      short )
#endif
#if SHMEM_HAVE_DECL( SHMEM_INT_OR_TO_ALL )
SHMEM_FORTRAN_REDUCTION( or,   int4,   int,        int )
#endif
#if SHMEM_HAVE_DECL( SHMEM_LONG_OR_TO_ALL )
SHMEM_FORTRAN_REDUCTION( or,   int8,   long,       long )
#endif
#if SHMEM_HAVE_DECL( SHMEM_SHORT_XOR_TO_ALL )
SHMEM_FORTRAN_REDUCTION( xor,  int2,   short,      short )
#endif
#if SHMEM_HAVE_DECL( SHMEM_INTT_XOR_TO_ALL )
SHMEM_FORTRAN_REDUCTION( xor,  int4,   int,        int )
#endif
#if SHMEM_HAVE_DECL( SHMEM_LONG_XOR_TO_ALL )
SHMEM_FORTRAN_REDUCTION( xor,  int8,   long,       long )
#endif
